/**********************************************************************/
/*                                                                    */
/*  File:          mailsound.c                                        */
/*  Author:        Andrew W. Scherpbier                               */
/*  Version:       1.00                                               */
/*  Created:       26 Oct 1992                     		      */
/*                                                                    */
/*  Copyright (c) 1991, 1992 Andrew Scherpbier                        */
/*                All Rights Reserved.                                */
/*                                                                    */
/*                                                                    */
/*--------------------------------------------------------------------*/
/*  Description:  Play different sounds depending on where mail from  */
/*                                                                    */
/**********************************************************************/

#include <stdio.h>
#include <ctype.h>
#include <string.h>
#include <rplay.h>
#include <pwd.h>

#define	PUBLIC
#define	PRIVATE		static

#define	TRUE		(1)
#define	FALSE		(0)

#define	OK		(0)
#define	NOTOK		(-1)

#define	when		break;case
#define	orwhen		case
#define	otherwise	break;default

/* Private routines
 * ================
 */
PRIVATE compare(char *buffer, char *from);
PRIVATE play_sound(char *sound);

/* Private variables
 * =================
 */
PRIVATE char	*hostname;

/* Public routines
 * ===============
 */

/* Public variables
 * ================
 */

/**************************************************************************
 * PUBLIC main(int ac, char **av)
 * PURPOSE:
 *   None
 */
PUBLIC main(int ac, char **av)
{
	char		buffer[1000];
	char		buffer2[200];
	char		path[200];
	char		*p;
	FILE		*fl;
	struct passwd	*pw;

	if (ac == 2)
		hostname = av[1];
	else
		hostname = "localhost";

	pw = getpwuid(getuid());
	gets(buffer);
	strtok(buffer, " ");
	p = strtok(NULL, " \t\n");

	sprintf(path, "%s/.mailsounds", pw->pw_dir);
	fl = fopen(path, "r");
	if (fl == NULL)
		exit(0);

	while (fgets(buffer2, 200, fl) != NULL)
	{
		compare(buffer2, p);
	}

	play_sound(av[1]);
	fclose(fl);
	exit(0);
}


/**************************************************************************
 * PRIVATE compare(char *buffer, char *from)
 * PURPOSE:
 *   None
 * PARAMETERS:
 *   None
 */
PRIVATE compare(char *buffer, char *from)
{
	char	*pattern, *sound;
	char	*p;

	pattern = strtok(buffer, " \t");
	sound = strtok(NULL, "\n \t");
	if (re_comp(pattern) != NULL)
		return;
	if (re_exec(from))
	{
		play_sound(sound);
		exit(0);
	}
}


/**************************************************************************
 * PRIVATE play_sound(char *sound)
 * PURPOSE:
 *   None
 * PARAMETERS:
 *   None
 */
PRIVATE play_sound(char *sound)
{
	RPLAY	*rp;
	int	rplay_fd;

	rplay_fd = rplay_open(hostname);

	rp = rplay_create(RPLAY_PLAY);
	if (rp == NULL)
	{
		rplay_perror("mailsound");
		exit(1);
	}

	rplay_set(rp, RPLAY_APPEND,
		RPLAY_SOUND,		sound,
		NULL);

	rplay(rplay_fd, rp);

	rplay_close(rplay_fd);
	rplay_destroy(rp);
}
