<!--
Filename:       README.md
Author:         Shiro Takeda
e-mail          <shiro.takeda@gmail.com>
First-written:  <2017-07-30>
-->

econ.bst
==============================

`econ.bst` is a BibTeX style file for economics. It provids the following
features:

* The author-year type citation (you need `natbib.sty` as well).
* Reference style used in economics papers (`econ.bst` is not a BibTeX style for a specific journal).
* Highly customizable.  You can easily customize reference style as you wish.
* You can use "certified random order" proposed by [Ray ⓡ Robson (2018), AER](http://dx.doi.org/10.1257/aer.20161492).


## Explanation of files

| File                                   | Explanation                                |
|:---------------------------------------|:-------------------------------------------|
| `econ.bst`                             | This is the main bst file.                 |
| `econ-example.tex`                     | This file explains how to use econ.bst.    |
| [`econ-example.pdf`](econ-example.pdf) | A PDF file created fom `econ-example.tex`. |
| `econ-example.bib`                     | This is a bibliography database file.      |
| [`customization`](customization)       | This folder contains customized bst files. |
| [`CHANGES.md`](CHANGES.md)             | Changelog file.                            |
| `README.md`                            | This file.                                 |


## Lisence 

The texts file contained in this package may be distributed and/or modified
under the conditions of the LaTeX Project Public License, either version 1.3c of
this license or (at your option) any later version.  The latest version of this
license is in https://www.latex-project.org/lppl.txt and version 1.3c or later
is part of all distributions of LaTeX version 2008 or later.

This work has the LPPL maintenance status "maintained".

The Current Maintainer of this work is Shiro Takeda.


<!--
--------------------
Local Variables:
mode: markdown
fill-column: 80
coding: utf-8
End:
-->


