## -*-Tcl-*-
 # ###################################################################
 #	Vince's	Additions -	an extension package for Alpha
 # 
 #	FILE: "elecBindings.tcl"
 #	 				  created: 24/7/97 {6:03:56 pm}	
 #	      			      last update: 25/2/1999 {7:28:40 pm}	
 #	Author:	Vince Darley
 #	E-mail:	<darley@fas.harvard.edu>
 #	  mail:	Division of	Applied	Sciences, Harvard University
 #			Oxford Street, Cambridge MA	02138, USA
 #	   www:	<http://www.fas.harvard.edu/~darley/>
 #	
 #	Declares all the global variables for the electric procedures,
 #	and sets up bindings, traces, so it all works.
 # ###################################################################
 ##

alpha::extension elecBindings 9.0 {
    ensureset electricBindings 0
    array set keys::specialProcs { 
	"Complete Or Tab" "bind::TabOrComplete"
	"Expand" "bind::Expansion"
    }
    # set up some bindings if they don't exist
    if {![info exists "keys::specialBindings(Expand)"]} {
	set "keys::specialBindings(Expand)" ""
    }
    if {![info exists "keys::specialBindings(Complete Or Tab)"]} {
	set "keys::specialBindings(Complete Or Tab)" ""
    }
    hook::register specialKeys elec::keyBindings
} maintainer {
    "Vince Darley" darley@fas.harvard.edu <http://www.fas.harvard.edu/~darley/>
} uninstall this-file help {file "ElecCompletions Help"}

proc elec::presetKeyBindings {set} {
    global keys::specialBindings
    switch -- $set {
	0 {
	    array set keys::specialBindings {
		"Next Stop Or Indent" "/c"
		"Complete" "<O/c"
		"Expand" "<O/ "
		"Prev Stop" "<U/c"
		"Real Tab" "<I/c"
		"nth Stop" "<B/c"
		"Clear All Stops" "<U<B/c"
		"Next Stop" ""
		"Complete Or Tab" ""
	    }
	}
	1 {
	    array set keys::specialBindings {
		"Next Stop Or Indent" ""
		"Complete" ""
		"Expand" "<O/ "
		"Prev Stop" "<U<B/J"
		"Real Tab" "<I/c"
		"nth Stop" "<B/c"
		"Clear All Stops" "<U<B/c"
		"Next Stop" "<B/J"
		"Complete Or Tab" "/c"
	    }
	}
	2 {
	    array set keys::specialBindings {
		"Next Stop Or Indent" ""
		"Complete" ""
		"Expand" ""
		"Prev Stop" ""
		"Real Tab" ""
		"nth Stop" ""
		"Clear All Stops" ""
		"Next Stop" ""
		"Complete Or Tab" ""
	    }
	}
	
    }
}

proc elec::keyBindings {} {
    global electricBindings modifiedVars
    
    set l [list {Cmd-tab (invokes), tab + modifiers (moves)} \
      {Tab key (invokes), j + modifiers (moves)} \
      {A 'clean slate' to build a custom keyset}]
    set text [lindex {
	"use 'cmd-Tab' to invoke completions and 'Tab' (+modifiers) to move amongst template stops."
	"use 'Tab' to invoke completions and 'j' (+modifiers) to move amongst template stops."
	"are based upon a user-defined set."
    } $electricBindings]
    set b [dialog::optionMenu \
      "Special keys binding-sets:\r\rYour current key-bindings $text\
      From the pop-up below, you may make adjustments to those bindings,\
      or reset them to one of the standard sets\
      (and then make any desired adjustments)." \
      [concat [list "Adjust current set" "-"] $l] "" 1]
    
    if {$b != 0} {
	set electricBindings [incr b -1]
	elec::presetKeyBindings $electricBindings
	lappend modifiedVars electricBindings
    }
    hook::callAll electricBindings *
    return
}


