## -*-Tcl-*-
 # ###################################################################
 #  AlphaTk - the ultimate editor
 # 
 #  FILE: "alpha_startup.tcl"
 #                                    created: 04/08/98 {21:52:56 PM} 
 #                                last update: 1999-09-06T08:53:53Z 
 #  Author: Vince Darley
 #  E-mail: vince@santafe.edu
 #    mail: 317 Paseo de Peralta, Santa Fe, NM 87501
 #     www: http://www.santafe.edu/~vince
 #  
 # Copyright (c) 1998-1999  Vince Darley
 # 
 # See the file "license.terms" for information on usage and redistribution
 # of this file, and for a DISCLAIMER OF ALL WARRANTIES.
 #  Description: 
 # 
 #  History
 # 
 #  modified by  rev reason
 #  -------- --- --- -----------
 #  04/08/98 VMD 1.0 original
 # ###################################################################
 ##
# version - Return string of the form "5.31 for ppc, released...".
proc version {args} { return "7.3a6, for Tk, pre-release" }

set ALPHA [info nameofexecutable]
namespace eval alpha {}

proc alpha::thanks {} {
    set l [list "Pete Keleher" "Jon Guyer" "Johan Linde" \
      "Tom Scavo" "Tom Pollard" "Tom Fetherston" "Mark Nagata" "Juan Falgeras"\
      "Jim Ingham"]
    return [lsort -dictionary -index 1 $l]
}

proc alpha::findColours {} {
    variable colours
    toplevel .test ; wm withdraw .test
    ::menu .test.m ; ::button .test.b
    update
    set colours(activebackground) [.test.m cget -activebackground]
    set colours(activeforeground) [.test.m cget -activeforeground]
    set colours(background) [.test.b cget -background]
    destroy .test
}

proc alpha::makeStartup {{win .startup}} {
    variable colours
    if {![winfo exists $win]} {
	toplevel $win ; wm overrideredirect $win 1
    } elseif {[winfo toplevel $win] == $win} {
	catch {destroy $win}
	toplevel $win ; wm overrideredirect $win 1
    }
    global tk_library
    frame $win.f -highlightbackground $colours(activebackground) -highlightthickness 10 \
      -bd 5
    pack $win.f -fill both -expand yes
    image create photo logo -file [file join $tk_library images pwrdLogo150.gif]
    label $win.f.ll -image logo
    pack $win.f.ll -side left
    label $win.f.l -text "AlphaTk --- the Programmer's Editor" -font "Times 16"
    label $win.f.v -text [version]
    label $win.f.au -text "Implemented by Vince Darley" -font "Times 12"
    label $win.f.au2 -text "Redistribution permitted only under terms of included license." -font "Times 12"
    label $win.f.au3 -text "Core code copyright (c) Vince Darley 1998-1999\nall rights reserved." -font "Times 12"
    text $win.f.au4 -wrap word -height 3 -width 60 -bg [$win.f.au3 cget -bg] \
      -relief flat 
    $win.f.au4 insert insert "Many thanks to [join [alpha::thanks] {, }] for their help, fixes\
      and contributions."
    $win.f.au4 configure -state disabled
    pack $win.f.l $win.f.v $win.f.au $win.f.au2 $win.f.au3 $win.f.au4 -side top
    set h [winfo screenheight .]
    set w [winfo screenwidth .]
    set win [winfo toplevel $win]
    wm withdraw $win
    update idletasks
    wm geometry $win +[expr {([winfo screenwidth .]-[winfo reqwidth $win])/2}]+[expr {([winfo screenheight .]-[winfo reqheight $win])/2}]
    update
    wm deiconify $win
    raise $win
    update
    wm geometry $win +[expr {([winfo screenwidth .]-[winfo reqwidth $win])/2}]+[expr {([winfo screenheight .]-[winfo reqheight $win])/2}]
}
    
proc startupText {text} {
    if {[winfo exists .startup.f.v]} {
	.startup.f.v configure -text $text
    }
}

alpha::findColours
alpha::makeStartup
# make .status

proc alpha::makeStatus {} {
    global tcl_platform
    if {![winfo exists .status]} {
	if {$tcl_platform(os) == "MacOS"} {
	    toplevel .status ; unsupported1 style .status plainDBox
	} else {
	    toplevel .status ; wm overrideredirect .status 1
	}
	update
	set h [winfo screenheight .]
	set w [winfo screenwidth .]
	wm geometry .status ${w}x20+0+[expr {$h - 18}]
	wm geometry . ${w}x0+0+0
	update
	label .status.text -text ""
	pack .status.text -side left
	button .status.dump -text "trace" -command alpha_stackdump
	pack .status.dump -side right
	update
    }
}

proc alpha::resizeMenuBar {} {
    wm resizable . 1 0
    global tcl_platform
    if {$tcl_platform(platform) != "macintosh"} {
	if {![catch {.menubar.system index "Resize"}]} {
	    .menubar.system delete "Resize"
	}
	.menubar.system add command -label "Fix size" -command alpha::fixMenuBarSize
	if {$tcl_platform(platform) == "windows"} {
	    # These two lines are required to work around a windows bug
	    catch {.menubar delete tmp}
	    .menubar add cascade -menu .menubar.system -label tmp
	}
    }
}

proc alpha::fixMenuBarSize {} {
    wm resizable . 0 0
    global tcl_platform
    if {$tcl_platform(platform) != "macintosh"} {
	if {![catch {.menubar.system index "Fix size"}]} {
	    .menubar.system delete "Fix size"
	}
	.menubar.system add command -label "Resize" -command alpha::resizeMenuBar
	if {$tcl_platform(platform) == "windows"} {
	    # These two lines are required to work around a windows bug
	    catch {.menubar delete tmp}
	    .menubar add cascade -menu .menubar.system -label tmp
	}
    }
}


alpha::makeStatus

if {![winfo exists .menubar]} {
    menu .menubar
    wm title . "AlphaTk"
    bindtags . [concat Alpha [bindtags .]]
    #bindtags . [concat Alpha AlphaMenu [bindtags .]]
    . configure -menu .menubar
    menu .menubar.help -tearoff 0
    .menubar add cascade -menu .menubar.help -label "Help"
    bind . <<Destroy>> quit
    wm protocol . WM_DELETE_WINDOW quit
    bind . <Unmap> alpha::iconifyAll
    bind . <Map> "alpha::iconifyAll 0"
    switch -- $tcl_platform(platform) {
	"macintosh" {
	    menu .menubar.apple -tearoff 0
	}
	"windows" {
	    menu .menubar.system -tearoff 0
	}
	"unix" {
	    menu .menubar.system -tearoff 0
	}
    }
}

proc alpha::makeSystemMenu {} {
    global tcl_platform
    switch -- $tcl_platform(platform) {
	"macintosh" {
	    .menubar add cascade -menu .menubar.apple
	    .menubar.apple add command -label "About AlphaTk" -command "alpha::about"
	}
	"windows" {
	    .menubar.help insert 0 command -label "About AlphaTk..." -command "alpha::about"
	    # This update is absolutely required on WinNT at least, or
	    # the .menubar.system menu will not have its contents added
	    # to the system menu.
	    update idletasks
	    fixMenuBarSize
	}
	"unix" {
	    .menubar.help insert 0 command -label "About AlphaTk..." -command "alpha::about"
	    #.menubar.system add command -label "About AlphaTk..." -command "alpha::about"	    
	    #.menubar insert 1 cascade -menu .menubar.system -label "Alpha"
	    update idletasks
	    fixMenuBarSize
	}
    }
}


proc alpha::about {} {
    if {[winfo exists .about]} {
	catch {destroy .about}
    }
    toplevel .about ; wm overrideredirect .about 1
    pack [frame .about.startup] -fill both -expand yes -side top -padx 5 -pady 5
    pack [frame .about.b] -fill x -expand yes -side bottom -pady 5
    button .about.b.ok -text "Ok" -command "destroy .about ; set alphaPriv(done) 1"
    pack .about.b.ok -expand 1 -side left
    button .about.b.help -text "Help" -command "destroy .about ; set alphaPriv(done) 1; alphaHelp"
    pack .about.b.help -expand 1 -side left
    button .about.b.register -text "Register" -command "destroy .about ; set alphaPriv(done) 1; register"
    pack .about.b.register -expand 1 -side right
    alpha::makeStartup .about.startup
    global alphaPriv
    vwait alphaPriv(done)
}

proc alpha::iconifyAll {{icon 1}} {
    foreach w [array names win::tk] {
	set ww $win::tk($w)
	if {[winfo exists $ww]} {
	    if {$icon} {
		wm iconify [winfo toplevel $ww]
	    } else {
		wm deiconify [winfo toplevel $ww]
	    }
	}
    }
}

namespace eval hook {}

# pre-register this proc to be called after startup
set hook::startupHook(*) [list \
  alpha::makeSystemMenu \
  alpha::startup \
  "destroy .startup"]

set hook::openHook(*) win::openHook
























