/*
 * Decompiled with CFR 0.152.
 */
package de.tu_darmstadt.sp.pdftools;

import de.tu_darmstadt.sp.paul.PDFDictionary;
import de.tu_darmstadt.sp.paul.PDFInteger;
import de.tu_darmstadt.sp.paul.PDFName;
import de.tu_darmstadt.sp.paul.PDFObject;
import de.tu_darmstadt.sp.paul.PDFOutputStream;
import de.tu_darmstadt.sp.pdftools.PPMImage;
import de.tu_darmstadt.sp.pudl.Document;
import de.tu_darmstadt.sp.pudl.Page;
import gnu.getopt.Getopt;
import gnu.getopt.LongOpt;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;

public class ThumbGen {
    public static final String PROGRAM = "PDFThumb";
    public static final String VERSION = "0.1";
    private static final String shortOpts = "d:rqhV";
    private static final LongOpt[] longOpts = new LongOpt[]{new LongOpt("dpi", 1, null, 100), new LongOpt("remove", 0, null, 114), new LongOpt("quiet", 0, null, 113), new LongOpt("help", 0, null, 104), new LongOpt("version", 0, null, 86)};
    private static int verbosityLevel = 1;

    static void attachThumbnail(Page page, PPMImage image) throws IOException {
        PDFDictionary thumbDict = new PDFDictionary();
        thumbDict.put(PDFName.WIDTH, (PDFObject)PDFInteger.forInt(image.getWidth()));
        thumbDict.put(PDFName.HEIGHT, (PDFObject)PDFInteger.forInt(image.getHeight()));
        thumbDict.put(PDFName.BITSPERCOMPONENT, (PDFObject)PDFInteger.forInt(8));
        thumbDict.put(PDFName.COLORSPACE, (PDFObject)PDFName.DEVICERGB);
        PDFOutputStream thumbStream = new PDFOutputStream(thumbDict);
        thumbStream.setFilter(PDFName.FLATEDECODE);
        OutputStream streamOut = thumbStream.getOutputStream();
        streamOut.write(image.getPixels());
        thumbStream.closeOutputStream();
        ((PDFDictionary)page.getRepresentation()).put(PDFName.THUMB, (PDFObject)thumbStream);
    }

    static void generateThumbnailFiles(File doc, String device, int res, String pageNameFormat) throws IOException {
        File antialias = File.createTempFile("thaa", ".ps");
        antialias.deleteOnExit();
        PrintWriter aaWriter = new PrintWriter(new BufferedWriter(new FileWriter(antialias)));
        aaWriter.println("%!PostScript");
        aaWriter.println("mark");
        aaWriter.println("/TextAlphaBits 4");
        aaWriter.println("/GraphicsAlphaBits 4");
        aaWriter.println("currentdevice putdeviceprops");
        aaWriter.close();
        String[] gsCmdLine = new String[]{System.getProperty("command.ghostscript", "gs"), "-sDEVICE=ppmraw", "-r" + res, "-sOutputFile=" + pageNameFormat, "-dNOPAUSE", "-dBATCH", antialias.toString(), doc.toString()};
        Process gs = Runtime.getRuntime().exec(gsCmdLine);
        try {
            gs.waitFor();
        }
        catch (InterruptedException interruptedException) {
            throw new RuntimeException("Unexpected thread interrupt while waiting for ghostscript.");
        }
        if (gs.exitValue() != 0) {
            throw new IOException("Ghostscript interpreter exited with code " + gs.exitValue());
        }
    }

    public static void main(String[] args) {
        File inFile = null;
        File outFile = null;
        int dpi = 9;
        boolean doRemove = false;
        try {
            int opt;
            Getopt options = new Getopt("pdfthumb", args, shortOpts, longOpts);
            while ((opt = options.getopt()) != -1) {
                switch (opt) {
                    case 100: {
                        dpi = Integer.parseInt(options.getOptarg());
                        break;
                    }
                    case 114: {
                        doRemove = true;
                        break;
                    }
                    case 113: {
                        verbosityLevel = 0;
                        break;
                    }
                    case 104: {
                        ThumbGen.showUsage(null);
                        break;
                    }
                    case 86: {
                        ThumbGen.showVersion();
                        break;
                    }
                    default: {
                        ThumbGen.showUsage("Illegal option '" + (char)options.getOptopt() + "' detected.");
                    }
                }
            }
            if (options.getOptind() + 2 != args.length) {
                ThumbGen.showUsage("You must specify PDF files to process.");
            }
            inFile = new File(args[options.getOptind()]);
            outFile = new File(args[options.getOptind() + 1]);
        }
        catch (Exception e) {
            ThumbGen.showUsage("Error: " + e.getMessage());
        }
        try {
            ThumbGen.progress(1, "This is PDFThumb version 0.1.\n");
            ThumbGen.progress(1, "Reading document...\n");
            Document doc = new Document(inFile);
            if (doRemove) {
                ThumbGen.progress(1, "Removing thumbnail images from document...\n");
                int i = 1;
                while (i <= doc.numPages()) {
                    ((PDFDictionary)doc.getPage(i).getRepresentation()).remove(PDFName.THUMB);
                    ++i;
                }
            } else {
                ThumbGen.progress(1, "Rendering thumbnail images at " + dpi + " dpi...\n");
                File tmpPrefix = File.createTempFile("thumb", "");
                tmpPrefix.delete();
                ThumbGen.generateThumbnailFiles(inFile, "ppmraw", dpi, String.valueOf(tmpPrefix.getAbsolutePath()) + ".%d");
                ThumbGen.progress(1, "Inserting images into document...\n");
                int i = 1;
                while (i <= doc.numPages()) {
                    File imageFile = new File(String.valueOf(tmpPrefix.getAbsolutePath()) + "." + i);
                    ThumbGen.attachThumbnail(doc.getPage(i), new PPMImage(imageFile));
                    imageFile.delete();
                    ++i;
                }
            }
            ThumbGen.progress(1, "Writing out results...\n");
            doc.write(outFile);
        }
        catch (Exception e) {
            System.err.println("Error: " + e.getMessage());
            System.exit(2);
        }
    }

    private static void progress(int level, String msg) {
        if (verbosityLevel >= level) {
            System.err.print(msg);
        }
    }

    private static void showUsage(String message) {
        if (message != null) {
            System.err.println(message);
        }
        System.err.println("Usage: pdfthumb [options] infile outfile\nOptions:\n-d N, --dpi N\t\tSet thumbnail rendering resolution to N dpi.\n-r, --remove\t\tRemove thumbnails from document.\n-q, --quiet\t\tDo not print progress messages.\n-h, --help\t\tPrint this message and exit.\n-V, --version\t\tShow version number.\n");
        System.exit(1);
    }

    private static void showVersion() {
        System.err.println("PDFThumb version 0.1\nCopyright (C) 1999, 2000 FG Systemprogrammierung, TU Darmstadt\nPDFThumb is free software; see the source for copying conditions.\nThere is NO warranty; not even for MERCHANTABILITY or FITNESS\nFOR A PARTICULAR PURPOSE.\n");
        System.exit(0);
    }
}

