"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
var _MDSEnabledClientService = require("./MDSEnabledClientService");
function _defineProperty(e, r, t) { return (r = _toPropertyKey(r)) in e ? Object.defineProperty(e, r, { value: t, enumerable: !0, configurable: !0, writable: !0 }) : e[r] = t, e; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == typeof i ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != typeof t || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != typeof i) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); } /*
                                                                                                                                                                                                                                                                                                                          * Copyright OpenSearch Contributors
                                                                                                                                                                                                                                                                                                                          * SPDX-License-Identifier: Apache-2.0
                                                                                                                                                                                                                                                                                                                          */
class OpenSearchService extends _MDSEnabledClientService.MDSEnabledClientService {
  constructor(...args) {
    super(...args);
    /**
     * Searches the provided index for documents with the provided IDs.
     */
    _defineProperty(this, "documentIdsQuery", async (context, request, response) => {
      try {
        const {
          index,
          documentIds
        } = request.body;
        const body = {
          query: {
            terms: {
              _id: documentIds
            }
          }
        };
        const params = {
          index,
          body: JSON.stringify(body)
        };
        const client = this.getClient(request, context);
        const searchResponse = await client('search', params);
        return response.custom({
          statusCode: 200,
          body: {
            ok: true,
            response: searchResponse
          }
        });
      } catch (error) {
        console.error('Security Analytics - OpenSearchService - documentIdsQuery:', error);
        return response.custom({
          statusCode: 200,
          body: {
            ok: false,
            error: error.message
          }
        });
      }
    });
    _defineProperty(this, "timeRangeQuery", async (context, request, response) => {
      try {
        const {
          index,
          timeField = 'timestamp',
          startTime = 'now-15m',
          endTime = 'now'
        } = request.query;
        const body = {
          query: {
            range: {
              [timeField]: {
                gte: startTime,
                lt: endTime
              }
            }
          }
        };
        const params = {
          index,
          body: JSON.stringify(body)
        };
        const client = this.getClient(request, context);
        const searchResponse = await client('search', params);
        return response.custom({
          statusCode: 200,
          body: {
            ok: true,
            response: searchResponse
          }
        });
      } catch (error) {
        console.error('Security Analytics - OpenSearchService - timeRangeQuery:', error);
        return response.custom({
          statusCode: 200,
          body: {
            ok: false,
            error: error.message
          }
        });
      }
    });
    _defineProperty(this, "getPlugins", async (context, request, response) => {
      try {
        const client = this.getClient(request, context);
        const plugins = await client('cat.plugins', {
          format: 'json',
          h: 'component'
        });
        return response.ok({
          body: {
            ok: true,
            response: plugins
          }
        });
      } catch (error) {
        console.error('Security Analytics - OpensearchService - getPlugins:', error);
        return response.ok({
          body: {
            ok: false,
            response: error.message
          }
        });
      }
    });
  }
}
exports.default = OpenSearchService;
module.exports = exports.default;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJuYW1lcyI6WyJfTURTRW5hYmxlZENsaWVudFNlcnZpY2UiLCJyZXF1aXJlIiwiX2RlZmluZVByb3BlcnR5IiwiZSIsInIiLCJ0IiwiX3RvUHJvcGVydHlLZXkiLCJPYmplY3QiLCJkZWZpbmVQcm9wZXJ0eSIsInZhbHVlIiwiZW51bWVyYWJsZSIsImNvbmZpZ3VyYWJsZSIsIndyaXRhYmxlIiwiaSIsIl90b1ByaW1pdGl2ZSIsIlN5bWJvbCIsInRvUHJpbWl0aXZlIiwiY2FsbCIsIlR5cGVFcnJvciIsIlN0cmluZyIsIk51bWJlciIsIk9wZW5TZWFyY2hTZXJ2aWNlIiwiTURTRW5hYmxlZENsaWVudFNlcnZpY2UiLCJjb25zdHJ1Y3RvciIsImFyZ3MiLCJjb250ZXh0IiwicmVxdWVzdCIsInJlc3BvbnNlIiwiaW5kZXgiLCJkb2N1bWVudElkcyIsImJvZHkiLCJxdWVyeSIsInRlcm1zIiwiX2lkIiwicGFyYW1zIiwiSlNPTiIsInN0cmluZ2lmeSIsImNsaWVudCIsImdldENsaWVudCIsInNlYXJjaFJlc3BvbnNlIiwiY3VzdG9tIiwic3RhdHVzQ29kZSIsIm9rIiwiZXJyb3IiLCJjb25zb2xlIiwibWVzc2FnZSIsInRpbWVGaWVsZCIsInN0YXJ0VGltZSIsImVuZFRpbWUiLCJyYW5nZSIsImd0ZSIsImx0IiwicGx1Z2lucyIsImZvcm1hdCIsImgiLCJleHBvcnRzIiwiZGVmYXVsdCIsIm1vZHVsZSJdLCJzb3VyY2VzIjpbIk9wZW5TZWFyY2hTZXJ2aWNlLnRzIl0sInNvdXJjZXNDb250ZW50IjpbIi8qXG4gKiBDb3B5cmlnaHQgT3BlblNlYXJjaCBDb250cmlidXRvcnNcbiAqIFNQRFgtTGljZW5zZS1JZGVudGlmaWVyOiBBcGFjaGUtMi4wXG4gKi9cblxuaW1wb3J0IHtcbiAgSU9wZW5TZWFyY2hEYXNoYm9hcmRzUmVzcG9uc2UsXG4gIE9wZW5TZWFyY2hEYXNoYm9hcmRzUmVxdWVzdCxcbiAgT3BlblNlYXJjaERhc2hib2FyZHNSZXNwb25zZUZhY3RvcnksXG4gIFJlcXVlc3RIYW5kbGVyQ29udGV4dCxcbiAgUmVzcG9uc2VFcnJvcixcbn0gZnJvbSAnb3BlbnNlYXJjaC1kYXNoYm9hcmRzL3NlcnZlcic7XG5pbXBvcnQgeyBTZXJ2ZXJSZXNwb25zZSB9IGZyb20gJy4uL21vZGVscy90eXBlcyc7XG5pbXBvcnQgeyBEb2N1bWVudElkc1F1ZXJ5UGFyYW1zLCBTZWFyY2hSZXNwb25zZSwgVGltZVJhbmdlUXVlcnlQYXJhbXMgfSBmcm9tICcuLi9tb2RlbHMvaW50ZXJmYWNlcyc7XG5pbXBvcnQgeyBNRFNFbmFibGVkQ2xpZW50U2VydmljZSB9IGZyb20gJy4vTURTRW5hYmxlZENsaWVudFNlcnZpY2UnO1xuXG5leHBvcnQgZGVmYXVsdCBjbGFzcyBPcGVuU2VhcmNoU2VydmljZSBleHRlbmRzIE1EU0VuYWJsZWRDbGllbnRTZXJ2aWNlIHtcbiAgLyoqXG4gICAqIFNlYXJjaGVzIHRoZSBwcm92aWRlZCBpbmRleCBmb3IgZG9jdW1lbnRzIHdpdGggdGhlIHByb3ZpZGVkIElEcy5cbiAgICovXG4gIGRvY3VtZW50SWRzUXVlcnkgPSBhc3luYyAoXG4gICAgY29udGV4dDogUmVxdWVzdEhhbmRsZXJDb250ZXh0LFxuICAgIHJlcXVlc3Q6IE9wZW5TZWFyY2hEYXNoYm9hcmRzUmVxdWVzdCxcbiAgICByZXNwb25zZTogT3BlblNlYXJjaERhc2hib2FyZHNSZXNwb25zZUZhY3RvcnlcbiAgKTogUHJvbWlzZTxcbiAgICBJT3BlblNlYXJjaERhc2hib2FyZHNSZXNwb25zZTxTZXJ2ZXJSZXNwb25zZTxTZWFyY2hSZXNwb25zZTxhbnk+PiB8IFJlc3BvbnNlRXJyb3I+XG4gID4gPT4ge1xuICAgIHRyeSB7XG4gICAgICBjb25zdCB7IGluZGV4LCBkb2N1bWVudElkcyB9ID0gcmVxdWVzdC5ib2R5IGFzIHsgaW5kZXg6IHN0cmluZzsgZG9jdW1lbnRJZHM6IHN0cmluZ1tdIH07XG4gICAgICBjb25zdCBib2R5ID0ge1xuICAgICAgICBxdWVyeToge1xuICAgICAgICAgIHRlcm1zOiB7XG4gICAgICAgICAgICBfaWQ6IGRvY3VtZW50SWRzLFxuICAgICAgICAgIH0sXG4gICAgICAgIH0sXG4gICAgICB9O1xuICAgICAgY29uc3QgcGFyYW1zOiBEb2N1bWVudElkc1F1ZXJ5UGFyYW1zID0geyBpbmRleCwgYm9keTogSlNPTi5zdHJpbmdpZnkoYm9keSkgfTtcbiAgICAgIGNvbnN0IGNsaWVudCA9IHRoaXMuZ2V0Q2xpZW50KHJlcXVlc3QsIGNvbnRleHQpO1xuICAgICAgY29uc3Qgc2VhcmNoUmVzcG9uc2U6IFNlYXJjaFJlc3BvbnNlPGFueT4gPSBhd2FpdCBjbGllbnQoJ3NlYXJjaCcsIHBhcmFtcyk7XG4gICAgICByZXR1cm4gcmVzcG9uc2UuY3VzdG9tKHtcbiAgICAgICAgc3RhdHVzQ29kZTogMjAwLFxuICAgICAgICBib2R5OiB7XG4gICAgICAgICAgb2s6IHRydWUsXG4gICAgICAgICAgcmVzcG9uc2U6IHNlYXJjaFJlc3BvbnNlLFxuICAgICAgICB9LFxuICAgICAgfSk7XG4gICAgfSBjYXRjaCAoZXJyb3I6IGFueSkge1xuICAgICAgY29uc29sZS5lcnJvcignU2VjdXJpdHkgQW5hbHl0aWNzIC0gT3BlblNlYXJjaFNlcnZpY2UgLSBkb2N1bWVudElkc1F1ZXJ5OicsIGVycm9yKTtcbiAgICAgIHJldHVybiByZXNwb25zZS5jdXN0b20oe1xuICAgICAgICBzdGF0dXNDb2RlOiAyMDAsXG4gICAgICAgIGJvZHk6IHtcbiAgICAgICAgICBvazogZmFsc2UsXG4gICAgICAgICAgZXJyb3I6IGVycm9yLm1lc3NhZ2UsXG4gICAgICAgIH0sXG4gICAgICB9KTtcbiAgICB9XG4gIH07XG5cbiAgdGltZVJhbmdlUXVlcnkgPSBhc3luYyAoXG4gICAgY29udGV4dDogUmVxdWVzdEhhbmRsZXJDb250ZXh0LFxuICAgIHJlcXVlc3Q6IE9wZW5TZWFyY2hEYXNoYm9hcmRzUmVxdWVzdCxcbiAgICByZXNwb25zZTogT3BlblNlYXJjaERhc2hib2FyZHNSZXNwb25zZUZhY3RvcnlcbiAgKTogUHJvbWlzZTxcbiAgICBJT3BlblNlYXJjaERhc2hib2FyZHNSZXNwb25zZTxTZXJ2ZXJSZXNwb25zZTxTZWFyY2hSZXNwb25zZTxhbnk+PiB8IFJlc3BvbnNlRXJyb3I+XG4gID4gPT4ge1xuICAgIHRyeSB7XG4gICAgICBjb25zdCB7XG4gICAgICAgIGluZGV4LFxuICAgICAgICB0aW1lRmllbGQgPSAndGltZXN0YW1wJyxcbiAgICAgICAgc3RhcnRUaW1lID0gJ25vdy0xNW0nLFxuICAgICAgICBlbmRUaW1lID0gJ25vdycsXG4gICAgICB9ID0gcmVxdWVzdC5xdWVyeSBhcyB7XG4gICAgICAgIGluZGV4OiBzdHJpbmc7XG4gICAgICAgIHRpbWVGaWVsZDogc3RyaW5nO1xuICAgICAgICBzdGFydFRpbWU6IHN0cmluZztcbiAgICAgICAgZW5kVGltZTogc3RyaW5nO1xuICAgICAgfTtcblxuICAgICAgY29uc3QgYm9keSA9IHtcbiAgICAgICAgcXVlcnk6IHtcbiAgICAgICAgICByYW5nZToge1xuICAgICAgICAgICAgW3RpbWVGaWVsZF06IHtcbiAgICAgICAgICAgICAgZ3RlOiBzdGFydFRpbWUsXG4gICAgICAgICAgICAgIGx0OiBlbmRUaW1lLFxuICAgICAgICAgICAgfSxcbiAgICAgICAgICB9LFxuICAgICAgICB9LFxuICAgICAgfTtcblxuICAgICAgY29uc3QgcGFyYW1zOiBUaW1lUmFuZ2VRdWVyeVBhcmFtcyA9IHsgaW5kZXgsIGJvZHk6IEpTT04uc3RyaW5naWZ5KGJvZHkpIH07XG4gICAgICBjb25zdCBjbGllbnQgPSB0aGlzLmdldENsaWVudChyZXF1ZXN0LCBjb250ZXh0KTtcbiAgICAgIGNvbnN0IHNlYXJjaFJlc3BvbnNlOiBTZWFyY2hSZXNwb25zZTxhbnk+ID0gYXdhaXQgY2xpZW50KCdzZWFyY2gnLCBwYXJhbXMpO1xuICAgICAgcmV0dXJuIHJlc3BvbnNlLmN1c3RvbSh7XG4gICAgICAgIHN0YXR1c0NvZGU6IDIwMCxcbiAgICAgICAgYm9keToge1xuICAgICAgICAgIG9rOiB0cnVlLFxuICAgICAgICAgIHJlc3BvbnNlOiBzZWFyY2hSZXNwb25zZSxcbiAgICAgICAgfSxcbiAgICAgIH0pO1xuICAgIH0gY2F0Y2ggKGVycm9yOiBhbnkpIHtcbiAgICAgIGNvbnNvbGUuZXJyb3IoJ1NlY3VyaXR5IEFuYWx5dGljcyAtIE9wZW5TZWFyY2hTZXJ2aWNlIC0gdGltZVJhbmdlUXVlcnk6JywgZXJyb3IpO1xuICAgICAgcmV0dXJuIHJlc3BvbnNlLmN1c3RvbSh7XG4gICAgICAgIHN0YXR1c0NvZGU6IDIwMCxcbiAgICAgICAgYm9keToge1xuICAgICAgICAgIG9rOiBmYWxzZSxcbiAgICAgICAgICBlcnJvcjogZXJyb3IubWVzc2FnZSxcbiAgICAgICAgfSxcbiAgICAgIH0pO1xuICAgIH1cbiAgfTtcblxuICBnZXRQbHVnaW5zID0gYXN5bmMgKFxuICAgIGNvbnRleHQ6IFJlcXVlc3RIYW5kbGVyQ29udGV4dCxcbiAgICByZXF1ZXN0OiBPcGVuU2VhcmNoRGFzaGJvYXJkc1JlcXVlc3QsXG4gICAgcmVzcG9uc2U6IE9wZW5TZWFyY2hEYXNoYm9hcmRzUmVzcG9uc2VGYWN0b3J5XG4gICkgPT4ge1xuICAgIHRyeSB7XG4gICAgICBjb25zdCBjbGllbnQgPSB0aGlzLmdldENsaWVudChyZXF1ZXN0LCBjb250ZXh0KTtcbiAgICAgIGNvbnN0IHBsdWdpbnMgPSBhd2FpdCBjbGllbnQoJ2NhdC5wbHVnaW5zJywge1xuICAgICAgICBmb3JtYXQ6ICdqc29uJyxcbiAgICAgICAgaDogJ2NvbXBvbmVudCcsXG4gICAgICB9KTtcbiAgICAgIHJldHVybiByZXNwb25zZS5vayh7XG4gICAgICAgIGJvZHk6IHtcbiAgICAgICAgICBvazogdHJ1ZSxcbiAgICAgICAgICByZXNwb25zZTogcGx1Z2lucyxcbiAgICAgICAgfSxcbiAgICAgIH0pO1xuICAgIH0gY2F0Y2ggKGVycm9yOiBhbnkpIHtcbiAgICAgIGNvbnNvbGUuZXJyb3IoJ1NlY3VyaXR5IEFuYWx5dGljcyAtIE9wZW5zZWFyY2hTZXJ2aWNlIC0gZ2V0UGx1Z2luczonLCBlcnJvcik7XG4gICAgICByZXR1cm4gcmVzcG9uc2Uub2soe1xuICAgICAgICBib2R5OiB7XG4gICAgICAgICAgb2s6IGZhbHNlLFxuICAgICAgICAgIHJlc3BvbnNlOiBlcnJvci5tZXNzYWdlLFxuICAgICAgICB9LFxuICAgICAgfSk7XG4gICAgfVxuICB9O1xufVxuIl0sIm1hcHBpbmdzIjoiOzs7Ozs7QUFjQSxJQUFBQSx3QkFBQSxHQUFBQyxPQUFBO0FBQW9FLFNBQUFDLGdCQUFBQyxDQUFBLEVBQUFDLENBQUEsRUFBQUMsQ0FBQSxZQUFBRCxDQUFBLEdBQUFFLGNBQUEsQ0FBQUYsQ0FBQSxNQUFBRCxDQUFBLEdBQUFJLE1BQUEsQ0FBQUMsY0FBQSxDQUFBTCxDQUFBLEVBQUFDLENBQUEsSUFBQUssS0FBQSxFQUFBSixDQUFBLEVBQUFLLFVBQUEsTUFBQUMsWUFBQSxNQUFBQyxRQUFBLFVBQUFULENBQUEsQ0FBQUMsQ0FBQSxJQUFBQyxDQUFBLEVBQUFGLENBQUE7QUFBQSxTQUFBRyxlQUFBRCxDQUFBLFFBQUFRLENBQUEsR0FBQUMsWUFBQSxDQUFBVCxDQUFBLHVDQUFBUSxDQUFBLEdBQUFBLENBQUEsR0FBQUEsQ0FBQTtBQUFBLFNBQUFDLGFBQUFULENBQUEsRUFBQUQsQ0FBQSwyQkFBQUMsQ0FBQSxLQUFBQSxDQUFBLFNBQUFBLENBQUEsTUFBQUYsQ0FBQSxHQUFBRSxDQUFBLENBQUFVLE1BQUEsQ0FBQUMsV0FBQSxrQkFBQWIsQ0FBQSxRQUFBVSxDQUFBLEdBQUFWLENBQUEsQ0FBQWMsSUFBQSxDQUFBWixDQUFBLEVBQUFELENBQUEsdUNBQUFTLENBQUEsU0FBQUEsQ0FBQSxZQUFBSyxTQUFBLHlFQUFBZCxDQUFBLEdBQUFlLE1BQUEsR0FBQUMsTUFBQSxFQUFBZixDQUFBLEtBZHBFO0FBQ0E7QUFDQTtBQUNBO0FBYWUsTUFBTWdCLGlCQUFpQixTQUFTQyxnREFBdUIsQ0FBQztFQUFBQyxZQUFBLEdBQUFDLElBQUE7SUFBQSxTQUFBQSxJQUFBO0lBQ3JFO0FBQ0Y7QUFDQTtJQUZFdEIsZUFBQSwyQkFHbUIsT0FDakJ1QixPQUE4QixFQUM5QkMsT0FBb0MsRUFDcENDLFFBQTZDLEtBRzFDO01BQ0gsSUFBSTtRQUNGLE1BQU07VUFBRUMsS0FBSztVQUFFQztRQUFZLENBQUMsR0FBR0gsT0FBTyxDQUFDSSxJQUFnRDtRQUN2RixNQUFNQSxJQUFJLEdBQUc7VUFDWEMsS0FBSyxFQUFFO1lBQ0xDLEtBQUssRUFBRTtjQUNMQyxHQUFHLEVBQUVKO1lBQ1A7VUFDRjtRQUNGLENBQUM7UUFDRCxNQUFNSyxNQUE4QixHQUFHO1VBQUVOLEtBQUs7VUFBRUUsSUFBSSxFQUFFSyxJQUFJLENBQUNDLFNBQVMsQ0FBQ04sSUFBSTtRQUFFLENBQUM7UUFDNUUsTUFBTU8sTUFBTSxHQUFHLElBQUksQ0FBQ0MsU0FBUyxDQUFDWixPQUFPLEVBQUVELE9BQU8sQ0FBQztRQUMvQyxNQUFNYyxjQUFtQyxHQUFHLE1BQU1GLE1BQU0sQ0FBQyxRQUFRLEVBQUVILE1BQU0sQ0FBQztRQUMxRSxPQUFPUCxRQUFRLENBQUNhLE1BQU0sQ0FBQztVQUNyQkMsVUFBVSxFQUFFLEdBQUc7VUFDZlgsSUFBSSxFQUFFO1lBQ0pZLEVBQUUsRUFBRSxJQUFJO1lBQ1JmLFFBQVEsRUFBRVk7VUFDWjtRQUNGLENBQUMsQ0FBQztNQUNKLENBQUMsQ0FBQyxPQUFPSSxLQUFVLEVBQUU7UUFDbkJDLE9BQU8sQ0FBQ0QsS0FBSyxDQUFDLDREQUE0RCxFQUFFQSxLQUFLLENBQUM7UUFDbEYsT0FBT2hCLFFBQVEsQ0FBQ2EsTUFBTSxDQUFDO1VBQ3JCQyxVQUFVLEVBQUUsR0FBRztVQUNmWCxJQUFJLEVBQUU7WUFDSlksRUFBRSxFQUFFLEtBQUs7WUFDVEMsS0FBSyxFQUFFQSxLQUFLLENBQUNFO1VBQ2Y7UUFDRixDQUFDLENBQUM7TUFDSjtJQUNGLENBQUM7SUFBQTNDLGVBQUEseUJBRWdCLE9BQ2Z1QixPQUE4QixFQUM5QkMsT0FBb0MsRUFDcENDLFFBQTZDLEtBRzFDO01BQ0gsSUFBSTtRQUNGLE1BQU07VUFDSkMsS0FBSztVQUNMa0IsU0FBUyxHQUFHLFdBQVc7VUFDdkJDLFNBQVMsR0FBRyxTQUFTO1VBQ3JCQyxPQUFPLEdBQUc7UUFDWixDQUFDLEdBQUd0QixPQUFPLENBQUNLLEtBS1g7UUFFRCxNQUFNRCxJQUFJLEdBQUc7VUFDWEMsS0FBSyxFQUFFO1lBQ0xrQixLQUFLLEVBQUU7Y0FDTCxDQUFDSCxTQUFTLEdBQUc7Z0JBQ1hJLEdBQUcsRUFBRUgsU0FBUztnQkFDZEksRUFBRSxFQUFFSDtjQUNOO1lBQ0Y7VUFDRjtRQUNGLENBQUM7UUFFRCxNQUFNZCxNQUE0QixHQUFHO1VBQUVOLEtBQUs7VUFBRUUsSUFBSSxFQUFFSyxJQUFJLENBQUNDLFNBQVMsQ0FBQ04sSUFBSTtRQUFFLENBQUM7UUFDMUUsTUFBTU8sTUFBTSxHQUFHLElBQUksQ0FBQ0MsU0FBUyxDQUFDWixPQUFPLEVBQUVELE9BQU8sQ0FBQztRQUMvQyxNQUFNYyxjQUFtQyxHQUFHLE1BQU1GLE1BQU0sQ0FBQyxRQUFRLEVBQUVILE1BQU0sQ0FBQztRQUMxRSxPQUFPUCxRQUFRLENBQUNhLE1BQU0sQ0FBQztVQUNyQkMsVUFBVSxFQUFFLEdBQUc7VUFDZlgsSUFBSSxFQUFFO1lBQ0pZLEVBQUUsRUFBRSxJQUFJO1lBQ1JmLFFBQVEsRUFBRVk7VUFDWjtRQUNGLENBQUMsQ0FBQztNQUNKLENBQUMsQ0FBQyxPQUFPSSxLQUFVLEVBQUU7UUFDbkJDLE9BQU8sQ0FBQ0QsS0FBSyxDQUFDLDBEQUEwRCxFQUFFQSxLQUFLLENBQUM7UUFDaEYsT0FBT2hCLFFBQVEsQ0FBQ2EsTUFBTSxDQUFDO1VBQ3JCQyxVQUFVLEVBQUUsR0FBRztVQUNmWCxJQUFJLEVBQUU7WUFDSlksRUFBRSxFQUFFLEtBQUs7WUFDVEMsS0FBSyxFQUFFQSxLQUFLLENBQUNFO1VBQ2Y7UUFDRixDQUFDLENBQUM7TUFDSjtJQUNGLENBQUM7SUFBQTNDLGVBQUEscUJBRVksT0FDWHVCLE9BQThCLEVBQzlCQyxPQUFvQyxFQUNwQ0MsUUFBNkMsS0FDMUM7TUFDSCxJQUFJO1FBQ0YsTUFBTVUsTUFBTSxHQUFHLElBQUksQ0FBQ0MsU0FBUyxDQUFDWixPQUFPLEVBQUVELE9BQU8sQ0FBQztRQUMvQyxNQUFNMkIsT0FBTyxHQUFHLE1BQU1mLE1BQU0sQ0FBQyxhQUFhLEVBQUU7VUFDMUNnQixNQUFNLEVBQUUsTUFBTTtVQUNkQyxDQUFDLEVBQUU7UUFDTCxDQUFDLENBQUM7UUFDRixPQUFPM0IsUUFBUSxDQUFDZSxFQUFFLENBQUM7VUFDakJaLElBQUksRUFBRTtZQUNKWSxFQUFFLEVBQUUsSUFBSTtZQUNSZixRQUFRLEVBQUV5QjtVQUNaO1FBQ0YsQ0FBQyxDQUFDO01BQ0osQ0FBQyxDQUFDLE9BQU9ULEtBQVUsRUFBRTtRQUNuQkMsT0FBTyxDQUFDRCxLQUFLLENBQUMsc0RBQXNELEVBQUVBLEtBQUssQ0FBQztRQUM1RSxPQUFPaEIsUUFBUSxDQUFDZSxFQUFFLENBQUM7VUFDakJaLElBQUksRUFBRTtZQUNKWSxFQUFFLEVBQUUsS0FBSztZQUNUZixRQUFRLEVBQUVnQixLQUFLLENBQUNFO1VBQ2xCO1FBQ0YsQ0FBQyxDQUFDO01BQ0o7SUFDRixDQUFDO0VBQUE7QUFDSDtBQUFDVSxPQUFBLENBQUFDLE9BQUEsR0FBQW5DLGlCQUFBO0FBQUFvQyxNQUFBLENBQUFGLE9BQUEsR0FBQUEsT0FBQSxDQUFBQyxPQUFBIn0=