"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SearchRelevancePlugin = void 0;
var _operators = require("rxjs/operators");
var _configSchema = require("@osd/config-schema");
var _routes = require("./routes");
var _metrics_service = require("./metrics/metrics_service");
var _common = require("../common");
function _defineProperty(e, r, t) { return (r = _toPropertyKey(r)) in e ? Object.defineProperty(e, r, { value: t, enumerable: !0, configurable: !0, writable: !0 }) : e[r] = t, e; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == typeof i ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != typeof t || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != typeof i) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); } /*
                                                                                                                                                                                                                                                                                                                          * Copyright OpenSearch Contributors
                                                                                                                                                                                                                                                                                                                          * SPDX-License-Identifier: Apache-2.0
                                                                                                                                                                                                                                                                                                                          */
class SearchRelevancePlugin {
  constructor(initializerContext) {
    this.initializerContext = initializerContext;
    _defineProperty(this, "config$", void 0);
    _defineProperty(this, "logger", void 0);
    _defineProperty(this, "metricsService", void 0);
    this.config$ = this.initializerContext.config.create();
    this.logger = this.initializerContext.logger.get();
    this.metricsService = new _metrics_service.MetricsService(this.logger.get('metrics-service'));
  }
  async setup(core, {
    dataSource
  }) {
    const dataSourceEnabled = !!dataSource;
    this.logger.debug('SearchRelevance: Setup');
    core.uiSettings.register({
      [_common.SEARCH_RELEVANCE_EXPERIMENTAL_WORKBENCH_UI_EXPERIENCE_ENABLED]: {
        name: 'Experimental Search Relevance Workbench',
        value: false,
        description: 'Whether to opt-in the experimental search relevance workbench feature',
        schema: _configSchema.schema.boolean(),
        category: ['search relevance']
      }
    });
    const config = await this.config$.pipe((0, _operators.first)()).toPromise();
    const metricsService = this.metricsService.setup(config.metrics.metricInterval, config.metrics.windowSize);
    const router = core.http.createRouter();
    let opensearchSearchRelevanceClient = undefined;
    opensearchSearchRelevanceClient = core.opensearch.legacy.createClient('opensearch_search_relevance');

    // @ts-ignore
    core.http.registerRouteHandlerContext('searchRelevance', (context, request) => {
      return {
        logger: this.logger,
        relevancyWorkbenchClient: opensearchSearchRelevanceClient,
        metricsService
      };
    });

    // Register server side APIs
    (0, _routes.defineRoutes)(router, core.opensearch, dataSourceEnabled);
    (0, _routes.registerSearchRelevanceRoutes)(router);
    return {};
  }
  start(core) {
    this.logger.debug('SearchRelevance: Started');
    return {};
  }
  stop() {}
}
exports.SearchRelevancePlugin = SearchRelevancePlugin;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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