/*
 * Decompiled with CFR 0.152.
 */
package org.openhab.core.automation.internal.module.handler;

import java.util.HashMap;
import java.util.Set;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import org.openhab.core.automation.Trigger;
import org.openhab.core.automation.handler.BaseTriggerModuleHandler;
import org.openhab.core.automation.handler.TriggerHandlerCallback;
import org.openhab.core.events.Event;
import org.openhab.core.events.EventFilter;
import org.openhab.core.events.EventSubscriber;
import org.openhab.core.events.TopicEventFilter;
import org.openhab.core.thing.ThingStatus;
import org.openhab.core.thing.events.ThingStatusInfoChangedEvent;
import org.openhab.core.thing.events.ThingStatusInfoEvent;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@NonNullByDefault
public class ThingStatusTriggerHandler
extends BaseTriggerModuleHandler
implements EventSubscriber {
    public static final String UPDATE_MODULE_TYPE_ID = "core.ThingStatusUpdateTrigger";
    public static final String CHANGE_MODULE_TYPE_ID = "core.ThingStatusChangeTrigger";
    public static final String CFG_THING_UID = "thingUID";
    public static final String CFG_STATUS = "status";
    public static final String CFG_PREVIOUS_STATUS = "previousStatus";
    public static final String OUT_STATUS = "status";
    public static final String OUT_NEW_STATUS = "newStatus";
    public static final String OUT_OLD_STATUS = "oldStatus";
    public static final String OUT_EVENT = "event";
    private final Logger logger = LoggerFactory.getLogger(ThingStatusTriggerHandler.class);
    private final String thingUID;
    private final @Nullable String status;
    private final @Nullable String previousStatus;
    private final Set<String> types;
    private final BundleContext bundleContext;
    private final ServiceRegistration<?> eventSubscriberRegistration;
    private final TopicEventFilter eventTopicFilter;

    public ThingStatusTriggerHandler(Trigger module, BundleContext bundleContext) {
        super(module);
        this.thingUID = (String)module.getConfiguration().get(CFG_THING_UID);
        this.status = (String)module.getConfiguration().get("status");
        this.previousStatus = (String)module.getConfiguration().get(CFG_PREVIOUS_STATUS);
        this.types = UPDATE_MODULE_TYPE_ID.equals(module.getTypeUID()) ? Set.of(ThingStatusInfoEvent.TYPE) : Set.of(ThingStatusInfoChangedEvent.TYPE);
        this.bundleContext = bundleContext;
        this.eventTopicFilter = new TopicEventFilter("^openhab/things/" + this.thingUID.replace("*", ".*?") + "/.*$");
        this.eventSubscriberRegistration = this.bundleContext.registerService(EventSubscriber.class.getName(), (Object)this, null);
    }

    public Set<String> getSubscribedEventTypes() {
        return this.types;
    }

    public @Nullable EventFilter getEventFilter() {
        return this.eventTopicFilter;
    }

    /*
     * Unable to fully structure code
     */
    public void receive(Event event) {
        callback = this.callback;
        if (!(callback instanceof TriggerHandlerCallback)) {
            return;
        }
        thCallback = (TriggerHandlerCallback)callback;
        this.logger.trace("Received Event: Source: {} Topic: {} Type: {}  Payload: {}", new Object[]{event.getSource(), event.getTopic(), event.getType(), event.getPayload()});
        values = new HashMap<String, Object>();
        var6_5 = event;
        if (!(var6_5 instanceof ThingStatusInfoEvent)) ** GOTO lbl-1000
        var5_6 = (ThingStatusInfoEvent)var6_5;
        (ThingStatusInfoEvent)var6_5;
        if ("core.ThingStatusUpdateTrigger".equals(((Trigger)this.module).getTypeUID())) {
            status = infoEvent.getStatusInfo().getStatus();
            if (this.statusMatches(this.status, status)) {
                values.put("status", status);
            }
        } else if ((var8_9 = event) instanceof ThingStatusInfoChangedEvent) {
            status = (ThingStatusInfoChangedEvent)var8_9;
            (ThingStatusInfoChangedEvent)var8_9;
            if ("core.ThingStatusChangeTrigger".equals(((Trigger)this.module).getTypeUID())) {
                newStatus = changedEvent.getStatusInfo().getStatus();
                oldStatus = changedEvent.getOldStatusInfo().getStatus();
                if (this.statusMatches(this.status, newStatus) && this.statusMatches(this.previousStatus, oldStatus)) {
                    values.put("newStatus", newStatus);
                    values.put("oldStatus", oldStatus);
                }
            }
        }
        if (!values.isEmpty()) {
            values.put("event", event);
            thCallback.triggered((Trigger)this.module, values);
        }
    }

    private boolean statusMatches(@Nullable String requiredStatus, ThingStatus status) {
        if (requiredStatus == null) {
            return true;
        }
        String reqStatus = requiredStatus.trim();
        return reqStatus.isEmpty() || reqStatus.equals(status.toString());
    }

    @Override
    public void dispose() {
        this.eventSubscriberRegistration.unregister();
        super.dispose();
    }
}

