#!/bin/sh

awk -F'\t' \
    -v alert=1 \
    -v check=1 \
    -v params=1 \
    -v desc=1 \
    -v previousstate=1 \
    -v currentstate=1 \
    -v triggerstate=1 \
    -v count=1 '

BEGIN {
    print "<html>"
    
    print "<body>"
    print "<table><thead><tr>"
    if(alert) { print "<th>Alert</th>" }
    if(check) { print "<th>check</th>" }
    if(params) { print "<th>params</th>" }
    if(desc) { print "<th>description</th>" }
    if(previousstate) { print "<th>previous-state</th>" }
    if(currentstate) { print "<th>current-state</th>" }
    if(triggerstate) { print "<th>trigger-state</th>" }
    if(count) { print "<th>count</th>" }
    print "</tr></thead><tbody>"
}

{
    print "<tr>"
    if(alert) { print "<td>"$1"</td>" }
    if(check) { print "<td>"$2"</td>" }
    if(params) { print "<td>"$3"</td>" }
    if(desc) { print "<td>"$4"</td>" }
    if(previousstate) { print "<td>"$5"</td>" }
    if(currentstate) { print "<td>"$6"</td>" }
    if(triggerstate) { print "<td>"$7"</td>" }
    if(count) { print "<td>"$8"</td>" }
    print "</tr>"

}

END {
    print "</tbody></table>"
    print "</body></html>"
}'
