%% Generated by lilypond-book
%% Options: [exampleindent=10.16\mm,indent=0\mm,line-width=160\mm]
\include "lilypond-book-preamble.ly"


% ****************************************************************
% Start cut-&-pastable-section
% ****************************************************************

#(ly:set-option 'eps-box-padding 3.000000)



\paper {
  indent = 0\mm
  line-width = 160\mm
  % offset the left padding, also add 1mm as lilypond creates cropped
  % images with a little space on the right
  line-width = #(- line-width (* mm  3.000000) (* mm 1))
}

\layout {
  
}




% ****************************************************************
% ly snippet:
% ****************************************************************
\sourcefilename "snippets/of-the-ubiquity-of-markup-objects.ly"
\sourcefileline 0
%% DO NOT EDIT this file manually; it was automatically
%% generated from `Documentation/snippets/new/`.
%%
%% Make any changes in `Documentation/snippets/new/`,
%% then run `scripts/auxiliar/makelsr.pl --new`.
%%
%% This file is in the public domain.
%%
%% Note: this file works from version 2.23.14.

\version "2.23.14"

\header {
%% Translation of GIT committish: 2d8a09d28e5c8a28ee4d7ab698f0a07f605f57d7
  texidocfr = "
Les objets textuels se saisissent soit en tant que simples chaînes de
caractères bornées par des guillemets informatiques, soit dans des blocs
@code{\\markup} qui, eux, acceptent tout un panel de mises en forme
avancée et améliorations graphiques.

En tant que tels, les blocs @emph{markup} peuvent s'utiliser :
@itemize
@item
pour tout objet @code{TextScript} (attaché aux notes par @code{-},
@code{^} ou @code{_}),

@item
pour tout @code{TextMark} introduit par les mots-clé @code{\\textMark}
ou @code{\\textEndMark}, ou bien tout autre objet similaire comme
@code{MetronomeMark} introduit par @code{\\tempo},

@item
comme bloc de @emph{markup} indépendant, placé au niveau supérieur en
dehors de tout bloc @code{\\score},

@item
pour toute définition au sein du bloc @code{\\header} (titre,
sous-titre, compositeur…) ou dans certaines variables définies dans le
bloc @code{\\paper} telle que @code{evenHeaderMarkup} pour les numéros
de page.

@end itemize

@code{\\markup} peut aussi servir pour les paroles, les noms d'accord et
les nuances. En fait, @code{\\markup} peut servir à personnaliser
l'apparence de pratiquement n'importe quel objet, comme l'illustre cet
exemple qui recourt à différentes méthodes.
"

  doctitlefr = "De l'ubiquité des objets @emph{markup}"

  lsrtags = "text"

  texidoc = "
Text objects are entered either as simple strings between double quotes
or as @code{\\markup} blocks that can accept a variety of advanced text
formatting and graphical enhancements.

As such, markup blocks may be used:

@itemize
@item
in any TextScript object (attached to notes with @code{-}, @code{^} or
@code{_}),
@item
any @code{TextMark} introduced with the @code{\\textMark} or
@code{\\textEndMark} command, or other similar objects such
as MetronomeMark introduced with @code{\\tempo},
@item
as standalone markup blocks, entered at the top level outside of any
@code{\\score} block,
@item
in any definition inside the @code{\\header} block (e.g. title,
subtitle, composer) or in some variables defined inside the
@code{\\paper} block such as @code{evenHeaderMarkup} for page numbers.
@end itemize

@code{\\markup} may additionally be used for lyrics, in chord names,
and as dynamics.  In fact, it is possible to use @code{\\markup} to
customize the appearance of virtually any object, as demonstrated in
this example using various methods.
"

  doctitle = "Of the ubiquity of markup objects"
} % begin verbatim


%% Thanks to Aaron Hill https://lists.gnu.org/archive/html/lilypond-user/2019-01/msg00437.html

\paper {
  paper-width = 8\cm paper-height = 8\cm
}
\header {
  title = \markup "Header"
  tagline = \markup "(tagline)"
}
\markup "Top-level markup"
dyn = #(make-dynamic-script #{ \markup \text "DynamicText" #})
\score {
  <<
    \new ChordNames
    \with { majorSevenSymbol = \markup "majorSevenSymbol" }
    \chordmode { c1:maj7 }
    \new Staff {
      \tempo \markup "MetronomeMark"
      \textMark "TextMark"
      \once \override TupletNumber.text = \markup "TupletNumber"
      \tuplet 3/2 {
        \once \override NoteHead.stencil = #ly:text-interface::print
        \once \override NoteHead.text = \markup \lower #0.5 "NoteHead"
        c''8^\markup "TextScript"
        \once \override Rest.stencil = #(lambda (grob)
          (grob-interpret-markup grob #{
            \markup  "Rest"
            #}))
        r4
      }
    }
    \new Lyrics \lyricmode { \markup "LyricText" 1 }
    \new Dynamics { s1\dyn }
  >>
}



% ****************************************************************
% end ly snippet
% ****************************************************************
