/*
 * Mathew Vea	Created:  5/20/88	Last Modified:	6/8/88
 *
 * Useful definitions for spectral peak programs
 *------------------------------------------------------------*
 * HISTORY
 * 10-Nov-88 Fil Alleva
 *       Changed the file name since peak.h was just too generic.
 *       Installed in ~/include. Added the conditional ifdefs.
*/

#ifndef _FORM_PEAK_H_
#define _FORM_PEAK_H_

#define	NUMCAND  6	/* number of candidate formants to be saved */
#define	THRESH   3	/* number dB used to determine cutoff */

#define SYNCHP(x)  ((x) && ((x) != 1))	  /* predicate: syncflag == synch? */
#define ASYNCHP(x)  (!(x) || ((x) == 1))  /* predicate: syncflag == asynch? */

typedef struct {
    short	lower,	/* lower cutoff freq. of this peak */
		upper,	/* upper cutoff freq. of this peak */
		peak,	/* (first) frequency with maximum spectral amp. */
		mag,	/* amplitude of spectrum at peak freq. */
		label;	/* label of peak: 0 => not a formant */
} SPEAK;

typedef struct {
    int		numpeaks,	/* # of formant candidates in this frame */
		ref,		/* first adc point (ref from SYNC struct) */
		syncflag;	/* same as syncflag from SYNC struct  */
    SPEAK	cands[NUMCAND];	/* array of formant candidates */
} FCAND;

#endif _FORM_PEAK_H_
