/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.profiles.activation;

import org.apache.maven.model.Activation;
import org.apache.maven.model.ActivationFile;
import org.apache.maven.model.Profile;
import org.apache.maven.profiles.activation.DetectedProfileActivator;
import org.codehaus.plexus.util.FileUtils;

public class FileProfileActivator
extends DetectedProfileActivator {
    protected boolean canDetectActivation(Profile profile) {
        return profile.getActivation() != null && profile.getActivation().getFile() != null;
    }

    public boolean isActive(Profile profile) {
        Activation activation = profile.getActivation();
        ActivationFile actFile = activation.getFile();
        if (actFile != null) {
            String fileString = actFile.getExists();
            if (fileString != null && !"".equals(fileString)) {
                return FileUtils.fileExists(fileString);
            }
            fileString = actFile.getMissing();
            if (fileString != null && !"".equals(fileString)) {
                return !FileUtils.fileExists(fileString);
            }
        }
        return false;
    }
}

