/*
 * Copyright (c) 2011, 2018, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */
package org.graalvm.visualvm.lib.profiler.heapwalk.ui.icons;

import org.graalvm.visualvm.lib.profiler.api.icons.Icons;

/**
 *
 * @author Jiri Sedlacek
 */
public interface HeapWalkerIcons extends Icons.Keys {

    public static final String CLASSES = "HeapWalkerIcons.Classes"; // NOI18N
    public static final String DATA = "HeapWalkerIcons.Data"; // NOI18N
    public static final String GC_ROOT = "HeapWalkerIcons.GcRoot"; // NOI18N
    public static final String GC_ROOTS = "HeapWalkerIcons.GcRoots"; // NOI18N
    public static final String INCOMING_REFERENCES = "HeapWalkerIcons.IncomingReferences"; // NOI18N
    public static final String INSTANCES = "HeapWalkerIcons.Instances"; // NOI18N
    public static final String LOOP = "HeapWalkerIcons.Loop"; // NOI18N
    public static final String MEMORY_LINT = "HeapWalkerIcons.MemoryLint"; // NOI18N
    public static final String PROGRESS = "HeapWalkerIcons.Progress"; // NOI18N
    public static final String PROPERTIES = "HeapWalkerIcons.Properties"; // NOI18N
    public static final String RULES = "HeapWalkerIcons.Rules"; // NOI18N
    public static final String SAVED_OQL_QUERIES = "HeapWalkerIcons.SavedOqlQueries"; // NOI18N
    public static final String STATIC = "HeapWalkerIcons.Static"; // NOI18N
    public static final String SYSTEM_INFO = "HeapWalkerIcons.SystemInfo"; // NOI18N
    public static final String WINDOW = "HeapWalkerIcons.Window"; // NOI18N
    public static final String BIGGEST_OBJECTS = "HeapWalkerIcons.BiggestObjects"; // NOI18N
    public static final String OQL_CONSOLE = "HeapWalkerIcons.OQLConsole"; // NOI18N

}
