<?php

/*
 * This file is part of the Predis package.
 *
 * (c) 2009-2020 Daniele Alessandri
 * (c) 2021-2026 Till Krüss
 *
 * For the full copyright and license information, please view the LICENSE
 * file that was distributed with this source code.
 */

namespace Predis\Command\Argument\Search\HybridSearch;

use PHPUnit\Framework\TestCase;

class ReducerTest extends TestCase
{
    /**
     * @return void
     */
    public function testToArray(): void
    {
        $reducer = new Reducer(Reducer::REDUCE_MAX, ['prop1', 'prop2'], 'alias');
        $this->assertSame([Reducer::REDUCE_MAX, 2, 'prop1', 'prop2', 'AS', 'alias'], $reducer->toArray());
    }
}
