.\" Copyright (c) 1999, Oracle and/or its affiliates.
.\"
.\" Permission is hereby granted, free of charge, to any person obtaining a
.\" copy of this software and associated documentation files (the "Software"),
.\" to deal in the Software without restriction, including without limitation
.\" the rights to use, copy, modify, merge, publish, distribute, sublicense,
.\" and/or sell copies of the Software, and to permit persons to whom the
.\" Software is furnished to do so, subject to the following conditions:
.\"
.\" The above copyright notice and this permission notice (including the next
.\" paragraph) shall be included in all copies or substantial portions of the
.\" Software.
.\"
.\" THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
.\" IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
.\" FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL
.\" THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
.\" LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
.\" FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
.\" DEALINGS IN THE SOFTWARE.
.\"
.TH XkbAddSymInterpret __libmansuffix__ __xorgversion__ "XKB FUNCTIONS"
.SH NAME
XkbAddSymInterpret \- Add a symbol interpretation to the list of symbol
interpretations in an XkbCompatRec
.SH SYNOPSIS
.HP
.B XkbSymInterpretPtr XkbAddSymInterpret
.BI "(\^XkbDescPtr " "xkb" "\^,"
.BI "XkbSymInterpretPtr " "si" "\^,"
.BI "Bool " "updateMap" "\^,"
.BI "XkbChangesPtr " "changes" "\^);"
.if n .ti +5n
.if t .ti +.5i
.SH ARGUMENTS
.TP
.I xkb
keyboard description to be updated
.TP
.I si
symbol interpretation to be added
.TP
.I updateMap
True=>apply compatibility map to keys
.TP
.I changes
changes are put here
.SH DESCRIPTION
.LP
.I XkbAddSymInterpret
adds
.I si
to the list of symbol interpretations in
.I xkb.
If
.I updateMap
is True, it (re)applies the compatibility map to all of the keys on the
keyboard. If
.I changes
is non-NULL, it reports the parts of the keyboard that were affected (unless
.I updateMap
is True, not much changes).
.I XkbAddSymInterpret
returns a pointer to the actual new symbol interpretation in the list or NULL if
it failed.
