/* This file is generated by venus-protocol.  See vn_protocol_driver.h. */

/*
 * Copyright 2020 Google LLC
 * SPDX-License-Identifier: MIT
 */

#ifndef VN_PROTOCOL_DRIVER_HOST_COPY_H
#define VN_PROTOCOL_DRIVER_HOST_COPY_H

#include "vn_ring.h"
#include "vn_protocol_driver_structs.h"

/*
 * These structs/unions/commands are not included
 *
 *   vkCopyMemoryToImage
 *   vkCopyImageToMemory
 */

/* struct VkCopyImageToImageInfo chain */

static inline size_t
vn_sizeof_VkCopyImageToImageInfo_pnext(const void *val)
{
    /* no known/supported struct */
    return vn_sizeof_simple_pointer(NULL);
}

static inline size_t
vn_sizeof_VkCopyImageToImageInfo_self(const VkCopyImageToImageInfo *val)
{
    size_t size = 0;
    /* skip val->{sType,pNext} */
    size += vn_sizeof_VkFlags(&val->flags);
    size += vn_sizeof_VkImage(&val->srcImage);
    size += vn_sizeof_VkImageLayout(&val->srcImageLayout);
    size += vn_sizeof_VkImage(&val->dstImage);
    size += vn_sizeof_VkImageLayout(&val->dstImageLayout);
    size += vn_sizeof_uint32_t(&val->regionCount);
    if (val->pRegions) {
        size += vn_sizeof_array_size(val->regionCount);
        for (uint32_t i = 0; i < val->regionCount; i++)
            size += vn_sizeof_VkImageCopy2(&val->pRegions[i]);
    } else {
        size += vn_sizeof_array_size(0);
    }
    return size;
}

static inline size_t
vn_sizeof_VkCopyImageToImageInfo(const VkCopyImageToImageInfo *val)
{
    size_t size = 0;

    size += vn_sizeof_VkStructureType(&val->sType);
    size += vn_sizeof_VkCopyImageToImageInfo_pnext(val->pNext);
    size += vn_sizeof_VkCopyImageToImageInfo_self(val);

    return size;
}

static inline void
vn_encode_VkCopyImageToImageInfo_pnext(struct vn_cs_encoder *enc, const void *val)
{
    /* no known/supported struct */
    vn_encode_simple_pointer(enc, NULL);
}

static inline void
vn_encode_VkCopyImageToImageInfo_self(struct vn_cs_encoder *enc, const VkCopyImageToImageInfo *val)
{
    /* skip val->{sType,pNext} */
    vn_encode_VkFlags(enc, &val->flags);
    vn_encode_VkImage(enc, &val->srcImage);
    vn_encode_VkImageLayout(enc, &val->srcImageLayout);
    vn_encode_VkImage(enc, &val->dstImage);
    vn_encode_VkImageLayout(enc, &val->dstImageLayout);
    vn_encode_uint32_t(enc, &val->regionCount);
    if (val->pRegions) {
        vn_encode_array_size(enc, val->regionCount);
        for (uint32_t i = 0; i < val->regionCount; i++)
            vn_encode_VkImageCopy2(enc, &val->pRegions[i]);
    } else {
        vn_encode_array_size(enc, 0);
    }
}

static inline void
vn_encode_VkCopyImageToImageInfo(struct vn_cs_encoder *enc, const VkCopyImageToImageInfo *val)
{
    assert(val->sType == VK_STRUCTURE_TYPE_COPY_IMAGE_TO_IMAGE_INFO);
    vn_encode_VkStructureType(enc, &(VkStructureType){ VK_STRUCTURE_TYPE_COPY_IMAGE_TO_IMAGE_INFO });
    vn_encode_VkCopyImageToImageInfo_pnext(enc, val->pNext);
    vn_encode_VkCopyImageToImageInfo_self(enc, val);
}

/* struct VkHostImageLayoutTransitionInfo chain */

static inline size_t
vn_sizeof_VkHostImageLayoutTransitionInfo_pnext(const void *val)
{
    /* no known/supported struct */
    return vn_sizeof_simple_pointer(NULL);
}

static inline size_t
vn_sizeof_VkHostImageLayoutTransitionInfo_self(const VkHostImageLayoutTransitionInfo *val)
{
    size_t size = 0;
    /* skip val->{sType,pNext} */
    size += vn_sizeof_VkImage(&val->image);
    size += vn_sizeof_VkImageLayout(&val->oldLayout);
    size += vn_sizeof_VkImageLayout(&val->newLayout);
    size += vn_sizeof_VkImageSubresourceRange(&val->subresourceRange);
    return size;
}

static inline size_t
vn_sizeof_VkHostImageLayoutTransitionInfo(const VkHostImageLayoutTransitionInfo *val)
{
    size_t size = 0;

    size += vn_sizeof_VkStructureType(&val->sType);
    size += vn_sizeof_VkHostImageLayoutTransitionInfo_pnext(val->pNext);
    size += vn_sizeof_VkHostImageLayoutTransitionInfo_self(val);

    return size;
}

static inline void
vn_encode_VkHostImageLayoutTransitionInfo_pnext(struct vn_cs_encoder *enc, const void *val)
{
    /* no known/supported struct */
    vn_encode_simple_pointer(enc, NULL);
}

static inline void
vn_encode_VkHostImageLayoutTransitionInfo_self(struct vn_cs_encoder *enc, const VkHostImageLayoutTransitionInfo *val)
{
    /* skip val->{sType,pNext} */
    vn_encode_VkImage(enc, &val->image);
    vn_encode_VkImageLayout(enc, &val->oldLayout);
    vn_encode_VkImageLayout(enc, &val->newLayout);
    vn_encode_VkImageSubresourceRange(enc, &val->subresourceRange);
}

static inline void
vn_encode_VkHostImageLayoutTransitionInfo(struct vn_cs_encoder *enc, const VkHostImageLayoutTransitionInfo *val)
{
    assert(val->sType == VK_STRUCTURE_TYPE_HOST_IMAGE_LAYOUT_TRANSITION_INFO);
    vn_encode_VkStructureType(enc, &(VkStructureType){ VK_STRUCTURE_TYPE_HOST_IMAGE_LAYOUT_TRANSITION_INFO });
    vn_encode_VkHostImageLayoutTransitionInfo_pnext(enc, val->pNext);
    vn_encode_VkHostImageLayoutTransitionInfo_self(enc, val);
}

/* struct VkCopyImageToMemoryInfoMESA chain */

static inline size_t
vn_sizeof_VkCopyImageToMemoryInfoMESA_pnext(const void *val)
{
    /* no known/supported struct */
    return vn_sizeof_simple_pointer(NULL);
}

static inline size_t
vn_sizeof_VkCopyImageToMemoryInfoMESA_self(const VkCopyImageToMemoryInfoMESA *val)
{
    size_t size = 0;
    /* skip val->{sType,pNext} */
    size += vn_sizeof_VkFlags(&val->flags);
    size += vn_sizeof_VkImage(&val->srcImage);
    size += vn_sizeof_VkImageLayout(&val->srcImageLayout);
    size += vn_sizeof_uint32_t(&val->memoryRowLength);
    size += vn_sizeof_uint32_t(&val->memoryImageHeight);
    size += vn_sizeof_VkImageSubresourceLayers(&val->imageSubresource);
    size += vn_sizeof_VkOffset3D(&val->imageOffset);
    size += vn_sizeof_VkExtent3D(&val->imageExtent);
    return size;
}

static inline size_t
vn_sizeof_VkCopyImageToMemoryInfoMESA(const VkCopyImageToMemoryInfoMESA *val)
{
    size_t size = 0;

    size += vn_sizeof_VkStructureType(&val->sType);
    size += vn_sizeof_VkCopyImageToMemoryInfoMESA_pnext(val->pNext);
    size += vn_sizeof_VkCopyImageToMemoryInfoMESA_self(val);

    return size;
}

static inline void
vn_encode_VkCopyImageToMemoryInfoMESA_pnext(struct vn_cs_encoder *enc, const void *val)
{
    /* no known/supported struct */
    vn_encode_simple_pointer(enc, NULL);
}

static inline void
vn_encode_VkCopyImageToMemoryInfoMESA_self(struct vn_cs_encoder *enc, const VkCopyImageToMemoryInfoMESA *val)
{
    /* skip val->{sType,pNext} */
    vn_encode_VkFlags(enc, &val->flags);
    vn_encode_VkImage(enc, &val->srcImage);
    vn_encode_VkImageLayout(enc, &val->srcImageLayout);
    vn_encode_uint32_t(enc, &val->memoryRowLength);
    vn_encode_uint32_t(enc, &val->memoryImageHeight);
    vn_encode_VkImageSubresourceLayers(enc, &val->imageSubresource);
    vn_encode_VkOffset3D(enc, &val->imageOffset);
    vn_encode_VkExtent3D(enc, &val->imageExtent);
}

static inline void
vn_encode_VkCopyImageToMemoryInfoMESA(struct vn_cs_encoder *enc, const VkCopyImageToMemoryInfoMESA *val)
{
    assert(val->sType == VK_STRUCTURE_TYPE_COPY_IMAGE_TO_MEMORY_INFO_MESA);
    vn_encode_VkStructureType(enc, &(VkStructureType){ VK_STRUCTURE_TYPE_COPY_IMAGE_TO_MEMORY_INFO_MESA });
    vn_encode_VkCopyImageToMemoryInfoMESA_pnext(enc, val->pNext);
    vn_encode_VkCopyImageToMemoryInfoMESA_self(enc, val);
}

/* struct VkMemoryToImageCopyMESA chain */

static inline size_t
vn_sizeof_VkMemoryToImageCopyMESA_pnext(const void *val)
{
    /* no known/supported struct */
    return vn_sizeof_simple_pointer(NULL);
}

static inline size_t
vn_sizeof_VkMemoryToImageCopyMESA_self(const VkMemoryToImageCopyMESA *val)
{
    size_t size = 0;
    /* skip val->{sType,pNext} */
    size += vn_sizeof_size_t(&val->dataSize);
    if (val->pData) {
        size += vn_sizeof_array_size(val->dataSize);
        size += vn_sizeof_blob_array(val->pData, val->dataSize);
    } else {
        size += vn_sizeof_array_size(0);
    }
    size += vn_sizeof_uint32_t(&val->memoryRowLength);
    size += vn_sizeof_uint32_t(&val->memoryImageHeight);
    size += vn_sizeof_VkImageSubresourceLayers(&val->imageSubresource);
    size += vn_sizeof_VkOffset3D(&val->imageOffset);
    size += vn_sizeof_VkExtent3D(&val->imageExtent);
    return size;
}

static inline size_t
vn_sizeof_VkMemoryToImageCopyMESA(const VkMemoryToImageCopyMESA *val)
{
    size_t size = 0;

    size += vn_sizeof_VkStructureType(&val->sType);
    size += vn_sizeof_VkMemoryToImageCopyMESA_pnext(val->pNext);
    size += vn_sizeof_VkMemoryToImageCopyMESA_self(val);

    return size;
}

static inline void
vn_encode_VkMemoryToImageCopyMESA_pnext(struct vn_cs_encoder *enc, const void *val)
{
    /* no known/supported struct */
    vn_encode_simple_pointer(enc, NULL);
}

static inline void
vn_encode_VkMemoryToImageCopyMESA_self(struct vn_cs_encoder *enc, const VkMemoryToImageCopyMESA *val)
{
    /* skip val->{sType,pNext} */
    vn_encode_size_t(enc, &val->dataSize);
    if (val->pData) {
        vn_encode_array_size(enc, val->dataSize);
        vn_encode_blob_array(enc, val->pData, val->dataSize);
    } else {
        vn_encode_array_size(enc, 0);
    }
    vn_encode_uint32_t(enc, &val->memoryRowLength);
    vn_encode_uint32_t(enc, &val->memoryImageHeight);
    vn_encode_VkImageSubresourceLayers(enc, &val->imageSubresource);
    vn_encode_VkOffset3D(enc, &val->imageOffset);
    vn_encode_VkExtent3D(enc, &val->imageExtent);
}

static inline void
vn_encode_VkMemoryToImageCopyMESA(struct vn_cs_encoder *enc, const VkMemoryToImageCopyMESA *val)
{
    assert(val->sType == VK_STRUCTURE_TYPE_MEMORY_TO_IMAGE_COPY_MESA);
    vn_encode_VkStructureType(enc, &(VkStructureType){ VK_STRUCTURE_TYPE_MEMORY_TO_IMAGE_COPY_MESA });
    vn_encode_VkMemoryToImageCopyMESA_pnext(enc, val->pNext);
    vn_encode_VkMemoryToImageCopyMESA_self(enc, val);
}

/* struct VkCopyMemoryToImageInfoMESA chain */

static inline size_t
vn_sizeof_VkCopyMemoryToImageInfoMESA_pnext(const void *val)
{
    /* no known/supported struct */
    return vn_sizeof_simple_pointer(NULL);
}

static inline size_t
vn_sizeof_VkCopyMemoryToImageInfoMESA_self(const VkCopyMemoryToImageInfoMESA *val)
{
    size_t size = 0;
    /* skip val->{sType,pNext} */
    size += vn_sizeof_VkFlags(&val->flags);
    size += vn_sizeof_VkImage(&val->dstImage);
    size += vn_sizeof_VkImageLayout(&val->dstImageLayout);
    size += vn_sizeof_uint32_t(&val->regionCount);
    if (val->pRegions) {
        size += vn_sizeof_array_size(val->regionCount);
        for (uint32_t i = 0; i < val->regionCount; i++)
            size += vn_sizeof_VkMemoryToImageCopyMESA(&val->pRegions[i]);
    } else {
        size += vn_sizeof_array_size(0);
    }
    return size;
}

static inline size_t
vn_sizeof_VkCopyMemoryToImageInfoMESA(const VkCopyMemoryToImageInfoMESA *val)
{
    size_t size = 0;

    size += vn_sizeof_VkStructureType(&val->sType);
    size += vn_sizeof_VkCopyMemoryToImageInfoMESA_pnext(val->pNext);
    size += vn_sizeof_VkCopyMemoryToImageInfoMESA_self(val);

    return size;
}

static inline void
vn_encode_VkCopyMemoryToImageInfoMESA_pnext(struct vn_cs_encoder *enc, const void *val)
{
    /* no known/supported struct */
    vn_encode_simple_pointer(enc, NULL);
}

static inline void
vn_encode_VkCopyMemoryToImageInfoMESA_self(struct vn_cs_encoder *enc, const VkCopyMemoryToImageInfoMESA *val)
{
    /* skip val->{sType,pNext} */
    vn_encode_VkFlags(enc, &val->flags);
    vn_encode_VkImage(enc, &val->dstImage);
    vn_encode_VkImageLayout(enc, &val->dstImageLayout);
    vn_encode_uint32_t(enc, &val->regionCount);
    if (val->pRegions) {
        vn_encode_array_size(enc, val->regionCount);
        for (uint32_t i = 0; i < val->regionCount; i++)
            vn_encode_VkMemoryToImageCopyMESA(enc, &val->pRegions[i]);
    } else {
        vn_encode_array_size(enc, 0);
    }
}

static inline void
vn_encode_VkCopyMemoryToImageInfoMESA(struct vn_cs_encoder *enc, const VkCopyMemoryToImageInfoMESA *val)
{
    assert(val->sType == VK_STRUCTURE_TYPE_COPY_MEMORY_TO_IMAGE_INFO_MESA);
    vn_encode_VkStructureType(enc, &(VkStructureType){ VK_STRUCTURE_TYPE_COPY_MEMORY_TO_IMAGE_INFO_MESA });
    vn_encode_VkCopyMemoryToImageInfoMESA_pnext(enc, val->pNext);
    vn_encode_VkCopyMemoryToImageInfoMESA_self(enc, val);
}

static inline size_t vn_sizeof_vkCopyImageToImage(VkDevice device, const VkCopyImageToImageInfo* pCopyImageToImageInfo)
{
    const VkCommandTypeEXT cmd_type = VK_COMMAND_TYPE_vkCopyImageToImage_EXT;
    const VkFlags cmd_flags = 0;
    size_t cmd_size = vn_sizeof_VkCommandTypeEXT(&cmd_type) + vn_sizeof_VkFlags(&cmd_flags);

    cmd_size += vn_sizeof_VkDevice(&device);
    cmd_size += vn_sizeof_simple_pointer(pCopyImageToImageInfo);
    if (pCopyImageToImageInfo)
        cmd_size += vn_sizeof_VkCopyImageToImageInfo(pCopyImageToImageInfo);

    return cmd_size;
}

static inline void vn_encode_vkCopyImageToImage(struct vn_cs_encoder *enc, VkCommandFlagsEXT cmd_flags, VkDevice device, const VkCopyImageToImageInfo* pCopyImageToImageInfo)
{
    const VkCommandTypeEXT cmd_type = VK_COMMAND_TYPE_vkCopyImageToImage_EXT;

    vn_encode_VkCommandTypeEXT(enc, &cmd_type);
    vn_encode_VkFlags(enc, &cmd_flags);

    vn_encode_VkDevice(enc, &device);
    if (vn_encode_simple_pointer(enc, pCopyImageToImageInfo))
        vn_encode_VkCopyImageToImageInfo(enc, pCopyImageToImageInfo);
}

static inline size_t vn_sizeof_vkCopyImageToImage_reply(VkDevice device, const VkCopyImageToImageInfo* pCopyImageToImageInfo)
{
    const VkCommandTypeEXT cmd_type = VK_COMMAND_TYPE_vkCopyImageToImage_EXT;
    size_t cmd_size = vn_sizeof_VkCommandTypeEXT(&cmd_type);

    VkResult ret;
    cmd_size += vn_sizeof_VkResult(&ret);
    /* skip device */
    /* skip pCopyImageToImageInfo */

    return cmd_size;
}

static inline VkResult vn_decode_vkCopyImageToImage_reply(struct vn_cs_decoder *dec, VkDevice device, const VkCopyImageToImageInfo* pCopyImageToImageInfo)
{
    VkCommandTypeEXT command_type;
    vn_decode_VkCommandTypeEXT(dec, &command_type);
    assert(command_type == VK_COMMAND_TYPE_vkCopyImageToImage_EXT);

    VkResult ret;
    vn_decode_VkResult(dec, &ret);
    /* skip device */
    /* skip pCopyImageToImageInfo */

    return ret;
}

static inline size_t vn_sizeof_vkTransitionImageLayout(VkDevice device, uint32_t transitionCount, const VkHostImageLayoutTransitionInfo* pTransitions)
{
    const VkCommandTypeEXT cmd_type = VK_COMMAND_TYPE_vkTransitionImageLayout_EXT;
    const VkFlags cmd_flags = 0;
    size_t cmd_size = vn_sizeof_VkCommandTypeEXT(&cmd_type) + vn_sizeof_VkFlags(&cmd_flags);

    cmd_size += vn_sizeof_VkDevice(&device);
    cmd_size += vn_sizeof_uint32_t(&transitionCount);
    if (pTransitions) {
        cmd_size += vn_sizeof_array_size(transitionCount);
        for (uint32_t i = 0; i < transitionCount; i++)
            cmd_size += vn_sizeof_VkHostImageLayoutTransitionInfo(&pTransitions[i]);
    } else {
        cmd_size += vn_sizeof_array_size(0);
    }

    return cmd_size;
}

static inline void vn_encode_vkTransitionImageLayout(struct vn_cs_encoder *enc, VkCommandFlagsEXT cmd_flags, VkDevice device, uint32_t transitionCount, const VkHostImageLayoutTransitionInfo* pTransitions)
{
    const VkCommandTypeEXT cmd_type = VK_COMMAND_TYPE_vkTransitionImageLayout_EXT;

    vn_encode_VkCommandTypeEXT(enc, &cmd_type);
    vn_encode_VkFlags(enc, &cmd_flags);

    vn_encode_VkDevice(enc, &device);
    vn_encode_uint32_t(enc, &transitionCount);
    if (pTransitions) {
        vn_encode_array_size(enc, transitionCount);
        for (uint32_t i = 0; i < transitionCount; i++)
            vn_encode_VkHostImageLayoutTransitionInfo(enc, &pTransitions[i]);
    } else {
        vn_encode_array_size(enc, 0);
    }
}

static inline size_t vn_sizeof_vkTransitionImageLayout_reply(VkDevice device, uint32_t transitionCount, const VkHostImageLayoutTransitionInfo* pTransitions)
{
    const VkCommandTypeEXT cmd_type = VK_COMMAND_TYPE_vkTransitionImageLayout_EXT;
    size_t cmd_size = vn_sizeof_VkCommandTypeEXT(&cmd_type);

    VkResult ret;
    cmd_size += vn_sizeof_VkResult(&ret);
    /* skip device */
    /* skip transitionCount */
    /* skip pTransitions */

    return cmd_size;
}

static inline VkResult vn_decode_vkTransitionImageLayout_reply(struct vn_cs_decoder *dec, VkDevice device, uint32_t transitionCount, const VkHostImageLayoutTransitionInfo* pTransitions)
{
    VkCommandTypeEXT command_type;
    vn_decode_VkCommandTypeEXT(dec, &command_type);
    assert(command_type == VK_COMMAND_TYPE_vkTransitionImageLayout_EXT);

    VkResult ret;
    vn_decode_VkResult(dec, &ret);
    /* skip device */
    /* skip transitionCount */
    /* skip pTransitions */

    return ret;
}

static inline size_t vn_sizeof_vkCopyImageToMemoryMESA(VkDevice device, const VkCopyImageToMemoryInfoMESA* pCopyImageToMemoryInfo, size_t dataSize, void* pData)
{
    const VkCommandTypeEXT cmd_type = VK_COMMAND_TYPE_vkCopyImageToMemoryMESA_EXT;
    const VkFlags cmd_flags = 0;
    size_t cmd_size = vn_sizeof_VkCommandTypeEXT(&cmd_type) + vn_sizeof_VkFlags(&cmd_flags);

    cmd_size += vn_sizeof_VkDevice(&device);
    cmd_size += vn_sizeof_simple_pointer(pCopyImageToMemoryInfo);
    if (pCopyImageToMemoryInfo)
        cmd_size += vn_sizeof_VkCopyImageToMemoryInfoMESA(pCopyImageToMemoryInfo);
    cmd_size += vn_sizeof_size_t(&dataSize);
    cmd_size += vn_sizeof_simple_pointer(pData); /* out */

    return cmd_size;
}

static inline void vn_encode_vkCopyImageToMemoryMESA(struct vn_cs_encoder *enc, VkCommandFlagsEXT cmd_flags, VkDevice device, const VkCopyImageToMemoryInfoMESA* pCopyImageToMemoryInfo, size_t dataSize, void* pData)
{
    const VkCommandTypeEXT cmd_type = VK_COMMAND_TYPE_vkCopyImageToMemoryMESA_EXT;

    vn_encode_VkCommandTypeEXT(enc, &cmd_type);
    vn_encode_VkFlags(enc, &cmd_flags);

    vn_encode_VkDevice(enc, &device);
    if (vn_encode_simple_pointer(enc, pCopyImageToMemoryInfo))
        vn_encode_VkCopyImageToMemoryInfoMESA(enc, pCopyImageToMemoryInfo);
    vn_encode_size_t(enc, &dataSize);
    vn_encode_array_size(enc, pData ? dataSize : 0); /* out */
}

static inline size_t vn_sizeof_vkCopyImageToMemoryMESA_reply(VkDevice device, const VkCopyImageToMemoryInfoMESA* pCopyImageToMemoryInfo, size_t dataSize, void* pData)
{
    const VkCommandTypeEXT cmd_type = VK_COMMAND_TYPE_vkCopyImageToMemoryMESA_EXT;
    size_t cmd_size = vn_sizeof_VkCommandTypeEXT(&cmd_type);

    VkResult ret;
    cmd_size += vn_sizeof_VkResult(&ret);
    /* skip device */
    /* skip pCopyImageToMemoryInfo */
    /* skip dataSize */
    if (pData) {
        cmd_size += vn_sizeof_array_size(dataSize);
        cmd_size += vn_sizeof_blob_array(pData, dataSize);
    } else {
        cmd_size += vn_sizeof_array_size(0);
    }

    return cmd_size;
}

static inline VkResult vn_decode_vkCopyImageToMemoryMESA_reply(struct vn_cs_decoder *dec, VkDevice device, const VkCopyImageToMemoryInfoMESA* pCopyImageToMemoryInfo, size_t dataSize, void* pData)
{
    VkCommandTypeEXT command_type;
    vn_decode_VkCommandTypeEXT(dec, &command_type);
    assert(command_type == VK_COMMAND_TYPE_vkCopyImageToMemoryMESA_EXT);

    VkResult ret;
    vn_decode_VkResult(dec, &ret);
    /* skip device */
    /* skip pCopyImageToMemoryInfo */
    /* skip dataSize */
    if (vn_peek_array_size(dec)) {
        const size_t array_size = vn_decode_array_size(dec, dataSize);
        vn_decode_blob_array(dec, pData, array_size);
    } else {
        vn_decode_array_size_unchecked(dec);
        pData = NULL;
    }

    return ret;
}

static inline size_t vn_sizeof_vkCopyMemoryToImageMESA(VkDevice device, const VkCopyMemoryToImageInfoMESA* pCopyMemoryToImageInfo)
{
    const VkCommandTypeEXT cmd_type = VK_COMMAND_TYPE_vkCopyMemoryToImageMESA_EXT;
    const VkFlags cmd_flags = 0;
    size_t cmd_size = vn_sizeof_VkCommandTypeEXT(&cmd_type) + vn_sizeof_VkFlags(&cmd_flags);

    cmd_size += vn_sizeof_VkDevice(&device);
    cmd_size += vn_sizeof_simple_pointer(pCopyMemoryToImageInfo);
    if (pCopyMemoryToImageInfo)
        cmd_size += vn_sizeof_VkCopyMemoryToImageInfoMESA(pCopyMemoryToImageInfo);

    return cmd_size;
}

static inline void vn_encode_vkCopyMemoryToImageMESA(struct vn_cs_encoder *enc, VkCommandFlagsEXT cmd_flags, VkDevice device, const VkCopyMemoryToImageInfoMESA* pCopyMemoryToImageInfo)
{
    const VkCommandTypeEXT cmd_type = VK_COMMAND_TYPE_vkCopyMemoryToImageMESA_EXT;

    vn_encode_VkCommandTypeEXT(enc, &cmd_type);
    vn_encode_VkFlags(enc, &cmd_flags);

    vn_encode_VkDevice(enc, &device);
    if (vn_encode_simple_pointer(enc, pCopyMemoryToImageInfo))
        vn_encode_VkCopyMemoryToImageInfoMESA(enc, pCopyMemoryToImageInfo);
}

static inline size_t vn_sizeof_vkCopyMemoryToImageMESA_reply(VkDevice device, const VkCopyMemoryToImageInfoMESA* pCopyMemoryToImageInfo)
{
    const VkCommandTypeEXT cmd_type = VK_COMMAND_TYPE_vkCopyMemoryToImageMESA_EXT;
    size_t cmd_size = vn_sizeof_VkCommandTypeEXT(&cmd_type);

    VkResult ret;
    cmd_size += vn_sizeof_VkResult(&ret);
    /* skip device */
    /* skip pCopyMemoryToImageInfo */

    return cmd_size;
}

static inline VkResult vn_decode_vkCopyMemoryToImageMESA_reply(struct vn_cs_decoder *dec, VkDevice device, const VkCopyMemoryToImageInfoMESA* pCopyMemoryToImageInfo)
{
    VkCommandTypeEXT command_type;
    vn_decode_VkCommandTypeEXT(dec, &command_type);
    assert(command_type == VK_COMMAND_TYPE_vkCopyMemoryToImageMESA_EXT);

    VkResult ret;
    vn_decode_VkResult(dec, &ret);
    /* skip device */
    /* skip pCopyMemoryToImageInfo */

    return ret;
}

static inline void vn_submit_vkCopyImageToImage(struct vn_ring *vn_ring, VkCommandFlagsEXT cmd_flags, VkDevice device, const VkCopyImageToImageInfo* pCopyImageToImageInfo, struct vn_ring_submit_command *submit)
{
    uint8_t local_cmd_data[VN_SUBMIT_LOCAL_CMD_SIZE];
    void *cmd_data = local_cmd_data;
    size_t cmd_size = vn_sizeof_vkCopyImageToImage(device, pCopyImageToImageInfo);
    if (cmd_size > sizeof(local_cmd_data)) {
        cmd_data = malloc(cmd_size);
        if (!cmd_data)
            cmd_size = 0;
    }
    const size_t reply_size = cmd_flags & VK_COMMAND_GENERATE_REPLY_BIT_EXT ? vn_sizeof_vkCopyImageToImage_reply(device, pCopyImageToImageInfo) : 0;

    struct vn_cs_encoder *enc = vn_ring_submit_command_init(vn_ring, submit, cmd_data, cmd_size, reply_size);
    if (cmd_size) {
        vn_encode_vkCopyImageToImage(enc, cmd_flags, device, pCopyImageToImageInfo);
        vn_ring_submit_command(vn_ring, submit);
        if (cmd_data != local_cmd_data)
            free(cmd_data);
    }
}

static inline void vn_submit_vkTransitionImageLayout(struct vn_ring *vn_ring, VkCommandFlagsEXT cmd_flags, VkDevice device, uint32_t transitionCount, const VkHostImageLayoutTransitionInfo* pTransitions, struct vn_ring_submit_command *submit)
{
    uint8_t local_cmd_data[VN_SUBMIT_LOCAL_CMD_SIZE];
    void *cmd_data = local_cmd_data;
    size_t cmd_size = vn_sizeof_vkTransitionImageLayout(device, transitionCount, pTransitions);
    if (cmd_size > sizeof(local_cmd_data)) {
        cmd_data = malloc(cmd_size);
        if (!cmd_data)
            cmd_size = 0;
    }
    const size_t reply_size = cmd_flags & VK_COMMAND_GENERATE_REPLY_BIT_EXT ? vn_sizeof_vkTransitionImageLayout_reply(device, transitionCount, pTransitions) : 0;

    struct vn_cs_encoder *enc = vn_ring_submit_command_init(vn_ring, submit, cmd_data, cmd_size, reply_size);
    if (cmd_size) {
        vn_encode_vkTransitionImageLayout(enc, cmd_flags, device, transitionCount, pTransitions);
        vn_ring_submit_command(vn_ring, submit);
        if (cmd_data != local_cmd_data)
            free(cmd_data);
    }
}

static inline void vn_submit_vkCopyImageToMemoryMESA(struct vn_ring *vn_ring, VkCommandFlagsEXT cmd_flags, VkDevice device, const VkCopyImageToMemoryInfoMESA* pCopyImageToMemoryInfo, size_t dataSize, void* pData, struct vn_ring_submit_command *submit)
{
    uint8_t local_cmd_data[VN_SUBMIT_LOCAL_CMD_SIZE];
    void *cmd_data = local_cmd_data;
    size_t cmd_size = vn_sizeof_vkCopyImageToMemoryMESA(device, pCopyImageToMemoryInfo, dataSize, pData);
    if (cmd_size > sizeof(local_cmd_data)) {
        cmd_data = malloc(cmd_size);
        if (!cmd_data)
            cmd_size = 0;
    }
    const size_t reply_size = cmd_flags & VK_COMMAND_GENERATE_REPLY_BIT_EXT ? vn_sizeof_vkCopyImageToMemoryMESA_reply(device, pCopyImageToMemoryInfo, dataSize, pData) : 0;

    struct vn_cs_encoder *enc = vn_ring_submit_command_init(vn_ring, submit, cmd_data, cmd_size, reply_size);
    if (cmd_size) {
        vn_encode_vkCopyImageToMemoryMESA(enc, cmd_flags, device, pCopyImageToMemoryInfo, dataSize, pData);
        vn_ring_submit_command(vn_ring, submit);
        if (cmd_data != local_cmd_data)
            free(cmd_data);
    }
}

static inline void vn_submit_vkCopyMemoryToImageMESA(struct vn_ring *vn_ring, VkCommandFlagsEXT cmd_flags, VkDevice device, const VkCopyMemoryToImageInfoMESA* pCopyMemoryToImageInfo, struct vn_ring_submit_command *submit)
{
    uint8_t local_cmd_data[VN_SUBMIT_LOCAL_CMD_SIZE];
    void *cmd_data = local_cmd_data;
    size_t cmd_size = vn_sizeof_vkCopyMemoryToImageMESA(device, pCopyMemoryToImageInfo);
    if (cmd_size > sizeof(local_cmd_data)) {
        cmd_data = malloc(cmd_size);
        if (!cmd_data)
            cmd_size = 0;
    }
    const size_t reply_size = cmd_flags & VK_COMMAND_GENERATE_REPLY_BIT_EXT ? vn_sizeof_vkCopyMemoryToImageMESA_reply(device, pCopyMemoryToImageInfo) : 0;

    struct vn_cs_encoder *enc = vn_ring_submit_command_init(vn_ring, submit, cmd_data, cmd_size, reply_size);
    if (cmd_size) {
        vn_encode_vkCopyMemoryToImageMESA(enc, cmd_flags, device, pCopyMemoryToImageInfo);
        vn_ring_submit_command(vn_ring, submit);
        if (cmd_data != local_cmd_data)
            free(cmd_data);
    }
}

static inline VkResult vn_call_vkCopyImageToImage(struct vn_ring *vn_ring, VkDevice device, const VkCopyImageToImageInfo* pCopyImageToImageInfo)
{
    VN_TRACE_FUNC();

    struct vn_ring_submit_command submit;
    vn_submit_vkCopyImageToImage(vn_ring, VK_COMMAND_GENERATE_REPLY_BIT_EXT, device, pCopyImageToImageInfo, &submit);
    struct vn_cs_decoder *dec = vn_ring_get_command_reply(vn_ring, &submit);
    if (dec) {
        const VkResult ret = vn_decode_vkCopyImageToImage_reply(dec, device, pCopyImageToImageInfo);
        vn_ring_free_command_reply(vn_ring, &submit);
        return ret;
    } else {
        return VK_ERROR_OUT_OF_HOST_MEMORY;
    }
}

static inline void vn_async_vkCopyImageToImage(struct vn_ring *vn_ring, VkDevice device, const VkCopyImageToImageInfo* pCopyImageToImageInfo)
{
    struct vn_ring_submit_command submit;
    vn_submit_vkCopyImageToImage(vn_ring, 0, device, pCopyImageToImageInfo, &submit);
}

static inline VkResult vn_call_vkTransitionImageLayout(struct vn_ring *vn_ring, VkDevice device, uint32_t transitionCount, const VkHostImageLayoutTransitionInfo* pTransitions)
{
    VN_TRACE_FUNC();

    struct vn_ring_submit_command submit;
    vn_submit_vkTransitionImageLayout(vn_ring, VK_COMMAND_GENERATE_REPLY_BIT_EXT, device, transitionCount, pTransitions, &submit);
    struct vn_cs_decoder *dec = vn_ring_get_command_reply(vn_ring, &submit);
    if (dec) {
        const VkResult ret = vn_decode_vkTransitionImageLayout_reply(dec, device, transitionCount, pTransitions);
        vn_ring_free_command_reply(vn_ring, &submit);
        return ret;
    } else {
        return VK_ERROR_OUT_OF_HOST_MEMORY;
    }
}

static inline void vn_async_vkTransitionImageLayout(struct vn_ring *vn_ring, VkDevice device, uint32_t transitionCount, const VkHostImageLayoutTransitionInfo* pTransitions)
{
    struct vn_ring_submit_command submit;
    vn_submit_vkTransitionImageLayout(vn_ring, 0, device, transitionCount, pTransitions, &submit);
}

static inline VkResult vn_call_vkCopyImageToMemoryMESA(struct vn_ring *vn_ring, VkDevice device, const VkCopyImageToMemoryInfoMESA* pCopyImageToMemoryInfo, size_t dataSize, void* pData)
{
    VN_TRACE_FUNC();

    struct vn_ring_submit_command submit;
    vn_submit_vkCopyImageToMemoryMESA(vn_ring, VK_COMMAND_GENERATE_REPLY_BIT_EXT, device, pCopyImageToMemoryInfo, dataSize, pData, &submit);
    struct vn_cs_decoder *dec = vn_ring_get_command_reply(vn_ring, &submit);
    if (dec) {
        const VkResult ret = vn_decode_vkCopyImageToMemoryMESA_reply(dec, device, pCopyImageToMemoryInfo, dataSize, pData);
        vn_ring_free_command_reply(vn_ring, &submit);
        return ret;
    } else {
        return VK_ERROR_OUT_OF_HOST_MEMORY;
    }
}

static inline void vn_async_vkCopyImageToMemoryMESA(struct vn_ring *vn_ring, VkDevice device, const VkCopyImageToMemoryInfoMESA* pCopyImageToMemoryInfo, size_t dataSize, void* pData)
{
    struct vn_ring_submit_command submit;
    vn_submit_vkCopyImageToMemoryMESA(vn_ring, 0, device, pCopyImageToMemoryInfo, dataSize, pData, &submit);
}

static inline VkResult vn_call_vkCopyMemoryToImageMESA(struct vn_ring *vn_ring, VkDevice device, const VkCopyMemoryToImageInfoMESA* pCopyMemoryToImageInfo)
{
    VN_TRACE_FUNC();

    struct vn_ring_submit_command submit;
    vn_submit_vkCopyMemoryToImageMESA(vn_ring, VK_COMMAND_GENERATE_REPLY_BIT_EXT, device, pCopyMemoryToImageInfo, &submit);
    struct vn_cs_decoder *dec = vn_ring_get_command_reply(vn_ring, &submit);
    if (dec) {
        const VkResult ret = vn_decode_vkCopyMemoryToImageMESA_reply(dec, device, pCopyMemoryToImageInfo);
        vn_ring_free_command_reply(vn_ring, &submit);
        return ret;
    } else {
        return VK_ERROR_OUT_OF_HOST_MEMORY;
    }
}

static inline void vn_async_vkCopyMemoryToImageMESA(struct vn_ring *vn_ring, VkDevice device, const VkCopyMemoryToImageInfoMESA* pCopyMemoryToImageInfo)
{
    struct vn_ring_submit_command submit;
    vn_submit_vkCopyMemoryToImageMESA(vn_ring, 0, device, pCopyMemoryToImageInfo, &submit);
}

#endif /* VN_PROTOCOL_DRIVER_HOST_COPY_H */
