/*
 * Decompiled with CFR 0.152.
 */
package org.apache.harmony.jndi.provider.dns;

import java.util.Enumeration;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.StringTokenizer;
import javax.naming.Binding;
import javax.naming.CannotProceedException;
import javax.naming.CompositeName;
import javax.naming.ConfigurationException;
import javax.naming.Context;
import javax.naming.InvalidNameException;
import javax.naming.Name;
import javax.naming.NameClassPair;
import javax.naming.NameParser;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.NoPermissionException;
import javax.naming.NotContextException;
import javax.naming.OperationNotSupportedException;
import javax.naming.RefAddr;
import javax.naming.Reference;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.BasicAttribute;
import javax.naming.directory.BasicAttributes;
import javax.naming.directory.DirContext;
import javax.naming.directory.InvalidAttributeIdentifierException;
import javax.naming.directory.ModificationItem;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;
import javax.naming.spi.DirectoryManager;
import org.apache.harmony.jndi.internal.nls.Messages;
import org.apache.harmony.jndi.provider.dns.BasicNamingEnumerator;
import org.apache.harmony.jndi.provider.dns.DNSName;
import org.apache.harmony.jndi.provider.dns.DNSNameParser;
import org.apache.harmony.jndi.provider.dns.DNSPseudoURL;
import org.apache.harmony.jndi.provider.dns.ProviderConstants;
import org.apache.harmony.jndi.provider.dns.ProviderMgr;
import org.apache.harmony.jndi.provider.dns.Resolver;
import org.apache.harmony.jndi.provider.dns.ResourceRecord;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DNSContext
implements DirContext,
Cloneable {
    public static final String LOOKUP_ATTR = "org.apache.harmony.jndi.provider.dns.lookup.attr";
    public static final String RECURSION = "org.apache.harmony.jndi.provider.dns.recursion";
    public static final String TIMEOUT_INITIAL = "org.apache.harmony.jndi.provider.dns.timeout.initial";
    public static final String TIMEOUT_RETRIES = "org.apache.harmony.jndi.provider.dns.timeout.retries";
    public static final String THREADS_MAX = "org.apache.harmony.jndi.provider.dns.threads.max";
    private static final int NAME_CLASS_SWT = 1;
    private static final int BINDING_SWT = 2;
    private DNSNameParser nameParser;
    private Hashtable<Object, Object> environment;
    private Resolver resolver;
    private DNSName contextName;
    private boolean authoritative = false;
    private int lookupAttrType = 16;
    private int lookupAttrClass = 1;
    private boolean recursion = true;
    private int timeoutInitial = 1000;
    private int timeoutRetries = 4;
    private int maxThreads = 7;

    DNSContext(Hashtable<?, ?> env) throws NamingException {
        this.nameParser = new DNSNameParser();
        if (env == null) {
            throw new NullPointerException(Messages.getString("jndi.45"));
        }
        this.environment = (Hashtable)env.clone();
        this.parseBoolProp("java.naming.authoritative");
        this.parseLookupProp();
        if (this.environment.containsKey(RECURSION)) {
            this.parseBoolProp(RECURSION);
        }
        if (this.environment.containsKey(TIMEOUT_INITIAL)) {
            this.parseIntProp(TIMEOUT_INITIAL);
        }
        if (this.environment.containsKey(TIMEOUT_RETRIES)) {
            this.parseIntProp(TIMEOUT_RETRIES);
        }
        this.parseIntProp(THREADS_MAX);
        this.resolver = new Resolver(this.timeoutInitial, this.timeoutRetries, this.maxThreads, this.authoritative, this.recursion);
        this.parseProviderUrlProp();
    }

    private void parseIntProp(String paramName) throws NumberFormatException {
        Object tmp = this.environment.get(paramName);
        if (tmp != null && tmp instanceof String) {
            int n = Integer.parseInt((String)tmp);
            if (paramName.equals(TIMEOUT_RETRIES)) {
                this.timeoutRetries = n;
            } else if (paramName.equals(TIMEOUT_INITIAL)) {
                this.timeoutInitial = n;
            } else if (paramName.equals(THREADS_MAX)) {
                this.maxThreads = n;
            }
        }
    }

    private void parseBoolProp(String paramName) {
        Object tmp = this.environment.get(paramName);
        boolean val = false;
        if (tmp != null) {
            if (tmp instanceof String && tmp.equals("true")) {
                val = true;
            }
            if (paramName.equals("java.naming.authoritative")) {
                this.authoritative = val;
            } else if (paramName.equals(RECURSION)) {
                this.recursion = val;
            }
        }
    }

    private void parseLookupProp() throws ConfigurationException {
        Object tmp;
        if (this.environment.containsKey(LOOKUP_ATTR) && (tmp = this.environment.get(LOOKUP_ATTR)) instanceof String) {
            String recTypeName;
            String lookupAttr = (String)tmp;
            int k = lookupAttr.indexOf(" ");
            if (k > -1) {
                String recClassName = lookupAttr.substring(0, k);
                this.lookupAttrClass = ProviderMgr.getRecordClassNumber(recClassName);
                if (this.lookupAttrClass == -1) {
                    throw new ConfigurationException(Messages.getString("jndi.46", recClassName));
                }
                recTypeName = lookupAttr.substring(k).trim();
            } else {
                this.lookupAttrClass = 1;
                recTypeName = lookupAttr.trim();
            }
            this.lookupAttrType = ProviderMgr.getRecordTypeNumber(recTypeName);
            if (this.lookupAttrType == -1) {
                throw new ConfigurationException(Messages.getString("jndi.47", recTypeName));
            }
        }
    }

    private void parseProviderUrlProp() throws NamingException {
        if (this.environment.containsKey("java.naming.provider.url")) {
            Object tmp = this.environment.get("java.naming.provider.url");
            if (tmp instanceof String) {
                StringTokenizer st = new StringTokenizer((String)tmp, " ");
                while (st.hasMoreTokens()) {
                    String token = st.nextToken();
                    try {
                        DNSPseudoURL dnsURL = new DNSPseudoURL(token);
                        if (dnsURL.isHostIpGiven()) {
                            this.resolver.addInitialServer(null, dnsURL.getHost(), dnsURL.getPort(), dnsURL.getDomain());
                        } else {
                            this.resolver.addInitialServer(dnsURL.getHost(), null, dnsURL.getPort(), dnsURL.getDomain());
                        }
                        if (this.contextName == null) {
                            this.contextName = (DNSName)this.nameParser.parse(dnsURL.getDomain());
                            continue;
                        }
                        DNSName name2 = (DNSName)this.nameParser.parse(dnsURL.getDomain());
                        if (name2.compareTo(this.contextName) == 0) continue;
                        throw new ConfigurationException(Messages.getString("jndi.48", this.contextName, name2));
                    }
                    catch (IllegalArgumentException e) {
                        throw new ConfigurationException(Messages.getString("jndi.49", token, e.getMessage()));
                    }
                }
            }
        } else {
            this.contextName = ProviderConstants.ROOT_ZONE_NAME_OBJ;
        }
    }

    DNSContext(DNSContext ancestorCtx, DNSName name) {
        this.contextName = (DNSName)name.clone();
        this.nameParser = ancestorCtx.nameParser;
        this.environment = (Hashtable)ancestorCtx.environment.clone();
        this.resolver = ancestorCtx.resolver;
        this.authoritative = ancestorCtx.authoritative;
        this.lookupAttrType = ancestorCtx.lookupAttrType;
        this.lookupAttrClass = ancestorCtx.lookupAttrClass;
        this.recursion = ancestorCtx.recursion;
        this.timeoutInitial = ancestorCtx.timeoutInitial;
        this.timeoutRetries = ancestorCtx.timeoutRetries;
        this.maxThreads = ancestorCtx.maxThreads;
    }

    @Override
    public Attributes getAttributes(String name) throws NamingException {
        return this.getAttributes(this.convertNameFromStringForm(name), null);
    }

    @Override
    public void modifyAttributes(String arg0, int arg1, Attributes arg2) throws NamingException {
        Object obj = this.lookup(arg0);
        if (obj instanceof DNSContext) {
            throw new OperationNotSupportedException();
        }
        if (!(obj instanceof DirContext)) {
            throw new NotContextException(Messages.getString("jndi.4A"));
        }
        ((DirContext)obj).modifyAttributes("", arg1, arg2);
    }

    @Override
    public Attributes getAttributes(Name name) throws NamingException {
        return this.getAttributes(name, null);
    }

    @Override
    public void modifyAttributes(Name arg0, int arg1, Attributes arg2) throws NamingException {
        Object obj = this.lookup(arg0);
        if (obj instanceof DNSContext) {
            throw new OperationNotSupportedException();
        }
        if (!(obj instanceof DirContext)) {
            throw new NotContextException(Messages.getString("jndi.4A"));
        }
        ((DirContext)obj).modifyAttributes("", arg1, arg2);
    }

    @Override
    public DirContext getSchema(String arg0) throws NamingException {
        Object obj = this.lookup(arg0);
        if (obj instanceof DNSContext) {
            throw new OperationNotSupportedException();
        }
        if (obj instanceof DirContext) {
            return ((DirContext)obj).getSchema("");
        }
        throw new NotContextException(Messages.getString("jndi.4A"));
    }

    @Override
    public DirContext getSchemaClassDefinition(String arg0) throws NamingException {
        Object obj = this.lookup(arg0);
        if (obj instanceof DNSContext) {
            throw new OperationNotSupportedException();
        }
        if (obj instanceof DirContext) {
            return ((DirContext)obj).getSchemaClassDefinition("");
        }
        throw new NotContextException(Messages.getString("jndi.4A"));
    }

    @Override
    public DirContext getSchema(Name arg0) throws NamingException {
        Object obj = this.lookup(arg0);
        if (obj instanceof DNSContext) {
            throw new OperationNotSupportedException();
        }
        if (obj instanceof DirContext) {
            return ((DirContext)obj).getSchema("");
        }
        throw new NotContextException(Messages.getString("jndi.4A"));
    }

    @Override
    public DirContext getSchemaClassDefinition(Name arg0) throws NamingException {
        Object obj = this.lookup(arg0);
        if (obj instanceof DNSContext) {
            throw new OperationNotSupportedException();
        }
        if (obj instanceof DirContext) {
            return ((DirContext)obj).getSchemaClassDefinition("");
        }
        throw new NotContextException(Messages.getString("jndi.4A"));
    }

    @Override
    public void modifyAttributes(String arg0, ModificationItem[] arg1) throws NamingException {
        Object obj = this.lookup(arg0);
        if (obj instanceof DNSContext) {
            throw new OperationNotSupportedException();
        }
        if (!(obj instanceof DirContext)) {
            throw new NotContextException(Messages.getString("jndi.4A"));
        }
        ((DirContext)obj).modifyAttributes("", arg1);
    }

    @Override
    public void modifyAttributes(Name arg0, ModificationItem[] arg1) throws NamingException {
        Object obj = this.lookup(arg0);
        if (obj instanceof DNSContext) {
            throw new OperationNotSupportedException();
        }
        if (!(obj instanceof DirContext)) {
            throw new NotContextException(Messages.getString("jndi.4A"));
        }
        ((DirContext)obj).modifyAttributes("", arg1);
    }

    @Override
    public NamingEnumeration<SearchResult> search(String arg0, Attributes arg1) throws NamingException {
        Object obj = this.lookup(arg0);
        if (obj instanceof DNSContext) {
            throw new OperationNotSupportedException();
        }
        if (obj instanceof DirContext) {
            return ((DirContext)obj).search("", arg1);
        }
        throw new NotContextException(Messages.getString("jndi.4A"));
    }

    @Override
    public NamingEnumeration<SearchResult> search(Name arg0, Attributes arg1) throws NamingException {
        Object obj = this.lookup(arg0);
        if (obj instanceof DNSContext) {
            throw new OperationNotSupportedException();
        }
        if (obj instanceof DirContext) {
            return ((DirContext)obj).search("", arg1);
        }
        throw new NotContextException(Messages.getString("jndi.4A"));
    }

    @Override
    public void bind(String arg0, Object arg1, Attributes arg2) throws NamingException {
        this.bind(this.convertNameFromStringForm(arg0), arg1, arg2);
    }

    @Override
    public void rebind(String arg0, Object arg1, Attributes arg2) throws NamingException {
        this.rebind(this.convertNameFromStringForm(arg0), arg1, arg2);
    }

    @Override
    public void bind(Name arg0, Object arg1, Attributes arg2) throws NamingException {
        ContextNamePair pair;
        try {
            pair = this.getTargetNamespaceContextNamePair(arg0);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new OperationNotSupportedException();
        }
        if (!(pair.context instanceof DirContext)) {
            throw new NotContextException(Messages.getString("jndi.4A"));
        }
        ((DirContext)pair.context).bind(pair.name, arg1, arg2);
    }

    @Override
    public void rebind(Name arg0, Object arg1, Attributes arg2) throws NamingException {
        ContextNamePair pair;
        try {
            pair = this.getTargetNamespaceContextNamePair(arg0);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new OperationNotSupportedException();
        }
        if (!(pair.context instanceof DirContext)) {
            throw new NotContextException(Messages.getString("jndi.4A"));
        }
        ((DirContext)pair.context).rebind(pair.name, arg1, arg2);
    }

    @Override
    public Attributes getAttributes(String name, String[] attrNames) throws NamingException {
        return this.getAttributes(this.convertNameFromStringForm(name), attrNames);
    }

    @Override
    public Attributes getAttributes(Name name, String[] attrNames) throws NamingException {
        DNSName nameToLookFor = null;
        DNSName altName = null;
        CompositeName remainingName = null;
        Attributes attrs = null;
        if (name == null) {
            throw new NullPointerException(Messages.getString("jndi.2E"));
        }
        if (name.size() == 0) {
            nameToLookFor = (DNSName)this.contextName.clone();
        } else if (name instanceof CompositeName) {
            String tmp = name.get(0);
            altName = (DNSName)this.nameParser.parse(tmp);
            nameToLookFor = (DNSName)this.composeName(altName, this.contextName);
            if (name.size() > 1) {
                remainingName = (CompositeName)name.getSuffix(1);
            }
        } else if (name instanceof DNSName) {
            nameToLookFor = (DNSName)this.composeName(name, this.contextName);
        } else {
            throw new InvalidNameException(Messages.getString("jndi.4B"));
        }
        if (remainingName != null) {
            CannotProceedException cpe = this.constructCannotProceedException(altName, remainingName);
            DirContext nnsContext = DirectoryManager.getContinuationDirContext(cpe);
            attrs = nnsContext.getAttributes(remainingName, attrNames);
        } else {
            int[] classes;
            int[] types;
            if (attrNames == null) {
                types = new int[1];
                classes = new int[1];
                types[0] = 255;
                classes[0] = 255;
            } else {
                Integer n;
                HashSet<Integer> classesSet = new HashSet<Integer>();
                HashSet<Integer> typesSet = new HashSet<Integer>();
                String[] stringArray = attrNames;
                int n2 = 0;
                int n3 = stringArray.length;
                while (n2 < n3) {
                    String element = stringArray[n2];
                    int k = element.indexOf(32);
                    String typeStr = null;
                    if (k > 0) {
                        String classStr = element.substring(0, k);
                        int classInt = ProviderMgr.getRecordClassNumber(classStr);
                        if (classInt == -1) {
                            throw new InvalidAttributeIdentifierException(Messages.getString("jndi.4C", classStr));
                        }
                        classesSet.add(new Integer(classInt));
                        typeStr = element.substring(k, element.length()).trim();
                    } else {
                        classesSet.add(new Integer(1));
                        typeStr = element.trim();
                    }
                    int typesInt = ProviderMgr.getRecordTypeNumber(typeStr);
                    if (typesInt == -1) {
                        throw new InvalidAttributeIdentifierException(Messages.getString("jndi.4D", typeStr));
                    }
                    typesSet.add(new Integer(typesInt));
                    ++n2;
                }
                classes = new int[classesSet.size()];
                Iterator iter = classesSet.iterator();
                int j = 0;
                while (iter.hasNext()) {
                    n = (Integer)iter.next();
                    classes[j++] = n;
                }
                types = new int[typesSet.size()];
                iter = typesSet.iterator();
                j = 0;
                while (iter.hasNext()) {
                    n = (Integer)iter.next();
                    types[j++] = n;
                }
            }
            try {
                Enumeration<ResourceRecord> records = this.resolver.lookup(nameToLookFor.toString(), types, classes);
                attrs = DNSContext.createAttributesFromRecords(records);
            }
            catch (SecurityException e) {
                NoPermissionException e2 = new NoPermissionException();
                e2.setRootCause(e);
                throw e2;
            }
            catch (NamingException e) {
                throw e;
            }
            catch (Exception e) {
                NamingException ne = new NamingException();
                ne.setRootCause(e);
                throw ne;
            }
        }
        return attrs;
    }

    @Override
    public DirContext createSubcontext(String arg0, Attributes arg1) throws NamingException {
        return this.createSubcontext(this.convertNameFromStringForm(arg0), arg1);
    }

    @Override
    public DirContext createSubcontext(Name arg0, Attributes arg1) throws NamingException {
        ContextNamePair pair;
        try {
            pair = this.getTargetNamespaceContextNamePair(arg0);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new OperationNotSupportedException();
        }
        if (pair.context instanceof DirContext) {
            return ((DirContext)pair.context).createSubcontext(pair.name, arg1);
        }
        throw new NotContextException(Messages.getString("jndi.4A"));
    }

    @Override
    public NamingEnumeration<SearchResult> search(String arg0, Attributes arg1, String[] arg2) throws NamingException {
        Object obj = this.lookup(arg0);
        if (obj instanceof DNSContext) {
            throw new OperationNotSupportedException();
        }
        if (obj instanceof DirContext) {
            return ((DirContext)obj).search("", arg1, arg2);
        }
        throw new NotContextException(Messages.getString("jndi.4A"));
    }

    @Override
    public NamingEnumeration<SearchResult> search(Name arg0, Attributes arg1, String[] arg2) throws NamingException {
        Object obj = this.lookup(arg0);
        if (obj instanceof DNSContext) {
            throw new OperationNotSupportedException();
        }
        if (obj instanceof DirContext) {
            return ((DirContext)obj).search("", arg1, arg2);
        }
        throw new NotContextException(Messages.getString("jndi.4A"));
    }

    @Override
    public NamingEnumeration<SearchResult> search(String arg0, String arg1, SearchControls arg2) throws NamingException {
        Object obj = this.lookup(arg0);
        if (obj instanceof DNSContext) {
            throw new OperationNotSupportedException();
        }
        if (obj instanceof DirContext) {
            return ((DirContext)obj).search("", arg1, arg2);
        }
        throw new NotContextException(Messages.getString("jndi.4A"));
    }

    @Override
    public NamingEnumeration<SearchResult> search(Name arg0, String arg1, SearchControls arg2) throws NamingException {
        Object obj = this.lookup(arg0);
        if (obj instanceof DNSContext) {
            throw new OperationNotSupportedException();
        }
        if (obj instanceof DirContext) {
            return ((DirContext)obj).search("", arg1, arg2);
        }
        throw new NotContextException(Messages.getString("jndi.4A"));
    }

    @Override
    public NamingEnumeration<SearchResult> search(String arg0, String arg1, Object[] arg2, SearchControls arg3) throws NamingException {
        Object obj = this.lookup(arg0);
        if (obj instanceof DNSContext) {
            throw new OperationNotSupportedException();
        }
        if (obj instanceof DirContext) {
            return ((DirContext)obj).search("", arg1, arg2, arg3);
        }
        throw new NotContextException(Messages.getString("jndi.4A"));
    }

    @Override
    public NamingEnumeration<SearchResult> search(Name arg0, String arg1, Object[] arg2, SearchControls arg3) throws NamingException {
        Object obj = this.lookup(arg0);
        if (obj instanceof DNSContext) {
            throw new OperationNotSupportedException();
        }
        if (obj instanceof DirContext) {
            return ((DirContext)obj).search("", arg1, arg2, arg3);
        }
        throw new NotContextException(Messages.getString("jndi.4A"));
    }

    @Override
    public void close() throws NamingException {
    }

    @Override
    public String getNameInNamespace() {
        return this.contextName.toString();
    }

    @Override
    public void destroySubcontext(String arg0) throws NamingException {
        this.destroySubcontext(this.convertNameFromStringForm(arg0));
    }

    @Override
    public void unbind(String arg0) throws NamingException {
        this.unbind(this.convertNameFromStringForm(arg0));
    }

    @Override
    public Hashtable<?, ?> getEnvironment() throws NamingException {
        return (Hashtable)this.environment.clone();
    }

    @Override
    public void destroySubcontext(Name arg0) throws NamingException {
        ContextNamePair pair;
        try {
            pair = this.getTargetNamespaceContextNamePair(arg0);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new OperationNotSupportedException();
        }
        if (!(pair.context instanceof Context)) {
            throw new NotContextException(Messages.getString("jndi.4E"));
        }
        ((Context)pair.context).destroySubcontext(pair.name);
    }

    @Override
    public void unbind(Name arg0) throws NamingException {
        ContextNamePair pair;
        try {
            pair = this.getTargetNamespaceContextNamePair(arg0);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new OperationNotSupportedException();
        }
        if (!(pair.context instanceof Context)) {
            throw new NotContextException(Messages.getString("jndi.4E"));
        }
        ((Context)pair.context).unbind(pair.name);
    }

    @Override
    public Object lookup(String name) throws NamingException {
        return this.lookup(this.convertNameFromStringForm(name));
    }

    private Name convertNameFromStringForm(String nameStr) throws InvalidNameException {
        Name nameObj = null;
        if (nameStr == null) {
            throw new NullPointerException(Messages.getString("jndi.2E"));
        }
        nameObj = new CompositeName(nameStr);
        if (nameObj.size() == 1) {
            nameObj = this.nameParser.parse(nameStr);
        } else if (nameObj.size() == 0) {
            nameObj = new DNSName();
        }
        return nameObj;
    }

    @Override
    public Object lookupLink(String name) throws NamingException {
        return this.lookup(name);
    }

    @Override
    public Object removeFromEnvironment(String name) {
        return this.environment.remove(name);
    }

    @Override
    public void bind(String arg0, Object arg1) throws NamingException {
        this.bind(this.convertNameFromStringForm(arg0), arg1);
    }

    @Override
    public void rebind(String arg0, Object arg1) throws NamingException {
        this.rebind(this.convertNameFromStringForm(arg0), arg1);
    }

    @Override
    public Object lookup(Name name) throws NamingException {
        int[] types = new int[1];
        int[] classes = new int[1];
        DNSName nameToLookFor = null;
        DNSName altName = null;
        CompositeName remainingName = null;
        Object result = null;
        if (name == null) {
            throw new NullPointerException(Messages.getString("jndi.2E"));
        }
        if (name.size() == 0) {
            nameToLookFor = (DNSName)this.contextName.clone();
        } else if (name instanceof CompositeName) {
            String tmp = name.get(0);
            altName = (DNSName)this.nameParser.parse(tmp);
            nameToLookFor = (DNSName)this.composeName(altName, this.contextName);
            if (name.size() > 1) {
                remainingName = (CompositeName)name.getSuffix(1);
            }
        } else if (name instanceof DNSName) {
            nameToLookFor = (DNSName)this.composeName(name, this.contextName);
        } else {
            throw new InvalidNameException(Messages.getString("jndi.4B"));
        }
        types[0] = this.lookupAttrType;
        classes[0] = this.lookupAttrClass;
        if (remainingName != null) {
            CannotProceedException cpe = this.constructCannotProceedException(altName, remainingName);
            Context nnsContext = DirectoryManager.getContinuationContext(cpe);
            result = nnsContext.lookup(remainingName);
        } else {
            try {
                DNSContext resolvedCtx = new DNSContext(this, nameToLookFor);
                Enumeration<ResourceRecord> records = this.resolver.lookup(nameToLookFor.toString(), types, classes);
                Attributes attrs = DNSContext.createAttributesFromRecords(records);
                result = DirectoryManager.getObjectInstance(resolvedCtx, name, this, this.environment, attrs);
            }
            catch (SecurityException e) {
                NoPermissionException e2 = new NoPermissionException(e.getMessage());
                e2.setRootCause(e);
                throw e2;
            }
            catch (NamingException e) {
                throw e;
            }
            catch (Exception e) {
                NamingException ne = new NamingException(e.getMessage());
                ne.setRootCause(e);
                throw ne;
            }
        }
        return result;
    }

    private CannotProceedException constructCannotProceedException(DNSName name, CompositeName remainingName) throws NamingException {
        DNSName nameToLookFor = (DNSName)this.composeName(name, this.contextName);
        DNSContext resolvedCtx = new DNSContext(this, nameToLookFor);
        RefAddr refAddr = new RefAddr("nns", resolvedCtx){
            private static final long serialVersionUID = 8654740210501193418L;
            DNSContext context;
            {
                this.context = (DNSContext)dNSContext2.clone();
            }

            public Object getContent() {
                return this.context;
            }
        };
        Reference ref = new Reference(this.getClass().getName(), refAddr);
        CannotProceedException cpe = null;
        CompositeName resolvedName = null;
        if (this.environment.containsKey("java.naming.spi.CannotProceedException")) {
            cpe = (CannotProceedException)this.environment.get("java.naming.spi.CannotProceedException");
            resolvedName = (CompositeName)cpe.getResolvedName();
            if (resolvedName != null && resolvedName.get(resolvedName.size() - 1).equals("")) {
                resolvedName.remove(resolvedName.size() - 1);
            }
        } else {
            cpe = new CannotProceedException();
        }
        cpe.setEnvironment((Hashtable)this.environment.clone());
        cpe.setAltName(name);
        cpe.setAltNameCtx((DNSContext)this.clone());
        cpe.setRemainingName(remainingName);
        if (resolvedName == null) {
            resolvedName = new CompositeName();
        }
        resolvedName.add(nameToLookFor.toString());
        resolvedName.add("");
        cpe.setResolvedName(resolvedName);
        cpe.setResolvedObj(ref);
        return cpe;
    }

    private static Attributes createAttributesFromRecords(Enumeration<ResourceRecord> recs) {
        BasicAttributes attrs = new BasicAttributes(true);
        while (recs.hasMoreElements()) {
            ResourceRecord curRec = recs.nextElement();
            String clssTypeStr = null;
            Attribute oldAttr = null;
            clssTypeStr = curRec.getRRClass() == 1 ? ProviderConstants.rrTypeNames[curRec.getRRType()] : String.valueOf(ProviderConstants.rrClassNames[curRec.getRRClass()]) + " " + ProviderConstants.rrTypeNames[curRec.getRRType()];
            oldAttr = attrs.get(clssTypeStr);
            if (oldAttr != null) {
                oldAttr.add(oldAttr.size(), curRec.getRData());
                continue;
            }
            BasicAttribute attr = new BasicAttribute(clssTypeStr, curRec.getRData(), false);
            attrs.put(attr);
        }
        return attrs;
    }

    @Override
    public Object lookupLink(Name name) throws NamingException {
        return this.lookup(name);
    }

    @Override
    public void bind(Name arg0, Object arg1) throws NamingException {
        ContextNamePair pair;
        try {
            pair = this.getTargetNamespaceContextNamePair(arg0);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new OperationNotSupportedException();
        }
        if (!(pair.context instanceof Context)) {
            throw new NotContextException(Messages.getString("jndi.4E"));
        }
        ((Context)pair.context).bind(pair.name, arg1);
    }

    @Override
    public void rebind(Name arg0, Object arg1) throws NamingException {
        ContextNamePair pair;
        try {
            pair = this.getTargetNamespaceContextNamePair(arg0);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new OperationNotSupportedException();
        }
        if (!(pair.context instanceof Context)) {
            throw new NotContextException(Messages.getString("jndi.4E"));
        }
        ((Context)pair.context).rebind(pair.name, arg1);
    }

    @Override
    public void rename(String arg0, String arg1) throws NamingException {
        this.rename(this.convertNameFromStringForm(arg0), this.convertNameFromStringForm(arg1));
    }

    @Override
    public Context createSubcontext(String arg0) throws NamingException {
        return this.createSubcontext(this.convertNameFromStringForm(arg0));
    }

    @Override
    public Context createSubcontext(Name arg0) throws NamingException {
        ContextNamePair pair;
        try {
            pair = this.getTargetNamespaceContextNamePair(arg0);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new OperationNotSupportedException();
        }
        if (pair.context instanceof Context) {
            return ((Context)pair.context).createSubcontext(pair.name);
        }
        throw new NotContextException(Messages.getString("jndi.4E"));
    }

    @Override
    public void rename(Name arg0, Name arg1) throws NamingException {
        ContextNamePair pair2;
        ContextNamePair pair1;
        try {
            pair1 = this.getTargetNamespaceContextNamePair(arg0);
            pair2 = this.getTargetNamespaceContextNamePair(arg1);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new OperationNotSupportedException();
        }
        if (!(pair1.context instanceof Context && pair1.context.getClass().getName().equals(pair2.context.getClass().getName()) && ((Context)pair1.context).getNameInNamespace().equals(((Context)pair2.context).getNameInNamespace()))) {
            throw new NotContextException(Messages.getString("jndi.4F"));
        }
        ((Context)pair1.context).rename(pair1.name, pair2.name);
    }

    @Override
    public NameParser getNameParser(String name) throws NamingException {
        if (name == null) {
            throw new NullPointerException(Messages.getString("jndi.2E"));
        }
        Object obj = this.lookup(name);
        if (obj instanceof DNSContext) {
            return this.nameParser;
        }
        if (obj instanceof Context) {
            return ((Context)obj).getNameParser("");
        }
        throw new NotContextException(Messages.getString("jndi.4E"));
    }

    @Override
    public NameParser getNameParser(Name name) throws NamingException {
        if (name == null) {
            throw new NullPointerException(Messages.getString("jndi.2E"));
        }
        Object obj = this.lookup(name);
        if (obj instanceof DNSContext) {
            return this.nameParser;
        }
        if (obj instanceof Context) {
            return ((Context)obj).getNameParser("");
        }
        throw new NotContextException(Messages.getString("jndi.4E"));
    }

    @Override
    public NamingEnumeration<NameClassPair> list(String name) throws NamingException {
        return this.list_common(this.convertNameFromStringForm(name), 1);
    }

    @Override
    public NamingEnumeration<Binding> listBindings(String name) throws NamingException {
        return this.list_common(this.convertNameFromStringForm(name), 2);
    }

    @Override
    public NamingEnumeration<NameClassPair> list(Name name) throws NamingException {
        return this.list_common(name, 1);
    }

    private <T> NamingEnumeration<T> list_common(Name name, int contentSwt) throws NamingException {
        DNSName nameToList = null;
        DNSName altName = null;
        CompositeName remainingName = null;
        NamingEnumeration<NameClassPair> result = null;
        if (contentSwt != 1 && contentSwt != 2) {
            throw new IllegalArgumentException(Messages.getString("jndi.50"));
        }
        if (name == null) {
            throw new NullPointerException(Messages.getString("jndi.2E"));
        }
        if (name.size() == 0) {
            nameToList = (DNSName)this.contextName.clone();
        } else if (name instanceof CompositeName) {
            String tmp = name.get(0);
            altName = (DNSName)this.nameParser.parse(tmp);
            nameToList = (DNSName)this.composeName(altName, this.contextName);
            if (name.size() > 1) {
                remainingName = (CompositeName)name.getSuffix(1);
            }
        } else if (name instanceof DNSName) {
            nameToList = (DNSName)this.composeName(name, this.contextName);
        } else {
            throw new InvalidNameException(Messages.getString("jndi.4B"));
        }
        if (remainingName != null) {
            CannotProceedException cpe = this.constructCannotProceedException(altName, remainingName);
            Context nnsContext = DirectoryManager.getContinuationContext(cpe);
            result = nnsContext.list(remainingName);
        } else {
            try {
                Enumeration<ResourceRecord> resEnum = this.resolver.list(nameToList.toString());
                Hashtable<String, Binding> entries = new Hashtable<String, Binding>();
                DNSContext targetCtx = new DNSContext(this, nameToList);
                while (resEnum.hasMoreElements()) {
                    String elNameStr;
                    ResourceRecord rr = resEnum.nextElement();
                    Name curName = this.nameParser.parse(rr.getName());
                    if (!curName.startsWith(nameToList) || curName.size() <= nameToList.size() || entries.containsKey(elNameStr = curName.get(nameToList.size()))) continue;
                    NameClassPair objToPut = null;
                    DNSName elNameAbs = null;
                    DNSName elNameRel = null;
                    elNameRel = new DNSName();
                    elNameRel.add(elNameStr);
                    elNameAbs = (DNSName)nameToList.clone();
                    elNameAbs.add(elNameStr);
                    DNSContext elCtx = new DNSContext(this, elNameAbs);
                    Object elObj = DirectoryManager.getObjectInstance(elCtx, elNameRel, targetCtx, this.environment, null);
                    switch (contentSwt) {
                        case 1: {
                            objToPut = new NameClassPair(elNameStr, elObj.getClass().getName(), true);
                            break;
                        }
                        case 2: {
                            objToPut = new Binding(elNameStr, elObj, true);
                        }
                    }
                    entries.put(elNameStr, (Binding)objToPut);
                }
                result = new BasicNamingEnumerator(entries.elements());
            }
            catch (SecurityException e) {
                throw e;
            }
            catch (NamingException e) {
                throw e;
            }
            catch (Exception e) {
                NamingException e2 = new NamingException(e.getMessage());
                e2.setRootCause(e);
                throw e2;
            }
        }
        return result;
    }

    @Override
    public NamingEnumeration<Binding> listBindings(Name name) throws NamingException {
        return this.list_common(name, 2);
    }

    @Override
    public Object addToEnvironment(String propName, Object propValue) throws NamingException {
        Object oldVal = this.environment.put(propName, propValue);
        if (propName.equals("java.naming.authoritative")) {
            this.parseBoolProp("java.naming.authoritative");
            this.resolver.setAuthoritativeAnswerDesired(this.authoritative);
        } else if (propName.equals(RECURSION)) {
            this.parseBoolProp(RECURSION);
            this.resolver.setRecursionDesired(this.recursion);
        } else if (propName.equals(TIMEOUT_INITIAL)) {
            this.parseIntProp(TIMEOUT_INITIAL);
            this.resolver.setInitialTimeout(this.timeoutInitial);
        } else if (propName.equals(TIMEOUT_RETRIES)) {
            this.parseIntProp(TIMEOUT_RETRIES);
            this.resolver.setTimeoutRetries(this.timeoutRetries);
        } else if (propName.equals(THREADS_MAX)) {
            this.parseIntProp(THREADS_MAX);
            this.resolver.setThreadNumberLimit(this.maxThreads);
        } else if (propName.equals(LOOKUP_ATTR)) {
            this.parseLookupProp();
        } else if (propName.equals("java.naming.provider.url")) {
            this.parseProviderUrlProp();
        }
        return oldVal;
    }

    @Override
    public String composeName(String name, String prefix) throws NamingException {
        Name name1 = null;
        Name name2 = null;
        if (name == null || prefix == null) {
            throw new NullPointerException(Messages.getString("jndi.51"));
        }
        if (name.length() == 0) {
            return prefix;
        }
        if (prefix.length() == 0) {
            return name;
        }
        try {
            name1 = new CompositeName(name);
            name2 = new CompositeName(prefix);
        }
        catch (InvalidNameException invalidNameException) {}
        if (name1 == null || name1.size() <= 1) {
            name1 = this.nameParser.parse(name);
        }
        if (name2 == null || name2.size() <= 1) {
            name2 = this.nameParser.parse(prefix);
        }
        return this.composeName(name1, name2).toString();
    }

    @Override
    public Name composeName(Name name, Name prefix) throws NamingException {
        Name result = null;
        if (name == null || prefix == null) {
            throw new NullPointerException(Messages.getString("jndi.51"));
        }
        if (name.size() == 0) {
            return prefix;
        }
        if (prefix.size() == 0) {
            return name;
        }
        if (name instanceof CompositeName && prefix instanceof CompositeName) {
            String comp1 = name.get(0);
            String comp2 = prefix.get(prefix.size() - 1);
            result = new CompositeName();
            if (prefix.size() > 1) {
                result.addAll(prefix.getPrefix(prefix.size() - 1));
            }
            try {
                result.add(this.concatenateDNSNames(comp1, comp2));
            }
            catch (InvalidNameException invalidNameException) {
                result.add(comp2);
                result.add(comp1);
            }
            if (name.size() > 1) {
                result.addAll(name.getSuffix(1));
            }
        } else if (prefix instanceof CompositeName && name instanceof DNSName) {
            String comp1 = name.toString();
            String comp2 = prefix.get(prefix.size() - 1);
            result = new CompositeName();
            if (prefix.size() > 1) {
                result.addAll(prefix.getPrefix(prefix.size() - 1));
            }
            try {
                result.add(this.concatenateDNSNames(comp1, comp2));
            }
            catch (InvalidNameException invalidNameException) {
                result.add(comp2);
                result.add(comp1);
            }
        } else if (prefix instanceof DNSName && name instanceof CompositeName) {
            String comp1 = name.get(0);
            String comp2 = prefix.toString();
            result = new CompositeName();
            try {
                result.add(this.concatenateDNSNames(comp1, comp2));
            }
            catch (InvalidNameException invalidNameException) {
                result.add(comp2);
                result.add(comp1);
            }
            if (name.size() > 1) {
                result.addAll(name.getSuffix(1));
            }
        } else if (prefix instanceof DNSName && name instanceof DNSName) {
            DNSName rootZone = ProviderConstants.ROOT_ZONE_NAME_OBJ;
            boolean prefixIsRoot = prefix.compareTo(rootZone) == 0;
            boolean nameIsRoot = name.compareTo(rootZone) == 0;
            boolean nameStartsFromRoot = name.get(0).equals("");
            if (nameStartsFromRoot) {
                throw new NamingException(Messages.getString("jndi.52"));
            }
            if (prefixIsRoot && nameIsRoot) {
                result = (DNSName)rootZone.clone();
            } else {
                if (!prefixIsRoot && nameIsRoot) {
                    throw new NamingException(Messages.getString("jndi.53"));
                }
                result = new DNSName();
                result.addAll(prefix);
                result.addAll(name);
            }
        } else {
            throw new NamingException(Messages.getString("jndi.4B"));
        }
        return result;
    }

    private String concatenateDNSNames(String comp1, String comp2) throws NamingException {
        boolean comp1IsRoot = comp1.equals(".");
        boolean comp2IsRoot = comp2.equals(".");
        String composition = null;
        this.nameParser.parse(comp1);
        this.nameParser.parse(comp2);
        if (comp1.endsWith(".")) {
            throw new NamingException(Messages.getString("jndi.52"));
        }
        if (comp1IsRoot && comp2IsRoot) {
            composition = ".";
        } else if (!comp1IsRoot && comp2IsRoot) {
            composition = String.valueOf(comp1) + ".";
        } else {
            if (comp1IsRoot && !comp2IsRoot) {
                throw new NamingException(Messages.getString("jndi.53"));
            }
            composition = String.valueOf(comp1) + "." + comp2;
        }
        return composition;
    }

    public Object clone() {
        return new DNSContext(this, this.contextName);
    }

    public boolean equals(Object obj) {
        return obj != null && obj instanceof DNSContext && this.contextName.equals(((DNSContext)obj).contextName);
    }

    private ContextNamePair getTargetNamespaceContextNamePair(Name cmpName) throws NamingException {
        if (cmpName == null || !(cmpName instanceof CompositeName) || cmpName.size() < 2) {
            throw new IllegalArgumentException();
        }
        String remainingName = cmpName.get(cmpName.size() - 1);
        CompositeName nameToLookFor = (CompositeName)cmpName.getPrefix(cmpName.size() - 1);
        nameToLookFor.add("");
        Object obj = this.lookup(nameToLookFor);
        return new ContextNamePair(obj, remainingName);
    }

    static class ContextNamePair {
        Object context;
        String name;

        ContextNamePair(Object context, String name) {
            this.context = context;
            this.name = name;
        }
    }
}

