/*
 * Decompiled with CFR 0.152.
 */
package javax.naming.ldap;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.naming.InvalidNameException;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.BasicAttribute;
import javax.naming.directory.BasicAttributes;
import org.apache.harmony.jndi.internal.nls.Messages;
import org.apache.harmony.jndi.internal.parser.LdapRdnParser;
import org.apache.harmony.jndi.internal.parser.LdapTypeAndValueList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Rdn
implements Serializable,
Comparable<Object> {
    private static final long serialVersionUID = -5994465067210009656L;
    private transient List<Attribute> list;
    private transient LdapRdnParser parser;

    public static String escapeValue(Object val) {
        if (val == null) {
            throw new NullPointerException("val " + Messages.getString("ldap.00"));
        }
        return LdapRdnParser.escapeValue(val);
    }

    public static Object unescapeValue(String val) {
        if (val == null) {
            throw new NullPointerException("val " + Messages.getString("ldap.00"));
        }
        return LdapRdnParser.unescapeValue(val);
    }

    public Rdn(Attributes attrSet) throws InvalidNameException {
        if (attrSet == null) {
            throw new NullPointerException("attrSet " + Messages.getString("ldap.00"));
        }
        if (attrSet.size() == 0) {
            throw new InvalidNameException("atrrSet " + Messages.getString("ldap.03"));
        }
        NamingEnumeration<? extends Attribute> ne = attrSet.getAll();
        while (ne.hasMoreElements()) {
            Attribute at = (Attribute)ne.nextElement();
            try {
                at.get();
            }
            catch (NamingException namingException) {}
        }
        this.list = this.convertToAttributeArrayList(attrSet);
    }

    public Rdn(Rdn rdn) {
        if (rdn == null) {
            throw new NullPointerException("rdn " + Messages.getString("ldap.00"));
        }
        this.list = this.convertToAttributeArrayList(rdn.toAttributes());
    }

    public Rdn(String rdnString) throws InvalidNameException {
        if (rdnString == null) {
            throw new NullPointerException("rdnString " + Messages.getString("ldap.00"));
        }
        if (rdnString.length() != 0) {
            this.parser = new LdapRdnParser(rdnString);
            this.list = this.parser.getList();
        } else {
            this.list = new ArrayList<Attribute>();
        }
    }

    public Rdn(String type, Object value) throws InvalidNameException {
        if (type == null) {
            throw new NullPointerException("type " + Messages.getString("ldap.00"));
        }
        if (value == null) {
            throw new NullPointerException("value " + Messages.getString("ldap.00"));
        }
        if (type.length() == 0) {
            throw new InvalidNameException("type " + Messages.getString("ldap.04"));
        }
        if (value instanceof String && ((String)value).length() == 0) {
            throw new InvalidNameException("value " + Messages.getString("ldap.04"));
        }
        this.list = this.convertToAttributeArrayList(new BasicAttributes(type, value, true));
    }

    @Override
    public int compareTo(Object obj) {
        if (!(obj instanceof Rdn)) {
            throw new ClassCastException(Messages.getString("ldap.06"));
        }
        Rdn rdn = (Rdn)obj;
        String s1 = "";
        String s2 = "";
        NamingEnumeration<? extends Attribute> iter = this.toAttributes().getAll();
        while (iter.hasMoreElements()) {
            s1 = String.valueOf(s1) + Rdn.escapeValue(iter.nextElement().toString());
        }
        iter = rdn.toAttributes().getAll();
        while (iter.hasMoreElements()) {
            s2 = String.valueOf(s2) + Rdn.escapeValue(iter.nextElement().toString());
        }
        return s1.toLowerCase().compareTo(s2.toLowerCase());
    }

    private List<Attribute> convertToAttributeArrayList(Attributes attrList) {
        LdapTypeAndValueList myList = new LdapTypeAndValueList();
        NamingEnumeration<? extends Attribute> ne = attrList.getAll();
        try {
            while (ne.hasMoreElements()) {
                Attribute attr = (Attribute)ne.nextElement();
                myList.put(attr.getID(), attr.get());
            }
        }
        catch (NamingException namingException) {}
        return myList.toAttributeList();
    }

    /*
     * Unable to fully structure code
     */
    public boolean equals(Object obj) {
        if (!(obj instanceof Rdn) || this.size() != ((Rdn)obj).size()) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        iter1 = this.toAttributes().getAll();
        iter2 = ((Rdn)obj).toAttributes().getAll();
        while (iter1.hasMoreElements()) {
            a1 = (Attribute)iter1.nextElement();
            a2 = (Attribute)iter2.nextElement();
            if (!a1.getID().toLowerCase().equals(a2.getID().toLowerCase()) || a1.size() != a2.size()) {
                return false;
            }
            en1 = null;
            en2 = null;
            try {
                en1 = a1.getAll();
                en2 = a2.getAll();
                if (true) ** GOTO lbl26
            }
            catch (NamingException v0) {
                return false;
            }
            do {
                s1 = (o1 = en1.nextElement()) instanceof String != false ? (String)o1 : Rdn.escapeValue(o1);
                o2 = en2.nextElement();
                v1 = s2 = o2 instanceof String != false ? (String)o2 : Rdn.escapeValue(o2);
                if (s1.toLowerCase().equals(s2.toLowerCase())) continue;
                return false;
lbl26:
                // 2 sources

            } while (en1.hasMoreElements());
        }
        return true;
    }

    public String getType() {
        return this.list.get(0).getID();
    }

    public Object getValue() {
        Object a = null;
        try {
            a = this.list.get(0).get();
        }
        catch (NamingException namingException) {
        }
        catch (NullPointerException nullPointerException) {}
        return a;
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    public int hashCode() {
        sum = 0;
        for (Attribute a : this.list) {
            en = null;
            sum += a.getID().toLowerCase().hashCode();
            try {
                en = a.getAll();
                if (true) ** GOTO lbl19
            }
            catch (NamingException v0) {
                continue;
            }
            do {
                if ((obj /* !! */  = en.nextElement()) instanceof byte[]) {
                    obj /* !! */  = new String((byte[])obj /* !! */ );
                }
                try {
                    s = (String)obj /* !! */ ;
                    sum += Rdn.escapeValue(s.toLowerCase()).hashCode();
                }
                catch (ClassCastException v1) {
                    sum += obj /* !! */ .hashCode();
                }
lbl19:
                // 3 sources

            } while (en.hasMoreElements());
        }
        return sum;
    }

    public int size() {
        int result = 0;
        Iterator<Attribute> iter = this.list.iterator();
        while (iter.hasNext()) {
            result += iter.next().size();
        }
        return result;
    }

    public Attributes toAttributes() {
        BasicAttributes bas = new BasicAttributes(true);
        for (Attribute attr : this.list) {
            BasicAttribute ba = new BasicAttribute(attr.getID(), false);
            try {
                NamingEnumeration<?> nameEnum = attr.getAll();
                while (nameEnum.hasMore()) {
                    ba.add(nameEnum.next());
                }
            }
            catch (NamingException namingException) {}
            bas.put(ba);
        }
        return bas;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        Iterator<Attribute> iter = this.list.iterator();
        while (iter.hasNext()) {
            Attribute element = iter.next();
            NamingEnumeration<?> ne = null;
            try {
                ne = element.getAll();
            }
            catch (NamingException namingException) {}
            while (ne.hasMoreElements()) {
                sb.append(element.getID());
                sb.append('=');
                sb.append(Rdn.escapeValue(ne.nextElement()));
                if (!ne.hasMoreElements()) continue;
                sb.append('+');
            }
            if (!iter.hasNext()) continue;
            sb.append('+');
        }
        return sb.toString();
    }

    private void readObject(ObjectInputStream ois) throws IOException, ClassNotFoundException, InvalidNameException {
        ois.defaultReadObject();
        String rdnString = (String)ois.readObject();
        if (rdnString == null) {
            throw new NullPointerException("rdnString " + Messages.getString("ldap.00"));
        }
        if (rdnString.length() != 0) {
            this.parser = new LdapRdnParser(rdnString);
            this.list = this.parser.getList();
        } else {
            this.list = new ArrayList<Attribute>();
        }
    }

    private void writeObject(ObjectOutputStream oos) throws IOException {
        oos.defaultWriteObject();
        oos.writeObject(this.toString());
    }
}

