/*
 * Decompiled with CFR 0.152.
 */
package spec.reporter;

import java.awt.Color;
import java.awt.Dimension;
import java.io.FileWriter;
import java.io.IOException;
import java.text.DecimalFormat;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import java.util.logging.Level;
import spec.jbb.JBButil;

public class HTMLTableGraphGenerator3 {
    static final String COPYRIGHT = "SPECjbb2005,Copyright (c) 2000-2005 Standard Performance Evaluation Corporation (SPEC),All rights reserved,Copyright (c) 2000-2005 Hewlett-Packard,All rights reserved,Licensed Materials - Property of SPEC";
    public static final int X = 0;
    public static final int Y = 1;
    public static final int DIM = 2;
    public static final int MINX = 0;
    public static final int MAXX = 1;
    public static final int MINY = 2;
    public static final int MAXY = 3;
    public static final String DEFAULT_XAXIS = "x";
    public static final String DEFAULT_YAXIS = "y";
    public static final int DEFAULT_PADSIZE = 2;
    public static final int DEFAULT_PIXELSIZE = 2;
    public static final Color DEFAULT_FGCOLOR = Color.red;
    public static final Color DEFAULT_BGCOLOR = Color.black;
    public static final Dimension DEFAULT_SIZE = new Dimension(50, 50);
    public static final double[] DEFAULT_SCALE = new double[]{-5.0, 5.0, -5.0, 5.0};
    public static final String DEFAULT_HTMLFILE = "HTMLTableGraph.html";
    private int pad;
    private String pixel;
    private int pixelsize;
    private Dimension size;
    private String xaxis;
    private String yaxis;
    private String fgcolor;
    private String bgcolor;
    private boolean bgcolorEnabled;
    private String pixelcolor;
    private boolean pixelcolorEnabled;
    private double alphax;
    private double alphay;
    private final Hashtable xypairs = new Hashtable();
    private final double[] scale = new double[DEFAULT_SCALE.length];
    private final DecimalFormat dfx = new DecimalFormat("#.##");
    private final DecimalFormat dfy = new DecimalFormat("#.##");

    public HTMLTableGraphGenerator3() {
        this.setTableSize(DEFAULT_SIZE);
        this.setPixelSize(2);
        this.setPixelPadSize(2);
        this.setForegroundColor(DEFAULT_FGCOLOR);
        this.setBackgroundColor(DEFAULT_BGCOLOR);
        this.setAxesLabels(DEFAULT_XAXIS, DEFAULT_YAXIS);
        this.setAxesLabelsPrecision(0, 0);
    }

    private String toHexString(Color color) {
        return "#" + this.toHexString(color.getRed()) + this.toHexString(color.getGreen()) + this.toHexString(color.getBlue());
    }

    private String toHexString(int n) {
        String string = Integer.toHexString(n);
        return string.length() == 1 ? "0" + string : string;
    }

    public void setBackgroundColorEnabled(boolean bl) {
        this.bgcolorEnabled = bl;
    }

    public boolean isBackgroundColorEnabled() {
        return this.bgcolorEnabled;
    }

    public void setPixelBorderColorEnabled(boolean bl) {
        this.pixelcolorEnabled = bl;
    }

    public boolean isPixelBorderColorEnabled() {
        return this.pixelcolorEnabled;
    }

    public void setPixelBorderColor(Color color) {
        if (color == null) {
            return;
        }
        this.pixelcolor = this.toHexString(color);
        this.setPixelBorderColorEnabled(true);
    }

    public void setBackgroundColor(Color color) {
        if (color == null) {
            return;
        }
        this.bgcolor = this.toHexString(color);
        this.setBackgroundColorEnabled(true);
    }

    public void setForegroundColor(Color color) {
        if (color == null) {
            return;
        }
        this.fgcolor = this.toHexString(color);
    }

    public void setTableSize(Dimension dimension) {
        if (dimension == null) {
            return;
        }
        this.size = dimension;
        this.setScale(this.scale);
    }

    public void setPixelSize(int n) {
        this.pixelsize = n;
        this.setPixelImage(this.pixel);
    }

    public void setPixelPadSize(int n) {
        this.pad = n;
    }

    public void setPixelImage(String string) {
        this.pixel = string = "<IMG SRC=" + string + " WIDTH=" + this.pixelsize + " HEIGHT=" + this.pixelsize + ">";
    }

    public void setScale(double[] dArray) {
        if (dArray == null || dArray.length < this.scale.length) {
            return;
        }
        System.arraycopy(dArray, 0, this.scale, 0, this.scale.length);
        this.alphax = (this.scale[1] - this.scale[0]) / (double)this.size.width;
        this.alphay = (this.scale[3] - this.scale[2]) / (double)this.size.height;
    }

    private int getLinearMapX(double d) {
        return (int)Math.round((d - this.scale[0]) / this.alphax);
    }

    private int getLinearMapY(double d) {
        return (int)Math.round((this.scale[3] - d) / this.alphay);
    }

    private double getInverseLinearMapX(int n) {
        return this.scale[0] + (double)n * this.alphax;
    }

    private double getInverseLinearMapY(int n) {
        return this.scale[3] - (double)n * this.alphay;
    }

    public void setAxesLabels(String string, String string2) {
        this.xaxis = string;
        if (string2.length() > 1) {
            char[] cArray = string2.toCharArray();
            string2 = "";
            for (int i = 0; i < cArray.length; ++i) {
                string2 = string2 + "&nbsp;" + cArray[i] + "&nbsp;<BR>";
            }
        }
        this.yaxis = string2;
    }

    public void setAxesLabelsPrecision(int n, int n2) {
        this.dfx.setMinimumIntegerDigits(1);
        this.dfx.setMinimumFractionDigits(n);
        this.dfx.setMaximumFractionDigits(n);
        this.dfy.setMinimumIntegerDigits(1);
        this.dfy.setMinimumFractionDigits(n2);
        this.dfy.setMaximumFractionDigits(n2);
    }

    public void clearXYPairs() {
        this.xypairs.clear();
    }

    public void addXYPair(double[] dArray) {
        if (dArray == null || dArray.length != 2) {
            return;
        }
        String string = Integer.toString(this.getLinearMapX(dArray[0]));
        String string2 = Integer.toString(this.getLinearMapY(dArray[1]));
        if (!this.xypairs.containsKey(string)) {
            this.xypairs.put(string, new Vector());
        }
        ((Vector)this.xypairs.get(string)).addElement(string2);
    }

    public void setXYPairs(double[][] dArray) {
        if (dArray == null) {
            return;
        }
        for (int i = 0; i < dArray.length; ++i) {
            this.addXYPair(dArray[i]);
        }
    }

    public void setXYPairs(Vector vector) {
        if (vector == null) {
            return;
        }
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            this.addXYPair((double[])enumeration.nextElement());
        }
    }

    public void generate() {
        this.generate(DEFAULT_HTMLFILE);
    }

    public void generate(String string) {
        if (string == null) {
            return;
        }
        try {
            FileWriter fileWriter = new FileWriter(string);
            fileWriter.write(this.generateString());
            fileWriter.flush();
            fileWriter.close();
        }
        catch (IOException iOException) {
            JBButil.getLog().log(Level.WARNING, "IOException: " + iOException.getMessage(), iOException);
        }
        catch (Exception exception) {
            JBButil.getLog().log(Level.WARNING, "Exception: " + exception.getMessage(), exception);
            exception.printStackTrace();
        }
    }

    public String generateString() {
        String string;
        String string2;
        int n;
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("<TABLE BORDER=1 CELLSPACING=0 CELLPADDING=0><TR><TD>");
        stringBuffer.append("<TABLE BORDER=0 CELLSPACING=" + this.pad + " CELLPADDING=" + this.pad + (this.bgcolorEnabled ? " BGCOLOR=" + this.bgcolor : "") + " WIDTH=" + this.size.width * this.pixelsize + ">\n");
        for (n = 0; n < this.size.height; ++n) {
            stringBuffer.append("<TR>");
            if (n == 0) {
                stringBuffer.append("<TD ALIGN=center VALIGN=middle ROWSPAN=" + this.size.height + " BGCOLOR=#ffffff>" + this.yaxis + "</TD>");
            }
            if (n % 10 == 0) {
                double d = this.getInverseLinearMapY(n);
                string2 = this.dfy.format(d).replace('-', ' ').trim();
                string = d < 0.0 ? "COLOR=#ff0000" : "COLOR=#000000";
                stringBuffer.append("<TD BGCOLOR=white NOWRAP ROWSPAN=10 ALIGN=right VALIGN=top><FONT SIZE=1 " + string + ">" + string2 + "</FONT></TD>\n");
            }
            for (int i = 0; i < this.size.width; ++i) {
                String string3 = "";
                string2 = Integer.toString(i);
                string = Integer.toString(n);
                if (this.xypairs.containsKey(string2)) {
                    Vector vector = (Vector)this.xypairs.get(string2);
                    Enumeration enumeration = vector.elements();
                    while (enumeration.hasMoreElements()) {
                        String string4 = enumeration.nextElement().toString();
                        if (!string4.equals(string)) continue;
                        string3 = this.pixel;
                        break;
                    }
                }
                stringBuffer.append("<TD WIDTH=" + this.pixelsize + (this.pixelcolorEnabled && !string3.equals("") ? " BGCOLOR=" + this.pixelcolor : "") + ">" + string3 + "</TD>");
            }
            stringBuffer.append("</TR>\n");
        }
        stringBuffer.append("<TR><TD BGCOLOR=#ffffff COLSPAN=2 ROWSPAN=2>&nbsp;</TD>\n");
        for (n = 0; n < this.size.width; ++n) {
            if (n % 10 != 0) continue;
            double d = this.getInverseLinearMapX(n);
            string2 = this.dfx.format(d).replace('-', ' ').trim();
            string = d < 0.0 ? "COLOR=#ff0000" : "COLOR=#000000";
            stringBuffer.append("<TD ALIGN=left BGCOLOR=white NOWRAP COLSPAN=10 VALIGN=top><FONT SIZE=1 " + string + ">" + string2 + "</FONT></TD>\n");
        }
        stringBuffer.append("</TR><TR><TD COLSPAN=" + this.size.width + " ALIGN=center BGCOLOR=#ffffff>" + this.xaxis + "</TD></TR>");
        stringBuffer.append("</TABLE></TD></TR></TABLE>");
        return stringBuffer.toString();
    }
}

