# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------
import pytest
from azure.mgmt.applicationinsights import ApplicationInsightsManagementClient

from devtools_testutils import AzureMgmtRecordedTestCase, RandomNameResourceGroupPreparer, recorded_by_proxy

AZURE_LOCATION = "eastus"


@pytest.mark.skip("you may need to update the auto-generated test case before run it")
class TestApplicationInsightsManagementProactiveDetectionConfigurationsOperations(AzureMgmtRecordedTestCase):
    def setup_method(self, method):
        self.client = self.create_mgmt_client(ApplicationInsightsManagementClient)

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_proactive_detection_configurations_list(self, resource_group):
        response = self.client.proactive_detection_configurations.list(
            resource_group_name=resource_group.name,
            resource_name="str",
            api_version="2015-05-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_proactive_detection_configurations_get(self, resource_group):
        response = self.client.proactive_detection_configurations.get(
            resource_group_name=resource_group.name,
            resource_name="str",
            configuration_id="str",
            api_version="2015-05-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_proactive_detection_configurations_update(self, resource_group):
        response = self.client.proactive_detection_configurations.update(
            resource_group_name=resource_group.name,
            resource_name="str",
            configuration_id="str",
            proactive_detection_properties={
                "customEmails": ["str"],
                "enabled": bool,
                "lastUpdatedTime": "str",
                "name": "str",
                "ruleDefinitions": {
                    "Description": "str",
                    "DisplayName": "str",
                    "HelpUrl": "str",
                    "IsEnabledByDefault": bool,
                    "IsHidden": bool,
                    "IsInPreview": bool,
                    "Name": "str",
                    "SupportsEmailNotifications": bool,
                },
                "sendEmailsToSubscriptionOwners": bool,
            },
            api_version="2015-05-01",
        )

        # please add some check logic here by yourself
        # ...
