# pylint: disable=too-many-lines
# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) Python Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------
from collections.abc import MutableMapping
from io import IOBase
import json
from typing import Any, Callable, IO, Optional, TypeVar, Union, overload

from azure.core import AsyncPipelineClient
from azure.core.exceptions import (
    ClientAuthenticationError,
    HttpResponseError,
    ResourceExistsError,
    ResourceNotFoundError,
    ResourceNotModifiedError,
    StreamClosedError,
    StreamConsumedError,
    map_error,
)
from azure.core.pipeline import PipelineResponse
from azure.core.rest import AsyncHttpResponse, HttpRequest
from azure.core.tracing.decorator_async import distributed_trace_async
from azure.core.utils import case_insensitive_dict

from ... import models as _models
from ..._utils.model_base import SdkJSONEncoder, _deserialize
from ..._utils.serialization import Deserializer, Serializer
from ...operations._operations import (
    build_attestation_attest_azure_guest_request,
    build_attestation_attest_open_enclave_request,
    build_attestation_attest_sev_snp_vm_request,
    build_attestation_attest_sgx_enclave_request,
    build_attestation_attest_tdx_vm_request,
    build_attestation_attest_tpm_request,
    build_metadata_configuration_get_request,
    build_policy_certificates_add_request,
    build_policy_certificates_get_request,
    build_policy_certificates_remove_request,
    build_policy_get_request,
    build_policy_reset_request,
    build_policy_set_request,
    build_signing_certificates_get_request,
    build_tcb_baselines_get_request,
)
from .._configuration import AttestationClientConfiguration

T = TypeVar("T")
ClsType = Optional[Callable[[PipelineResponse[HttpRequest, AsyncHttpResponse], T, dict[str, Any]], Any]]
JSON = MutableMapping[str, Any]
_Unset: Any = object()


class PolicyOperations:
    """
    .. warning::
        **DO NOT** instantiate this class directly.

        Instead, you should access the following operations through
        :class:`~azure.security.attestation.aio.AttestationClient`'s
        :attr:`policy` attribute.
    """

    def __init__(self, *args, **kwargs) -> None:
        input_args = list(args)
        self._client: AsyncPipelineClient = input_args.pop(0) if input_args else kwargs.pop("client")
        self._config: AttestationClientConfiguration = input_args.pop(0) if input_args else kwargs.pop("config")
        self._serialize: Serializer = input_args.pop(0) if input_args else kwargs.pop("serializer")
        self._deserialize: Deserializer = input_args.pop(0) if input_args else kwargs.pop("deserializer")

    @distributed_trace_async
    async def get(self, attestation_type: Union[str, _models.AttestationType], **kwargs: Any) -> _models.PolicyResponse:
        """Retrieves the current policy for an attestation type.

        Retrieves the current policy for an attestation type.

        :param attestation_type: Specifies the trusted execution environment to be used to validate the
         evidence. Known values are: "SgxEnclave", "OpenEnclave", "AzureGuest", "SevSnpVm", "Tpm", and
         "TdxVm". Required.
        :type attestation_type: str or ~azure.security.attestation.models.AttestationType
        :return: PolicyResponse. The PolicyResponse is compatible with MutableMapping
        :rtype: ~azure.security.attestation.models.PolicyResponse
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[_models.PolicyResponse] = kwargs.pop("cls", None)

        _request = build_policy_get_request(
            attestation_type=attestation_type,
            api_version=self._config.api_version,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = kwargs.pop("stream", False)
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            if _stream:
                try:
                    await response.read()  # Load the body in memory and close the socket
                except (StreamConsumedError, StreamClosedError):
                    pass
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        if _stream:
            deserialized = response.iter_bytes()
        else:
            deserialized = _deserialize(_models.PolicyResponse, response.json())

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    @distributed_trace_async
    async def set(
        self, attestation_type: Union[str, _models.AttestationType], new_attestation_policy: str, **kwargs: Any
    ) -> _models.PolicyResponse:
        """Sets the policy for a given attestation type.

        Sets the policy for a given attestation type.

        :param attestation_type: Specifies the trusted execution environment to be used to validate the
         evidence. Known values are: "SgxEnclave", "OpenEnclave", "AzureGuest", "SevSnpVm", "Tpm", and
         "TdxVm". Required.
        :type attestation_type: str or ~azure.security.attestation.models.AttestationType
        :param new_attestation_policy: JWT Expressing the new policy whose body is a
         StoredAttestationPolicy object. Required.
        :type new_attestation_policy: str
        :return: PolicyResponse. The PolicyResponse is compatible with MutableMapping
        :rtype: ~azure.security.attestation.models.PolicyResponse
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type: str = kwargs.pop("content_type", _headers.pop("Content-Type", "text/plain"))
        cls: ClsType[_models.PolicyResponse] = kwargs.pop("cls", None)

        _content = new_attestation_policy

        _request = build_policy_set_request(
            attestation_type=attestation_type,
            content_type=content_type,
            api_version=self._config.api_version,
            content=_content,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = kwargs.pop("stream", False)
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            if _stream:
                try:
                    await response.read()  # Load the body in memory and close the socket
                except (StreamConsumedError, StreamClosedError):
                    pass
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        if _stream:
            deserialized = response.iter_bytes()
        else:
            deserialized = _deserialize(_models.PolicyResponse, response.json())

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    @distributed_trace_async
    async def reset(
        self, attestation_type: Union[str, _models.AttestationType], policy_jws: str, **kwargs: Any
    ) -> _models.PolicyResponse:
        """Resets the attestation policy for the specified tenant and reverts to the
        default policy.

        Resets the attestation policy for the specified tenant and reverts to the
        default policy.

        :param attestation_type: Specifies the trusted execution environment to be used to validate the
         evidence. Known values are: "SgxEnclave", "OpenEnclave", "AzureGuest", "SevSnpVm", "Tpm", and
         "TdxVm". Required.
        :type attestation_type: str or ~azure.security.attestation.models.AttestationType
        :param policy_jws: JSON Web Signature with an empty policy document. Required.
        :type policy_jws: str
        :return: PolicyResponse. The PolicyResponse is compatible with MutableMapping
        :rtype: ~azure.security.attestation.models.PolicyResponse
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type: str = kwargs.pop("content_type", _headers.pop("Content-Type", "text/plain"))
        cls: ClsType[_models.PolicyResponse] = kwargs.pop("cls", None)

        _content = policy_jws

        _request = build_policy_reset_request(
            attestation_type=attestation_type,
            content_type=content_type,
            api_version=self._config.api_version,
            content=_content,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = kwargs.pop("stream", False)
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            if _stream:
                try:
                    await response.read()  # Load the body in memory and close the socket
                except (StreamConsumedError, StreamClosedError):
                    pass
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        if _stream:
            deserialized = response.iter_bytes()
        else:
            deserialized = _deserialize(_models.PolicyResponse, response.json())

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore


class PolicyCertificatesOperations:
    """
    .. warning::
        **DO NOT** instantiate this class directly.

        Instead, you should access the following operations through
        :class:`~azure.security.attestation.aio.AttestationClient`'s
        :attr:`policy_certificates` attribute.
    """

    def __init__(self, *args, **kwargs) -> None:
        input_args = list(args)
        self._client: AsyncPipelineClient = input_args.pop(0) if input_args else kwargs.pop("client")
        self._config: AttestationClientConfiguration = input_args.pop(0) if input_args else kwargs.pop("config")
        self._serialize: Serializer = input_args.pop(0) if input_args else kwargs.pop("serializer")
        self._deserialize: Deserializer = input_args.pop(0) if input_args else kwargs.pop("deserializer")

    @distributed_trace_async
    async def get(self, **kwargs: Any) -> _models.PolicyCertificatesResponse:
        """Retrieves the set of certificates used to express policy for the current tenant.

        Retrieves the set of certificates used to express policy for the current tenant.

        :return: PolicyCertificatesResponse. The PolicyCertificatesResponse is compatible with
         MutableMapping
        :rtype: ~azure.security.attestation.models.PolicyCertificatesResponse
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[_models.PolicyCertificatesResponse] = kwargs.pop("cls", None)

        _request = build_policy_certificates_get_request(
            api_version=self._config.api_version,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = kwargs.pop("stream", False)
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            if _stream:
                try:
                    await response.read()  # Load the body in memory and close the socket
                except (StreamConsumedError, StreamClosedError):
                    pass
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        if _stream:
            deserialized = response.iter_bytes()
        else:
            deserialized = _deserialize(_models.PolicyCertificatesResponse, response.json())

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    @overload
    async def add(
        self, *, policy_certificate_to_add: str, content_type: str = "application/json", **kwargs: Any
    ) -> _models.PolicyCertificatesModifyResponse:
        """Adds a new attestation policy certificate to the set of policy management
        certificates.

        Adds a new attestation policy certificate to the set of policy management
        certificates.

        :keyword policy_certificate_to_add: The certificate to add, as a string (e.g., PEM or JWK).
         Required.
        :paramtype policy_certificate_to_add: str
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: PolicyCertificatesModifyResponse. The PolicyCertificatesModifyResponse is compatible
         with MutableMapping
        :rtype: ~azure.security.attestation.models.PolicyCertificatesModifyResponse
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    async def add(
        self, body: JSON, *, content_type: str = "application/json", **kwargs: Any
    ) -> _models.PolicyCertificatesModifyResponse:
        """Adds a new attestation policy certificate to the set of policy management
        certificates.

        Adds a new attestation policy certificate to the set of policy management
        certificates.

        :param body: Required.
        :type body: JSON
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: PolicyCertificatesModifyResponse. The PolicyCertificatesModifyResponse is compatible
         with MutableMapping
        :rtype: ~azure.security.attestation.models.PolicyCertificatesModifyResponse
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    async def add(
        self, body: IO[bytes], *, content_type: str = "application/json", **kwargs: Any
    ) -> _models.PolicyCertificatesModifyResponse:
        """Adds a new attestation policy certificate to the set of policy management
        certificates.

        Adds a new attestation policy certificate to the set of policy management
        certificates.

        :param body: Required.
        :type body: IO[bytes]
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: PolicyCertificatesModifyResponse. The PolicyCertificatesModifyResponse is compatible
         with MutableMapping
        :rtype: ~azure.security.attestation.models.PolicyCertificatesModifyResponse
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @distributed_trace_async
    async def add(
        self, body: Union[JSON, IO[bytes]] = _Unset, *, policy_certificate_to_add: str = _Unset, **kwargs: Any
    ) -> _models.PolicyCertificatesModifyResponse:
        """Adds a new attestation policy certificate to the set of policy management
        certificates.

        Adds a new attestation policy certificate to the set of policy management
        certificates.

        :param body: Is either a JSON type or a IO[bytes] type. Required.
        :type body: JSON or IO[bytes]
        :keyword policy_certificate_to_add: The certificate to add, as a string (e.g., PEM or JWK).
         Required.
        :paramtype policy_certificate_to_add: str
        :return: PolicyCertificatesModifyResponse. The PolicyCertificatesModifyResponse is compatible
         with MutableMapping
        :rtype: ~azure.security.attestation.models.PolicyCertificatesModifyResponse
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[_models.PolicyCertificatesModifyResponse] = kwargs.pop("cls", None)

        if body is _Unset:
            if policy_certificate_to_add is _Unset:
                raise TypeError("missing required argument: policy_certificate_to_add")
            body = {"policyCertificateToAdd": policy_certificate_to_add}
            body = {k: v for k, v in body.items() if v is not None}
        content_type = content_type or "application/json"
        _content = None
        if isinstance(body, (IOBase, bytes)):
            _content = body
        else:
            _content = json.dumps(body, cls=SdkJSONEncoder, exclude_readonly=True)  # type: ignore

        _request = build_policy_certificates_add_request(
            content_type=content_type,
            api_version=self._config.api_version,
            content=_content,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = kwargs.pop("stream", False)
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            if _stream:
                try:
                    await response.read()  # Load the body in memory and close the socket
                except (StreamConsumedError, StreamClosedError):
                    pass
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        if _stream:
            deserialized = response.iter_bytes()
        else:
            deserialized = _deserialize(_models.PolicyCertificatesModifyResponse, response.json())

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    @overload
    async def remove(
        self, *, policy_certificate_to_remove: str, content_type: str = "application/json", **kwargs: Any
    ) -> _models.PolicyCertificatesModifyResponse:
        """Removes the specified policy management certificate. Note that the final policy
        management certificate cannot be removed.

        Removes the specified policy management certificate. Note that the final policy
        management certificate cannot be removed.

        :keyword policy_certificate_to_remove: The certificate to remove, as a string (e.g., PEM or
         JWK). Required.
        :paramtype policy_certificate_to_remove: str
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: PolicyCertificatesModifyResponse. The PolicyCertificatesModifyResponse is compatible
         with MutableMapping
        :rtype: ~azure.security.attestation.models.PolicyCertificatesModifyResponse
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    async def remove(
        self, body: JSON, *, content_type: str = "application/json", **kwargs: Any
    ) -> _models.PolicyCertificatesModifyResponse:
        """Removes the specified policy management certificate. Note that the final policy
        management certificate cannot be removed.

        Removes the specified policy management certificate. Note that the final policy
        management certificate cannot be removed.

        :param body: Required.
        :type body: JSON
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: PolicyCertificatesModifyResponse. The PolicyCertificatesModifyResponse is compatible
         with MutableMapping
        :rtype: ~azure.security.attestation.models.PolicyCertificatesModifyResponse
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    async def remove(
        self, body: IO[bytes], *, content_type: str = "application/json", **kwargs: Any
    ) -> _models.PolicyCertificatesModifyResponse:
        """Removes the specified policy management certificate. Note that the final policy
        management certificate cannot be removed.

        Removes the specified policy management certificate. Note that the final policy
        management certificate cannot be removed.

        :param body: Required.
        :type body: IO[bytes]
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: PolicyCertificatesModifyResponse. The PolicyCertificatesModifyResponse is compatible
         with MutableMapping
        :rtype: ~azure.security.attestation.models.PolicyCertificatesModifyResponse
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @distributed_trace_async
    async def remove(
        self, body: Union[JSON, IO[bytes]] = _Unset, *, policy_certificate_to_remove: str = _Unset, **kwargs: Any
    ) -> _models.PolicyCertificatesModifyResponse:
        """Removes the specified policy management certificate. Note that the final policy
        management certificate cannot be removed.

        Removes the specified policy management certificate. Note that the final policy
        management certificate cannot be removed.

        :param body: Is either a JSON type or a IO[bytes] type. Required.
        :type body: JSON or IO[bytes]
        :keyword policy_certificate_to_remove: The certificate to remove, as a string (e.g., PEM or
         JWK). Required.
        :paramtype policy_certificate_to_remove: str
        :return: PolicyCertificatesModifyResponse. The PolicyCertificatesModifyResponse is compatible
         with MutableMapping
        :rtype: ~azure.security.attestation.models.PolicyCertificatesModifyResponse
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[_models.PolicyCertificatesModifyResponse] = kwargs.pop("cls", None)

        if body is _Unset:
            if policy_certificate_to_remove is _Unset:
                raise TypeError("missing required argument: policy_certificate_to_remove")
            body = {"policyCertificateToRemove": policy_certificate_to_remove}
            body = {k: v for k, v in body.items() if v is not None}
        content_type = content_type or "application/json"
        _content = None
        if isinstance(body, (IOBase, bytes)):
            _content = body
        else:
            _content = json.dumps(body, cls=SdkJSONEncoder, exclude_readonly=True)  # type: ignore

        _request = build_policy_certificates_remove_request(
            content_type=content_type,
            api_version=self._config.api_version,
            content=_content,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = kwargs.pop("stream", False)
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            if _stream:
                try:
                    await response.read()  # Load the body in memory and close the socket
                except (StreamConsumedError, StreamClosedError):
                    pass
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        if _stream:
            deserialized = response.iter_bytes()
        else:
            deserialized = _deserialize(_models.PolicyCertificatesModifyResponse, response.json())

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore


class AttestationOperations:
    """
    .. warning::
        **DO NOT** instantiate this class directly.

        Instead, you should access the following operations through
        :class:`~azure.security.attestation.aio.AttestationClient`'s
        :attr:`attestation` attribute.
    """

    def __init__(self, *args, **kwargs) -> None:
        input_args = list(args)
        self._client: AsyncPipelineClient = input_args.pop(0) if input_args else kwargs.pop("client")
        self._config: AttestationClientConfiguration = input_args.pop(0) if input_args else kwargs.pop("config")
        self._serialize: Serializer = input_args.pop(0) if input_args else kwargs.pop("serializer")
        self._deserialize: Deserializer = input_args.pop(0) if input_args else kwargs.pop("deserializer")

    @overload
    async def attest_open_enclave(
        self,
        *,
        content_type: str = "application/json",
        report: Optional[bytes] = None,
        runtime_data: Optional[_models.RuntimeData] = None,
        init_time_data: Optional[_models.InitTimeData] = None,
        draft_policy_for_attestation: Optional[str] = None,
        nonce: Optional[str] = None,
        **kwargs: Any
    ) -> _models.AttestationResponse:
        """Attest to an SGX enclave.

        Processes an OpenEnclave report , producing an artifact. The type of artifact
        produced is dependent upon attestation policy.

        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :keyword report: OpenEnclave report from the enclave to be attested. Default value is None.
        :paramtype report: bytes
        :keyword runtime_data: Runtime data provided by the enclave at the time of report generation.
         The MAA
         will verify that the first 32 bytes of the report_data field of the quote
         contains the SHA256 hash of the decoded "data" field of the runtime data. Default value is
         None.
        :paramtype runtime_data: ~azure.security.attestation.models.RuntimeData
        :keyword init_time_data: Base64Url encoded "InitTime data". The MAA will verify that the init
         data was
         known to the enclave. Note that InitTimeData is invalid for CoffeeLake
         processors. Default value is None.
        :paramtype init_time_data: ~azure.security.attestation.models.InitTimeData
        :keyword draft_policy_for_attestation: Attest against the provided draft policy. Note that the
         resulting token cannot
         be validated. Default value is None.
        :paramtype draft_policy_for_attestation: str
        :keyword nonce: Nonce for incoming request - emitted in the generated attestation token.
         Default value is None.
        :paramtype nonce: str
        :return: AttestationResponse. The AttestationResponse is compatible with MutableMapping
        :rtype: ~azure.security.attestation.models.AttestationResponse
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    async def attest_open_enclave(
        self, body: JSON, *, content_type: str = "application/json", **kwargs: Any
    ) -> _models.AttestationResponse:
        """Attest to an SGX enclave.

        Processes an OpenEnclave report , producing an artifact. The type of artifact
        produced is dependent upon attestation policy.

        :param body: Required.
        :type body: JSON
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: AttestationResponse. The AttestationResponse is compatible with MutableMapping
        :rtype: ~azure.security.attestation.models.AttestationResponse
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    async def attest_open_enclave(
        self, body: IO[bytes], *, content_type: str = "application/json", **kwargs: Any
    ) -> _models.AttestationResponse:
        """Attest to an SGX enclave.

        Processes an OpenEnclave report , producing an artifact. The type of artifact
        produced is dependent upon attestation policy.

        :param body: Required.
        :type body: IO[bytes]
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: AttestationResponse. The AttestationResponse is compatible with MutableMapping
        :rtype: ~azure.security.attestation.models.AttestationResponse
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @distributed_trace_async
    async def attest_open_enclave(
        self,
        body: Union[JSON, IO[bytes]] = _Unset,
        *,
        report: Optional[bytes] = None,
        runtime_data: Optional[_models.RuntimeData] = None,
        init_time_data: Optional[_models.InitTimeData] = None,
        draft_policy_for_attestation: Optional[str] = None,
        nonce: Optional[str] = None,
        **kwargs: Any
    ) -> _models.AttestationResponse:
        """Attest to an SGX enclave.

        Processes an OpenEnclave report , producing an artifact. The type of artifact
        produced is dependent upon attestation policy.

        :param body: Is either a JSON type or a IO[bytes] type. Required.
        :type body: JSON or IO[bytes]
        :keyword report: OpenEnclave report from the enclave to be attested. Default value is None.
        :paramtype report: bytes
        :keyword runtime_data: Runtime data provided by the enclave at the time of report generation.
         The MAA
         will verify that the first 32 bytes of the report_data field of the quote
         contains the SHA256 hash of the decoded "data" field of the runtime data. Default value is
         None.
        :paramtype runtime_data: ~azure.security.attestation.models.RuntimeData
        :keyword init_time_data: Base64Url encoded "InitTime data". The MAA will verify that the init
         data was
         known to the enclave. Note that InitTimeData is invalid for CoffeeLake
         processors. Default value is None.
        :paramtype init_time_data: ~azure.security.attestation.models.InitTimeData
        :keyword draft_policy_for_attestation: Attest against the provided draft policy. Note that the
         resulting token cannot
         be validated. Default value is None.
        :paramtype draft_policy_for_attestation: str
        :keyword nonce: Nonce for incoming request - emitted in the generated attestation token.
         Default value is None.
        :paramtype nonce: str
        :return: AttestationResponse. The AttestationResponse is compatible with MutableMapping
        :rtype: ~azure.security.attestation.models.AttestationResponse
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[_models.AttestationResponse] = kwargs.pop("cls", None)

        if body is _Unset:
            body = {
                "draftPolicyForAttestation": draft_policy_for_attestation,
                "initTimeData": init_time_data,
                "nonce": nonce,
                "report": report,
                "runtimeData": runtime_data,
            }
            body = {k: v for k, v in body.items() if v is not None}
        content_type = content_type or "application/json"
        _content = None
        if isinstance(body, (IOBase, bytes)):
            _content = body
        else:
            _content = json.dumps(body, cls=SdkJSONEncoder, exclude_readonly=True)  # type: ignore

        _request = build_attestation_attest_open_enclave_request(
            content_type=content_type,
            api_version=self._config.api_version,
            content=_content,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = kwargs.pop("stream", False)
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            if _stream:
                try:
                    await response.read()  # Load the body in memory and close the socket
                except (StreamConsumedError, StreamClosedError):
                    pass
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        if _stream:
            deserialized = response.iter_bytes()
        else:
            deserialized = _deserialize(_models.AttestationResponse, response.json())

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    @overload
    async def attest_sgx_enclave(
        self,
        *,
        content_type: str = "application/json",
        quote: Optional[bytes] = None,
        runtime_data: Optional[_models.RuntimeData] = None,
        init_time_data: Optional[_models.InitTimeData] = None,
        draft_policy_for_attestation: Optional[str] = None,
        nonce: Optional[str] = None,
        **kwargs: Any
    ) -> _models.AttestationResponse:
        """Attest to an SGX enclave.

        Processes an SGX enclave quote, producing an artifact. The type of artifact
        produced is dependent upon attestation policy.

        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :keyword quote: Quote of the enclave to be attested. Default value is None.
        :paramtype quote: bytes
        :keyword runtime_data: Runtime data provided by the enclave at the time of quote generation.
         The MAA
         will verify that the first 32 bytes of the report_data field of the quote
         contains the SHA256 hash of the decoded "data" field of the runtime data. Default value is
         None.
        :paramtype runtime_data: ~azure.security.attestation.models.RuntimeData
        :keyword init_time_data: Initialization data provided when the enclave is created. MAA will
         verify that
         the init data was known to the enclave. Note that InitTimeData is invalid for
         CoffeeLake processors. Default value is None.
        :paramtype init_time_data: ~azure.security.attestation.models.InitTimeData
        :keyword draft_policy_for_attestation: Attest against the provided draft policy. Note that the
         resulting token cannot
         be validated. Default value is None.
        :paramtype draft_policy_for_attestation: str
        :keyword nonce: Nonce for incoming request - emitted in the generated attestation token.
         Default value is None.
        :paramtype nonce: str
        :return: AttestationResponse. The AttestationResponse is compatible with MutableMapping
        :rtype: ~azure.security.attestation.models.AttestationResponse
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    async def attest_sgx_enclave(
        self, body: JSON, *, content_type: str = "application/json", **kwargs: Any
    ) -> _models.AttestationResponse:
        """Attest to an SGX enclave.

        Processes an SGX enclave quote, producing an artifact. The type of artifact
        produced is dependent upon attestation policy.

        :param body: Required.
        :type body: JSON
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: AttestationResponse. The AttestationResponse is compatible with MutableMapping
        :rtype: ~azure.security.attestation.models.AttestationResponse
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    async def attest_sgx_enclave(
        self, body: IO[bytes], *, content_type: str = "application/json", **kwargs: Any
    ) -> _models.AttestationResponse:
        """Attest to an SGX enclave.

        Processes an SGX enclave quote, producing an artifact. The type of artifact
        produced is dependent upon attestation policy.

        :param body: Required.
        :type body: IO[bytes]
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: AttestationResponse. The AttestationResponse is compatible with MutableMapping
        :rtype: ~azure.security.attestation.models.AttestationResponse
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @distributed_trace_async
    async def attest_sgx_enclave(
        self,
        body: Union[JSON, IO[bytes]] = _Unset,
        *,
        quote: Optional[bytes] = None,
        runtime_data: Optional[_models.RuntimeData] = None,
        init_time_data: Optional[_models.InitTimeData] = None,
        draft_policy_for_attestation: Optional[str] = None,
        nonce: Optional[str] = None,
        **kwargs: Any
    ) -> _models.AttestationResponse:
        """Attest to an SGX enclave.

        Processes an SGX enclave quote, producing an artifact. The type of artifact
        produced is dependent upon attestation policy.

        :param body: Is either a JSON type or a IO[bytes] type. Required.
        :type body: JSON or IO[bytes]
        :keyword quote: Quote of the enclave to be attested. Default value is None.
        :paramtype quote: bytes
        :keyword runtime_data: Runtime data provided by the enclave at the time of quote generation.
         The MAA
         will verify that the first 32 bytes of the report_data field of the quote
         contains the SHA256 hash of the decoded "data" field of the runtime data. Default value is
         None.
        :paramtype runtime_data: ~azure.security.attestation.models.RuntimeData
        :keyword init_time_data: Initialization data provided when the enclave is created. MAA will
         verify that
         the init data was known to the enclave. Note that InitTimeData is invalid for
         CoffeeLake processors. Default value is None.
        :paramtype init_time_data: ~azure.security.attestation.models.InitTimeData
        :keyword draft_policy_for_attestation: Attest against the provided draft policy. Note that the
         resulting token cannot
         be validated. Default value is None.
        :paramtype draft_policy_for_attestation: str
        :keyword nonce: Nonce for incoming request - emitted in the generated attestation token.
         Default value is None.
        :paramtype nonce: str
        :return: AttestationResponse. The AttestationResponse is compatible with MutableMapping
        :rtype: ~azure.security.attestation.models.AttestationResponse
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[_models.AttestationResponse] = kwargs.pop("cls", None)

        if body is _Unset:
            body = {
                "draftPolicyForAttestation": draft_policy_for_attestation,
                "initTimeData": init_time_data,
                "nonce": nonce,
                "quote": quote,
                "runtimeData": runtime_data,
            }
            body = {k: v for k, v in body.items() if v is not None}
        content_type = content_type or "application/json"
        _content = None
        if isinstance(body, (IOBase, bytes)):
            _content = body
        else:
            _content = json.dumps(body, cls=SdkJSONEncoder, exclude_readonly=True)  # type: ignore

        _request = build_attestation_attest_sgx_enclave_request(
            content_type=content_type,
            api_version=self._config.api_version,
            content=_content,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = kwargs.pop("stream", False)
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            if _stream:
                try:
                    await response.read()  # Load the body in memory and close the socket
                except (StreamConsumedError, StreamClosedError):
                    pass
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        if _stream:
            deserialized = response.iter_bytes()
        else:
            deserialized = _deserialize(_models.AttestationResponse, response.json())

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    @overload
    async def attest_azure_guest(
        self, *, content_type: str = "application/json", attestation_info: Optional[str] = None, **kwargs: Any
    ) -> _models.SealedAttestationResponse:
        """Attest to an Azure Guest VM.

        Processes an Azure Guest TCG Log, producing an artifact. The type of artifact
        produced is dependent upon attestation policy.

        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :keyword attestation_info: Attestation client information containing all artifacts required for
         Guest
         Attestation. Default value is None.
        :paramtype attestation_info: str
        :return: SealedAttestationResponse. The SealedAttestationResponse is compatible with
         MutableMapping
        :rtype: ~azure.security.attestation.models.SealedAttestationResponse
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    async def attest_azure_guest(
        self, body: JSON, *, content_type: str = "application/json", **kwargs: Any
    ) -> _models.SealedAttestationResponse:
        """Attest to an Azure Guest VM.

        Processes an Azure Guest TCG Log, producing an artifact. The type of artifact
        produced is dependent upon attestation policy.

        :param body: Required.
        :type body: JSON
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: SealedAttestationResponse. The SealedAttestationResponse is compatible with
         MutableMapping
        :rtype: ~azure.security.attestation.models.SealedAttestationResponse
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    async def attest_azure_guest(
        self, body: IO[bytes], *, content_type: str = "application/json", **kwargs: Any
    ) -> _models.SealedAttestationResponse:
        """Attest to an Azure Guest VM.

        Processes an Azure Guest TCG Log, producing an artifact. The type of artifact
        produced is dependent upon attestation policy.

        :param body: Required.
        :type body: IO[bytes]
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: SealedAttestationResponse. The SealedAttestationResponse is compatible with
         MutableMapping
        :rtype: ~azure.security.attestation.models.SealedAttestationResponse
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @distributed_trace_async
    async def attest_azure_guest(
        self, body: Union[JSON, IO[bytes]] = _Unset, *, attestation_info: Optional[str] = None, **kwargs: Any
    ) -> _models.SealedAttestationResponse:
        """Attest to an Azure Guest VM.

        Processes an Azure Guest TCG Log, producing an artifact. The type of artifact
        produced is dependent upon attestation policy.

        :param body: Is either a JSON type or a IO[bytes] type. Required.
        :type body: JSON or IO[bytes]
        :keyword attestation_info: Attestation client information containing all artifacts required for
         Guest
         Attestation. Default value is None.
        :paramtype attestation_info: str
        :return: SealedAttestationResponse. The SealedAttestationResponse is compatible with
         MutableMapping
        :rtype: ~azure.security.attestation.models.SealedAttestationResponse
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[_models.SealedAttestationResponse] = kwargs.pop("cls", None)

        if body is _Unset:
            body = {"attestationInfo": attestation_info}
            body = {k: v for k, v in body.items() if v is not None}
        content_type = content_type or "application/json"
        _content = None
        if isinstance(body, (IOBase, bytes)):
            _content = body
        else:
            _content = json.dumps(body, cls=SdkJSONEncoder, exclude_readonly=True)  # type: ignore

        _request = build_attestation_attest_azure_guest_request(
            content_type=content_type,
            api_version=self._config.api_version,
            content=_content,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = kwargs.pop("stream", False)
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            if _stream:
                try:
                    await response.read()  # Load the body in memory and close the socket
                except (StreamConsumedError, StreamClosedError):
                    pass
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        if _stream:
            deserialized = response.iter_bytes()
        else:
            deserialized = _deserialize(_models.SealedAttestationResponse, response.json())

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    @overload
    async def attest_tpm(
        self, *, content_type: str = "application/json", data: Optional[bytes] = None, **kwargs: Any
    ) -> _models.TpmAttestationResponse:
        """Attest a Virtualization-based Security (VBS) enclave.

        Processes attestation evidence from a VBS enclave, producing an attestation
        result. The attestation result produced is dependent upon the attestation
        policy.

        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :keyword data: Protocol data containing artifacts for attestation. Default value is None.
        :paramtype data: bytes
        :return: TpmAttestationResponse. The TpmAttestationResponse is compatible with MutableMapping
        :rtype: ~azure.security.attestation.models.TpmAttestationResponse
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    async def attest_tpm(
        self, body: JSON, *, content_type: str = "application/json", **kwargs: Any
    ) -> _models.TpmAttestationResponse:
        """Attest a Virtualization-based Security (VBS) enclave.

        Processes attestation evidence from a VBS enclave, producing an attestation
        result. The attestation result produced is dependent upon the attestation
        policy.

        :param body: Required.
        :type body: JSON
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: TpmAttestationResponse. The TpmAttestationResponse is compatible with MutableMapping
        :rtype: ~azure.security.attestation.models.TpmAttestationResponse
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    async def attest_tpm(
        self, body: IO[bytes], *, content_type: str = "application/json", **kwargs: Any
    ) -> _models.TpmAttestationResponse:
        """Attest a Virtualization-based Security (VBS) enclave.

        Processes attestation evidence from a VBS enclave, producing an attestation
        result. The attestation result produced is dependent upon the attestation
        policy.

        :param body: Required.
        :type body: IO[bytes]
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: TpmAttestationResponse. The TpmAttestationResponse is compatible with MutableMapping
        :rtype: ~azure.security.attestation.models.TpmAttestationResponse
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @distributed_trace_async
    async def attest_tpm(
        self, body: Union[JSON, IO[bytes]] = _Unset, *, data: Optional[bytes] = None, **kwargs: Any
    ) -> _models.TpmAttestationResponse:
        """Attest a Virtualization-based Security (VBS) enclave.

        Processes attestation evidence from a VBS enclave, producing an attestation
        result. The attestation result produced is dependent upon the attestation
        policy.

        :param body: Is either a JSON type or a IO[bytes] type. Required.
        :type body: JSON or IO[bytes]
        :keyword data: Protocol data containing artifacts for attestation. Default value is None.
        :paramtype data: bytes
        :return: TpmAttestationResponse. The TpmAttestationResponse is compatible with MutableMapping
        :rtype: ~azure.security.attestation.models.TpmAttestationResponse
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[_models.TpmAttestationResponse] = kwargs.pop("cls", None)

        if body is _Unset:
            body = {"data": data}
            body = {k: v for k, v in body.items() if v is not None}
        content_type = content_type or "application/json"
        _content = None
        if isinstance(body, (IOBase, bytes)):
            _content = body
        else:
            _content = json.dumps(body, cls=SdkJSONEncoder, exclude_readonly=True)  # type: ignore

        _request = build_attestation_attest_tpm_request(
            content_type=content_type,
            api_version=self._config.api_version,
            content=_content,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = kwargs.pop("stream", False)
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            if _stream:
                try:
                    await response.read()  # Load the body in memory and close the socket
                except (StreamConsumedError, StreamClosedError):
                    pass
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        if _stream:
            deserialized = response.iter_bytes()
        else:
            deserialized = _deserialize(_models.TpmAttestationResponse, response.json())

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    @overload
    async def attest_sev_snp_vm(
        self,
        *,
        content_type: str = "application/json",
        report: Optional[str] = None,
        runtime_data: Optional[_models.RuntimeData] = None,
        init_time_data: Optional[_models.InitTimeData] = None,
        draft_policy_for_attestation: Optional[str] = None,
        nonce: Optional[str] = None,
        **kwargs: Any
    ) -> _models.AttestationResponse:
        """Attest to an SEV SNP Virtual Machine.

        Processes a SEV SNP Boot chain. The type of artifact produced is dependent upon
        attestation policy.

        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :keyword report: Hardware rooted report of the virtual machine being attested along with the
         signing certificate chain and optionally, additional endorsements. Default value is None.
        :paramtype report: str
        :keyword runtime_data: Runtime data provided by the enclave at the time of report generation.
         The MAA
         will verify that the run time data is known to the attestation target. Default value is None.
        :paramtype runtime_data: ~azure.security.attestation.models.RuntimeData
        :keyword init_time_data: Initialization data provided by the enclave at the time of report
         generation.
         The MAA will verify that the init time data is known to the attestation target. Default value
         is None.
        :paramtype init_time_data: ~azure.security.attestation.models.InitTimeData
        :keyword draft_policy_for_attestation: Attest against the provided draft policy. Note that the
         resulting token cannot
         be validated. Default value is None.
        :paramtype draft_policy_for_attestation: str
        :keyword nonce: Nonce for incoming request - emitted in the generated attestation token.
         Default value is None.
        :paramtype nonce: str
        :return: AttestationResponse. The AttestationResponse is compatible with MutableMapping
        :rtype: ~azure.security.attestation.models.AttestationResponse
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    async def attest_sev_snp_vm(
        self, body: JSON, *, content_type: str = "application/json", **kwargs: Any
    ) -> _models.AttestationResponse:
        """Attest to an SEV SNP Virtual Machine.

        Processes a SEV SNP Boot chain. The type of artifact produced is dependent upon
        attestation policy.

        :param body: Required.
        :type body: JSON
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: AttestationResponse. The AttestationResponse is compatible with MutableMapping
        :rtype: ~azure.security.attestation.models.AttestationResponse
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    async def attest_sev_snp_vm(
        self, body: IO[bytes], *, content_type: str = "application/json", **kwargs: Any
    ) -> _models.AttestationResponse:
        """Attest to an SEV SNP Virtual Machine.

        Processes a SEV SNP Boot chain. The type of artifact produced is dependent upon
        attestation policy.

        :param body: Required.
        :type body: IO[bytes]
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: AttestationResponse. The AttestationResponse is compatible with MutableMapping
        :rtype: ~azure.security.attestation.models.AttestationResponse
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @distributed_trace_async
    async def attest_sev_snp_vm(
        self,
        body: Union[JSON, IO[bytes]] = _Unset,
        *,
        report: Optional[str] = None,
        runtime_data: Optional[_models.RuntimeData] = None,
        init_time_data: Optional[_models.InitTimeData] = None,
        draft_policy_for_attestation: Optional[str] = None,
        nonce: Optional[str] = None,
        **kwargs: Any
    ) -> _models.AttestationResponse:
        """Attest to an SEV SNP Virtual Machine.

        Processes a SEV SNP Boot chain. The type of artifact produced is dependent upon
        attestation policy.

        :param body: Is either a JSON type or a IO[bytes] type. Required.
        :type body: JSON or IO[bytes]
        :keyword report: Hardware rooted report of the virtual machine being attested along with the
         signing certificate chain and optionally, additional endorsements. Default value is None.
        :paramtype report: str
        :keyword runtime_data: Runtime data provided by the enclave at the time of report generation.
         The MAA
         will verify that the run time data is known to the attestation target. Default value is None.
        :paramtype runtime_data: ~azure.security.attestation.models.RuntimeData
        :keyword init_time_data: Initialization data provided by the enclave at the time of report
         generation.
         The MAA will verify that the init time data is known to the attestation target. Default value
         is None.
        :paramtype init_time_data: ~azure.security.attestation.models.InitTimeData
        :keyword draft_policy_for_attestation: Attest against the provided draft policy. Note that the
         resulting token cannot
         be validated. Default value is None.
        :paramtype draft_policy_for_attestation: str
        :keyword nonce: Nonce for incoming request - emitted in the generated attestation token.
         Default value is None.
        :paramtype nonce: str
        :return: AttestationResponse. The AttestationResponse is compatible with MutableMapping
        :rtype: ~azure.security.attestation.models.AttestationResponse
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[_models.AttestationResponse] = kwargs.pop("cls", None)

        if body is _Unset:
            body = {
                "draftPolicyForAttestation": draft_policy_for_attestation,
                "initTimeData": init_time_data,
                "nonce": nonce,
                "report": report,
                "runtimeData": runtime_data,
            }
            body = {k: v for k, v in body.items() if v is not None}
        content_type = content_type or "application/json"
        _content = None
        if isinstance(body, (IOBase, bytes)):
            _content = body
        else:
            _content = json.dumps(body, cls=SdkJSONEncoder, exclude_readonly=True)  # type: ignore

        _request = build_attestation_attest_sev_snp_vm_request(
            content_type=content_type,
            api_version=self._config.api_version,
            content=_content,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = kwargs.pop("stream", False)
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            if _stream:
                try:
                    await response.read()  # Load the body in memory and close the socket
                except (StreamConsumedError, StreamClosedError):
                    pass
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        if _stream:
            deserialized = response.iter_bytes()
        else:
            deserialized = _deserialize(_models.AttestationResponse, response.json())

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    @overload
    async def attest_tdx_vm(
        self,
        *,
        content_type: str = "application/json",
        quote: Optional[bytes] = None,
        runtime_data: Optional[_models.RuntimeData] = None,
        init_time_data: Optional[_models.InitTimeData] = None,
        nonce: Optional[str] = None,
        **kwargs: Any
    ) -> _models.AttestationResponse:
        """Attest to a TDX Virtual Machine.

        Processes an TDX quote, producing an artifact. The type of artifact produced is
        dependent upon attestation policy.

        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :keyword quote: Quote of the TDX virtual machine to be attested. Default value is None.
        :paramtype quote: bytes
        :keyword runtime_data: Runtime data provided by the enclave at the time of quote generation.
         The MAA
         will verify that the first 32 bytes of the report_data field of the quote
         contains the SHA256 hash of the decoded "data" field of the runtime data. Default value is
         None.
        :paramtype runtime_data: ~azure.security.attestation.models.RuntimeData
        :keyword init_time_data: Initialization data provided when the enclave is created. MAA will
         verify that
         the init data was known to the enclave. Default value is None.
        :paramtype init_time_data: ~azure.security.attestation.models.InitTimeData
        :keyword nonce: Nonce for incoming request - emitted in the generated attestation token.
         Default value is None.
        :paramtype nonce: str
        :return: AttestationResponse. The AttestationResponse is compatible with MutableMapping
        :rtype: ~azure.security.attestation.models.AttestationResponse
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    async def attest_tdx_vm(
        self, body: JSON, *, content_type: str = "application/json", **kwargs: Any
    ) -> _models.AttestationResponse:
        """Attest to a TDX Virtual Machine.

        Processes an TDX quote, producing an artifact. The type of artifact produced is
        dependent upon attestation policy.

        :param body: Required.
        :type body: JSON
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: AttestationResponse. The AttestationResponse is compatible with MutableMapping
        :rtype: ~azure.security.attestation.models.AttestationResponse
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    async def attest_tdx_vm(
        self, body: IO[bytes], *, content_type: str = "application/json", **kwargs: Any
    ) -> _models.AttestationResponse:
        """Attest to a TDX Virtual Machine.

        Processes an TDX quote, producing an artifact. The type of artifact produced is
        dependent upon attestation policy.

        :param body: Required.
        :type body: IO[bytes]
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: AttestationResponse. The AttestationResponse is compatible with MutableMapping
        :rtype: ~azure.security.attestation.models.AttestationResponse
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @distributed_trace_async
    async def attest_tdx_vm(
        self,
        body: Union[JSON, IO[bytes]] = _Unset,
        *,
        quote: Optional[bytes] = None,
        runtime_data: Optional[_models.RuntimeData] = None,
        init_time_data: Optional[_models.InitTimeData] = None,
        nonce: Optional[str] = None,
        **kwargs: Any
    ) -> _models.AttestationResponse:
        """Attest to a TDX Virtual Machine.

        Processes an TDX quote, producing an artifact. The type of artifact produced is
        dependent upon attestation policy.

        :param body: Is either a JSON type or a IO[bytes] type. Required.
        :type body: JSON or IO[bytes]
        :keyword quote: Quote of the TDX virtual machine to be attested. Default value is None.
        :paramtype quote: bytes
        :keyword runtime_data: Runtime data provided by the enclave at the time of quote generation.
         The MAA
         will verify that the first 32 bytes of the report_data field of the quote
         contains the SHA256 hash of the decoded "data" field of the runtime data. Default value is
         None.
        :paramtype runtime_data: ~azure.security.attestation.models.RuntimeData
        :keyword init_time_data: Initialization data provided when the enclave is created. MAA will
         verify that
         the init data was known to the enclave. Default value is None.
        :paramtype init_time_data: ~azure.security.attestation.models.InitTimeData
        :keyword nonce: Nonce for incoming request - emitted in the generated attestation token.
         Default value is None.
        :paramtype nonce: str
        :return: AttestationResponse. The AttestationResponse is compatible with MutableMapping
        :rtype: ~azure.security.attestation.models.AttestationResponse
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[_models.AttestationResponse] = kwargs.pop("cls", None)

        if body is _Unset:
            body = {"initTimeData": init_time_data, "nonce": nonce, "quote": quote, "runtimeData": runtime_data}
            body = {k: v for k, v in body.items() if v is not None}
        content_type = content_type or "application/json"
        _content = None
        if isinstance(body, (IOBase, bytes)):
            _content = body
        else:
            _content = json.dumps(body, cls=SdkJSONEncoder, exclude_readonly=True)  # type: ignore

        _request = build_attestation_attest_tdx_vm_request(
            content_type=content_type,
            api_version=self._config.api_version,
            content=_content,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = kwargs.pop("stream", False)
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            if _stream:
                try:
                    await response.read()  # Load the body in memory and close the socket
                except (StreamConsumedError, StreamClosedError):
                    pass
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        if _stream:
            deserialized = response.iter_bytes()
        else:
            deserialized = _deserialize(_models.AttestationResponse, response.json())

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore


class TcbBaselinesOperations:
    """
    .. warning::
        **DO NOT** instantiate this class directly.

        Instead, you should access the following operations through
        :class:`~azure.security.attestation.aio.AttestationClient`'s
        :attr:`tcb_baselines` attribute.
    """

    def __init__(self, *args, **kwargs) -> None:
        input_args = list(args)
        self._client: AsyncPipelineClient = input_args.pop(0) if input_args else kwargs.pop("client")
        self._config: AttestationClientConfiguration = input_args.pop(0) if input_args else kwargs.pop("config")
        self._serialize: Serializer = input_args.pop(0) if input_args else kwargs.pop("serializer")
        self._deserialize: Deserializer = input_args.pop(0) if input_args else kwargs.pop("deserializer")

    @distributed_trace_async
    async def get(
        self, attestation_type: Union[str, _models.AttestationType], **kwargs: Any
    ) -> _models.TcbBaselineResult:
        """Retrieves a list of all Azure supported baseline details for the a TEE type
        along with an indication of which one is in enforced for the attestation
        provider.

        Retrieves a list of all Azure supported baseline details for the a TEE type
        along with an indication of which one is in enforced for the attestation
        provider.

        :param attestation_type: Specifies the trusted execution environment to be used to validate the
         evidence. Known values are: "SgxEnclave", "OpenEnclave", "AzureGuest", "SevSnpVm", "Tpm", and
         "TdxVm". Required.
        :type attestation_type: str or ~azure.security.attestation.models.AttestationType
        :return: TcbBaselineResult. The TcbBaselineResult is compatible with MutableMapping
        :rtype: ~azure.security.attestation.models.TcbBaselineResult
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[_models.TcbBaselineResult] = kwargs.pop("cls", None)

        _request = build_tcb_baselines_get_request(
            attestation_type=attestation_type,
            api_version=self._config.api_version,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = kwargs.pop("stream", False)
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            if _stream:
                try:
                    await response.read()  # Load the body in memory and close the socket
                except (StreamConsumedError, StreamClosedError):
                    pass
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        if _stream:
            deserialized = response.iter_bytes()
        else:
            deserialized = _deserialize(_models.TcbBaselineResult, response.json())

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore


class SigningCertificatesOperations:
    """
    .. warning::
        **DO NOT** instantiate this class directly.

        Instead, you should access the following operations through
        :class:`~azure.security.attestation.aio.AttestationClient`'s
        :attr:`signing_certificates` attribute.
    """

    def __init__(self, *args, **kwargs) -> None:
        input_args = list(args)
        self._client: AsyncPipelineClient = input_args.pop(0) if input_args else kwargs.pop("client")
        self._config: AttestationClientConfiguration = input_args.pop(0) if input_args else kwargs.pop("config")
        self._serialize: Serializer = input_args.pop(0) if input_args else kwargs.pop("serializer")
        self._deserialize: Deserializer = input_args.pop(0) if input_args else kwargs.pop("deserializer")

    @distributed_trace_async
    async def get(self, **kwargs: Any) -> _models.JsonWebKeySet:
        """Retrieves the attestation signing keys in use by the attestation service.

        Retrieves metadata signing certificates in use by the attestation service.

        :return: JsonWebKeySet. The JsonWebKeySet is compatible with MutableMapping
        :rtype: ~azure.security.attestation.models.JsonWebKeySet
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[_models.JsonWebKeySet] = kwargs.pop("cls", None)

        _request = build_signing_certificates_get_request(
            api_version=self._config.api_version,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = kwargs.pop("stream", False)
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            if _stream:
                try:
                    await response.read()  # Load the body in memory and close the socket
                except (StreamConsumedError, StreamClosedError):
                    pass
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        response_headers = {}
        response_headers["content-type"] = self._deserialize("str", response.headers.get("content-type"))

        if _stream:
            deserialized = response.iter_bytes()
        else:
            deserialized = _deserialize(_models.JsonWebKeySet, response.json())

        if cls:
            return cls(pipeline_response, deserialized, response_headers)  # type: ignore

        return deserialized  # type: ignore


class MetadataConfigurationOperations:
    """
    .. warning::
        **DO NOT** instantiate this class directly.

        Instead, you should access the following operations through
        :class:`~azure.security.attestation.aio.AttestationClient`'s
        :attr:`metadata_configuration` attribute.
    """

    def __init__(self, *args, **kwargs) -> None:
        input_args = list(args)
        self._client: AsyncPipelineClient = input_args.pop(0) if input_args else kwargs.pop("client")
        self._config: AttestationClientConfiguration = input_args.pop(0) if input_args else kwargs.pop("config")
        self._serialize: Serializer = input_args.pop(0) if input_args else kwargs.pop("serializer")
        self._deserialize: Deserializer = input_args.pop(0) if input_args else kwargs.pop("deserializer")

    @distributed_trace_async
    async def get(self, **kwargs: Any) -> _models.OpenIDConfigurationResponse:
        """Retrieves the OpenID Configuration data for the Azure Attestation Service.

        Retrieves metadata about the attestation signing keys in use by the attestation
        service.

        :return: OpenIDConfigurationResponse. The OpenIDConfigurationResponse is compatible with
         MutableMapping
        :rtype: ~azure.security.attestation.models.OpenIDConfigurationResponse
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[_models.OpenIDConfigurationResponse] = kwargs.pop("cls", None)

        _request = build_metadata_configuration_get_request(
            api_version=self._config.api_version,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = kwargs.pop("stream", False)
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            if _stream:
                try:
                    await response.read()  # Load the body in memory and close the socket
                except (StreamConsumedError, StreamClosedError):
                    pass
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        if _stream:
            deserialized = response.iter_bytes()
        else:
            deserialized = _deserialize(_models.OpenIDConfigurationResponse, response.json())

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore
