/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.util.thread.strategy;

import java.io.Closeable;
import java.util.concurrent.Executor;
import java.util.concurrent.RejectedExecutionException;
import org.eclipse.jetty.util.component.ContainerLifeCycle;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;
import org.eclipse.jetty.util.thread.ExecutionStrategy;
import org.eclipse.jetty.util.thread.Invocable;
import org.eclipse.jetty.util.thread.Locker;
import org.eclipse.jetty.util.thread.ReservedThreadExecutor;

public class EatWhatYouKill
extends ContainerLifeCycle
implements ExecutionStrategy,
Runnable {
    private static final Logger LOG = Log.getLogger(EatWhatYouKill.class);
    private final Locker _locker = new Locker();
    private State _state = State.IDLE;
    private final ExecutionStrategy.Producer _producer;
    private final Executor _executor;
    private final ReservedThreadExecutor _producers;

    public EatWhatYouKill(ExecutionStrategy.Producer producer, Executor executor) {
        this(producer, executor, new ReservedThreadExecutor(executor, 1));
    }

    public EatWhatYouKill(ExecutionStrategy.Producer producer, Executor executor, int maxProducersPending) {
        this(producer, executor, new ReservedThreadExecutor(executor, maxProducersPending));
    }

    public EatWhatYouKill(ExecutionStrategy.Producer producer, Executor executor, ReservedThreadExecutor producers) {
        this._producer = producer;
        this._executor = executor;
        this._producers = producers;
        this.addBean(this._producer);
        if (LOG.isDebugEnabled()) {
            LOG.debug("{} created", this);
        }
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public void dispatch() {
        execute = false;
        locked = this._locker.lock();
        var3_3 = null;
        try {
            switch (1.$SwitchMap$org$eclipse$jetty$util$thread$strategy$EatWhatYouKill$State[this._state.ordinal()]) {
                case 1: {
                    execute = true;
                    ** break;
lbl9:
                    // 1 sources

                    break;
                }
                case 2: {
                    this._state = State.REPRODUCING;
                    ** break;
lbl13:
                    // 1 sources

                    break;
                }
                ** default:
lbl15:
                // 1 sources

                break;
            }
        }
        catch (Throwable var4_4) {
            var3_3 = var4_4;
            throw var4_4;
        }
        finally {
            if (locked != null) {
                EatWhatYouKill.$closeResource(var3_3, locked);
            }
        }
        if (EatWhatYouKill.LOG.isDebugEnabled()) {
            EatWhatYouKill.LOG.debug("{} dispatch {}", new Object[]{this, execute});
        }
        if (execute) {
            this._executor.execute(this);
        }
    }

    @Override
    public void run() {
        if (LOG.isDebugEnabled()) {
            LOG.debug("{} run", this);
        }
        this.produce();
    }

    @Override
    public void produce() {
        if (LOG.isDebugEnabled()) {
            LOG.debug("{} produce", this);
        }
        boolean reproduce = true;
        while (this.isRunning() && this.tryProduce(reproduce) && this.doProduce()) {
            reproduce = false;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean tryProduce(boolean reproduce) {
        boolean producing = false;
        try (Locker.Lock locked = this._locker.lock();){
            switch (this._state) {
                case IDLE: {
                    this._state = State.PRODUCING;
                    producing = true;
                    return producing;
                }
                case PRODUCING: {
                    if (!reproduce) return producing;
                    this._state = State.REPRODUCING;
                    return producing;
                }
            }
            return producing;
        }
    }

    public boolean doProduce() {
        boolean producing = true;
        while (this.isRunning() && producing) {
            boolean consume;
            Runnable task = null;
            try {
                task = this._producer.produce();
            }
            catch (Throwable e) {
                LOG.warn(e);
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("{} t={}/{}", new Object[]{this, task, Invocable.getInvocationType(task)});
            }
            if (task == null) {
                Locker.Lock locked = this._locker.lock();
                Throwable throwable = null;
                try {
                    if (this._state == State.REPRODUCING) {
                        this._state = State.PRODUCING;
                        continue;
                    }
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("{} IDLE", this.toStringLocked());
                    }
                    this._state = State.IDLE;
                    producing = false;
                    continue;
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (locked != null) {
                        EatWhatYouKill.$closeResource(throwable, locked);
                    }
                    continue;
                }
            }
            if (Invocable.getInvocationType(task) == Invocable.InvocationType.NON_BLOCKING) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("{} PC t={}", this, task);
                }
                task.run();
                continue;
            }
            try (Locker.Lock locked = this._locker.lock();){
                if (this._producers.tryExecute(this)) {
                    this._state = State.IDLE;
                    producing = false;
                    consume = true;
                } else {
                    consume = false;
                }
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("{} {} t={}", this, consume ? "EPC" : "PEC", task);
            }
            try {
                if (consume) {
                    task.run();
                    continue;
                }
                this._executor.execute(task);
            }
            catch (RejectedExecutionException e) {
                LOG.warn(e);
                if (!(task instanceof Closeable)) continue;
                try {
                    ((Closeable)((Object)task)).close();
                }
                catch (Throwable e2) {
                    LOG.ignore(e2);
                }
            }
            catch (Throwable e) {
                LOG.warn(e);
            }
        }
        return producing;
    }

    public Boolean isIdle() {
        try (Locker.Lock locked = this._locker.lock();){
            Boolean bl = this._state == State.IDLE;
            return bl;
        }
    }

    public String toString() {
        try (Locker.Lock locked = this._locker.lock();){
            String string = this.toStringLocked();
            return string;
        }
    }

    public String toStringLocked() {
        StringBuilder builder = new StringBuilder();
        this.getString(builder);
        this.getState(builder);
        return builder.toString();
    }

    private void getString(StringBuilder builder) {
        builder.append(this.getClass().getSimpleName());
        builder.append('@');
        builder.append(Integer.toHexString(this.hashCode()));
        builder.append('/');
        builder.append(this._producer);
        builder.append('/');
    }

    private void getState(StringBuilder builder) {
        builder.append((Object)this._state);
        builder.append('/');
        builder.append(this._producers);
    }

    private static enum State {
        IDLE,
        PRODUCING,
        REPRODUCING;

    }
}

