/*
 * Decompiled with CFR 0.152.
 */
package fi.csc.chipster.toolbox;

import fi.csc.chipster.auth.AuthenticationClient;
import fi.csc.chipster.rest.Config;
import fi.csc.chipster.rest.RestUtils;
import fi.csc.chipster.toolbox.ToolboxTool;
import fi.csc.microarray.description.SADLDescription;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import javax.ws.rs.client.Client;
import javax.ws.rs.client.ClientBuilder;
import javax.ws.rs.client.WebTarget;

public class ToolboxClientRest {
    private String baseUri;

    public static void main(String[] args) throws IOException {
        Config config = new Config();
        Client client = ClientBuilder.newClient();
        WebTarget webTarget = client.target(config.getString("toolbox")).path("tools/norm-affy.R/sadl");
        String sadl = (String)webTarget.request().get(String.class);
        System.out.println(sadl);
    }

    public ToolboxClientRest(String toolboxUri) {
        this.baseUri = toolboxUri;
    }

    public ToolboxTool getTool(String toolId) {
        WebTarget serviceTarget = AuthenticationClient.getClient().target(this.baseUri).path("tools/" + toolId);
        String json = (String)serviceTarget.request(new String[]{"application/json"}).get(String.class);
        ToolboxTool tool = RestUtils.parseJson(ToolboxTool.class, json, false);
        return tool;
    }

    public HashMap<String, SADLDescription> getTools() {
        WebTarget serviceTarget = AuthenticationClient.getClient().target(this.baseUri).path("tools");
        String toolsJson = (String)serviceTarget.request(new String[]{"application/json"}).get(String.class);
        List tools = RestUtils.parseJson(List.class, SADLDescription.class, toolsJson, false);
        HashMap<String, SADLDescription> map = new HashMap<String, SADLDescription>();
        for (SADLDescription tool : tools) {
            map.put(tool.getName().getID(), tool);
        }
        return map;
    }
}

