/*
 * Decompiled with CFR 0.152.
 */
package fi.csc.chipster.sessiondb;

import fi.csc.chipster.auth.AuthenticationClient;
import fi.csc.chipster.rest.CredentialsProvider;
import fi.csc.chipster.rest.RestUtils;
import fi.csc.chipster.rest.websocket.WebSocketClient;
import fi.csc.chipster.scheduler.IdPair;
import fi.csc.chipster.servicelocator.ServiceLocatorClient;
import fi.csc.chipster.sessiondb.RestException;
import fi.csc.chipster.sessiondb.model.Dataset;
import fi.csc.chipster.sessiondb.model.DatasetToken;
import fi.csc.chipster.sessiondb.model.Job;
import fi.csc.chipster.sessiondb.model.Rule;
import fi.csc.chipster.sessiondb.model.Session;
import fi.csc.chipster.sessiondb.model.SessionEvent;
import fi.csc.chipster.sessiondb.model.TableStats;
import fi.csc.microarray.messaging.JobState;
import java.io.IOException;
import java.time.Duration;
import java.time.LocalDateTime;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import javax.websocket.MessageHandler;
import javax.ws.rs.InternalServerErrorException;
import javax.ws.rs.client.Entity;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriBuilder;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class SessionDbClient {
    private static final Logger logger = LogManager.getLogger();
    private ServiceLocatorClient serviceLocator;
    private List<String> sessionDbList;
    private List<String> sessionDbEventsList;
    private CredentialsProvider credentials;
    private WebSocketClient client;
    private String sessionDbUri;
    private String sessionDbEventsUri;

    public SessionDbClient(ServiceLocatorClient serviceLocator, CredentialsProvider credentials) {
        this.serviceLocator = serviceLocator;
        this.credentials = credentials;
        this.sessionDbList = serviceLocator.get("session-db");
        this.sessionDbEventsList = serviceLocator.get("session-db-events");
        if (this.sessionDbList.isEmpty()) {
            throw new InternalServerErrorException("no session-dbs registered to service-locator");
        }
        if (this.sessionDbEventsList.isEmpty()) {
            throw new InternalServerErrorException("no session-db-events registered to service-locator");
        }
        this.init(this.sessionDbList.get(0), this.sessionDbEventsList.get(0));
    }

    public SessionDbClient(String sessionDbUri, String sessionDbEventsUri, CredentialsProvider credentials) {
        this.credentials = credentials;
        this.init(sessionDbUri, sessionDbEventsUri);
    }

    private void init(String sessionDbUri, String sessionDbEventsUri) {
        this.sessionDbUri = sessionDbUri;
        this.sessionDbEventsUri = sessionDbEventsUri;
    }

    private WebTarget getSessionDbTarget() {
        return this.credentials != null ? AuthenticationClient.getClient(this.credentials.getUsername(), this.credentials.getPassword(), true).target(this.sessionDbUri) : AuthenticationClient.getClient().target(this.sessionDbUri);
    }

    public void subscribe(String topic, final SessionEventListener listener, String name) throws RestException {
        try {
            UriBuilder uriBuilder = UriBuilder.fromUri((String)this.sessionDbEventsUri).path("events").path(topic);
            this.client = new WebSocketClient(uriBuilder.toString(), new MessageHandler.Whole<String>(){

                public void onMessage(String message) {
                    listener.onEvent(RestUtils.parseJson(SessionEvent.class, message));
                }
            }, true, name, this.credentials);
        }
        catch (WebSocketClient.WebSocketClosedException | WebSocketClient.WebSocketErrorException | InterruptedException e) {
            throw new RestException("websocket error", e);
        }
    }

    public void close() throws IOException {
        if (this.client != null) {
            this.client.shutdown();
        }
    }

    private WebTarget getSessionsTarget() {
        return this.getSessionDbTarget().path("sessions");
    }

    private WebTarget getSessionTarget(UUID sessionId) {
        return this.getSessionsTarget().path(sessionId.toString());
    }

    private WebTarget getDatasetsTarget(UUID sessionId) {
        return this.getSessionTarget(sessionId).path("datasets");
    }

    private WebTarget getDatasetTarget(UUID sessionId, UUID datasetId) {
        return this.getDatasetsTarget(sessionId).path(datasetId.toString());
    }

    private WebTarget getJobsTarget(UUID sessionId) {
        return this.getSessionTarget(sessionId).path("jobs");
    }

    private WebTarget getJobTarget(UUID sessionId, UUID jobId) {
        return this.getJobsTarget(sessionId).path(jobId.toString());
    }

    private WebTarget getRulesTarget(UUID sessionId) {
        return this.getSessionTarget(sessionId).path("rules");
    }

    private WebTarget getDatasetTokenTarget() {
        return this.getSessionDbTarget().path("datasettokens");
    }

    private WebTarget getRuleTarget(UUID sessionId, UUID authorizationId) {
        return this.getRulesTarget(sessionId).path(authorizationId.toString());
    }

    private <T> List<T> getList(WebTarget target, Class<T> type) throws RestException {
        Response response = (Response)target.request().get(Response.class);
        if (!RestUtils.isSuccessful(response.getStatus())) {
            throw new RestException("get a list of " + type.getSimpleName() + " failed ", response, target.getUri());
        }
        String json = (String)response.readEntity(String.class);
        return RestUtils.parseJson(List.class, type, json);
    }

    private <T> T get(WebTarget target, Class<T> type) throws RestException {
        Response response = (Response)target.request().get(Response.class);
        if (!RestUtils.isSuccessful(response.getStatus())) {
            throw new RestException("get " + type.getSimpleName() + " failed ", response, target.getUri());
        }
        return (T)response.readEntity(type);
    }

    private UUID post(WebTarget target, Object obj) throws RestException {
        Response response = (Response)target.request().post(Entity.entity((Object)obj, (String)"application/json"), Response.class);
        if (!RestUtils.isSuccessful(response.getStatus())) {
            throw new RestException("post " + obj.getClass().getSimpleName() + " failed ", response, target.getUri());
        }
        return UUID.fromString(RestUtils.basename(response.getLocation().getPath()));
    }

    private <T> T postWithObjectResponse(WebTarget target, Object obj, Class<T> responseType) throws RestException {
        Entity entity = null;
        entity = obj != null ? Entity.entity((Object)obj, (String)"application/json") : Entity.json((Object)"");
        Response response = (Response)target.request().post(entity, Response.class);
        if (!RestUtils.isSuccessful(response.getStatus())) {
            throw new RestException("post " + (obj == null ? null : obj.getClass().getSimpleName()) + " failed ", response, target.getUri());
        }
        return (T)response.readEntity(responseType);
    }

    private Response put(WebTarget target, Object obj) throws RestException {
        Response response = (Response)target.request().put(Entity.entity((Object)obj, (String)"application/json"), Response.class);
        if (!RestUtils.isSuccessful(response.getStatus())) {
            throw new RestException("put " + obj.getClass().getSimpleName() + " failed ", response, target.getUri());
        }
        return response;
    }

    private void delete(WebTarget target) throws RestException {
        Response response = (Response)target.request().delete(Response.class);
        if (!RestUtils.isSuccessful(response.getStatus())) {
            throw new RestException("delete failed ", response, target.getUri());
        }
    }

    public HashMap<UUID, Session> getSessions() throws RestException {
        List<Session> sessionList = this.getList(this.getSessionsTarget(), Session.class);
        HashMap<UUID, Session> map = new HashMap<UUID, Session>();
        for (Session session : sessionList) {
            map.put(session.getSessionId(), session);
        }
        return map;
    }

    public Session getSession(UUID sessionId) throws RestException {
        Session session = this.get(this.getSessionTarget(sessionId), Session.class);
        HashMap<UUID, Dataset> datasets = this.getDatasets(sessionId);
        HashMap<UUID, Job> jobs = this.getJobs(sessionId);
        session.setDatasets(datasets);
        session.setJobs(jobs);
        return session;
    }

    public UUID createSession(Session session) throws RestException {
        UUID id = this.post(this.getSessionsTarget(), session);
        session.setSessionId(id);
        return id;
    }

    public void updateSession(Session session) throws RestException {
        this.put(this.getSessionTarget(session.getSessionId()), session);
    }

    public void deleteSession(UUID sessionId) throws RestException {
        this.delete(this.getSessionTarget(sessionId));
    }

    public HashMap<UUID, Dataset> getDatasets(UUID sessionId) throws RestException {
        List<Dataset> datasetList = this.getList(this.getDatasetsTarget(sessionId), Dataset.class);
        HashMap<UUID, Dataset> datasetMap = new HashMap<UUID, Dataset>();
        for (Dataset dataset : datasetList) {
            datasetMap.put(dataset.getDatasetId(), dataset);
        }
        return datasetMap;
    }

    public Dataset getDataset(UUID sessionId, UUID datasetId) throws RestException {
        return this.getDataset(sessionId, datasetId, false);
    }

    public Dataset getDataset(UUID sessionId, UUID datasetId, boolean requireReadWrite) throws RestException {
        WebTarget target = this.getDatasetTarget(sessionId, datasetId);
        if (requireReadWrite) {
            target.queryParam("read-write", new Object[]{requireReadWrite});
        }
        return this.get(target, Dataset.class);
    }

    public UUID createDataset(UUID sessionId, Dataset dataset) throws RestException {
        UUID id = this.post(this.getDatasetsTarget(sessionId), dataset);
        dataset.setDatasetId(id);
        return id;
    }

    public Response updateDataset(UUID sessionId, Dataset dataset) throws RestException {
        return this.put(this.getDatasetTarget(sessionId, dataset.getDatasetId()), dataset);
    }

    public void deleteDataset(UUID sessionId, UUID datasetId) throws RestException {
        this.delete(this.getDatasetTarget(sessionId, datasetId));
    }

    public HashMap<UUID, Job> getJobs(UUID sessionId) throws RestException {
        List<Job> jobsList = this.getList(this.getJobsTarget(sessionId), Job.class);
        HashMap<UUID, Job> jobMap = new HashMap<UUID, Job>();
        for (Job job : jobsList) {
            jobMap.put(job.getJobId(), job);
        }
        return jobMap;
    }

    public Job getJob(UUID sessionId, UUID jobId) throws RestException {
        return this.get(this.getJobTarget(sessionId, jobId), Job.class);
    }

    public List<IdPair> getJobs(JobState state) throws RestException {
        return this.getList(this.getSessionDbTarget().path("jobs").queryParam("state", new Object[]{state.toString()}), IdPair.class);
    }

    public UUID createDatasetToken(UUID sessionId, UUID datasetId, Integer validSeconds) throws RestException {
        WebTarget target = this.getDatasetTokenTarget().path("sessions").path(sessionId.toString()).path("datasets").path(datasetId.toString());
        if (validSeconds != null) {
            target = target.queryParam("valid", new Object[]{LocalDateTime.now().plus(Duration.ofSeconds(validSeconds.intValue())).toString()});
        }
        DatasetToken datasetToken = this.postWithObjectResponse(target, null, DatasetToken.class);
        return datasetToken.getTokenKey();
    }

    public UUID createJob(UUID sessionId, Job job) throws RestException {
        UUID id = this.post(this.getJobsTarget(sessionId), job);
        job.setJobId(id);
        return id;
    }

    public void updateJob(UUID sessionId, Job job) throws RestException {
        this.put(this.getJobTarget(sessionId, job.getJobId()), job);
    }

    public void deleteJob(UUID sessionId, UUID jobId) throws RestException {
        this.delete(this.getJobTarget(sessionId, jobId));
    }

    public Rule getRule(UUID sessionId, UUID ruleId) throws RestException {
        return this.get(this.getRuleTarget(sessionId, ruleId), Rule.class);
    }

    public List<TableStats> getTableStats() throws RestException {
        List<TableStats> tables = this.getList(this.getSessionDbTarget().path("admin").path("tables"), TableStats.class);
        return tables;
    }

    public UUID createRule(UUID sessionId, String username, boolean readWrite) throws RestException {
        return this.post(this.getRulesTarget(sessionId), new Rule(username, readWrite));
    }

    public UUID createRule(UUID sessionId, Rule rule) throws RestException {
        return this.post(this.getRulesTarget(sessionId), rule);
    }

    public void deleteRule(UUID sessionId, UUID ruleId) throws RestException {
        this.delete(this.getRulesTarget(sessionId).path(ruleId.toString()));
    }

    public List<Rule> getRules(UUID sessionId) throws RestException {
        return this.getList(this.getRulesTarget(sessionId), Rule.class);
    }

    public static interface SessionEventListener {
        public void onEvent(SessionEvent var1);
    }
}

