/*
 * Decompiled with CFR 0.152.
 */
package fi.csc.chipster.rest.websocket;

import fi.csc.chipster.rest.websocket.WebSocketClient;
import java.io.IOException;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import javax.websocket.CloseReason;
import javax.websocket.Endpoint;
import javax.websocket.EndpointConfig;
import javax.websocket.MessageHandler;
import javax.websocket.PongMessage;
import javax.websocket.Session;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class WebSocketClientEndpoint
extends Endpoint {
    private static final Logger logger = LogManager.getLogger();
    private MessageHandler messageHandler;
    private CountDownLatch disconnectLatch;
    private CountDownLatch connectLatch = new CountDownLatch(1);
    private CloseReason closeReason;
    private Throwable throwable;
    private Session session;
    private EndpointListener endpointListener;

    public WebSocketClientEndpoint(MessageHandler.Whole<String> messageHandler, EndpointListener endpointListener) {
        this.messageHandler = messageHandler;
        this.endpointListener = endpointListener;
    }

    public void onOpen(Session session, EndpointConfig config) {
        this.session = session;
        if (this.messageHandler != null) {
            session.addMessageHandler(this.messageHandler);
        }
        this.disconnectLatch = new CountDownLatch(1);
        this.connectLatch.countDown();
        this.endpointListener.onOpen(session, config);
    }

    public void onClose(Session session, CloseReason reason) {
        this.closeReason = reason;
        this.connectLatch.countDown();
        this.disconnectLatch.countDown();
        this.endpointListener.onClose(session, reason);
    }

    public void onError(Session session, Throwable thr) {
        this.throwable = thr;
        this.connectLatch.countDown();
        this.disconnectLatch.countDown();
        this.endpointListener.onError(session, thr);
    }

    public void close() throws IOException {
        this.session.close(new CloseReason((CloseReason.CloseCode)CloseReason.CloseCodes.NORMAL_CLOSURE, "client closing"));
    }

    public boolean waitForDisconnect(long timeout) throws InterruptedException {
        return this.disconnectLatch.await(timeout, TimeUnit.SECONDS);
    }

    public void waitForConnection() throws InterruptedException, WebSocketClient.WebSocketClosedException, WebSocketClient.WebSocketErrorException {
        this.connectLatch.await();
        if (this.closeReason != null) {
            throw new WebSocketClient.WebSocketClosedException(this.closeReason);
        }
        if (this.throwable != null) {
            throw new WebSocketClient.WebSocketErrorException(this.throwable);
        }
    }

    public void sendText(String text) throws IOException {
        this.session.getBasicRemote().sendText(text);
    }

    public void ping() throws IllegalArgumentException, IOException, TimeoutException, InterruptedException {
        logger.debug("ping");
        PongHandler pongHandler = new PongHandler();
        this.session.addMessageHandler((MessageHandler)pongHandler);
        this.session.getBasicRemote().sendPing(null);
        pongHandler.await();
        this.session.removeMessageHandler((MessageHandler)pongHandler);
    }

    public static class PongHandler
    implements MessageHandler.Whole<PongMessage> {
        private CountDownLatch latch = new CountDownLatch(1);

        public void onMessage(PongMessage message) {
            logger.debug("pong");
            this.latch.countDown();
        }

        public void await() throws TimeoutException, InterruptedException {
            boolean received = this.latch.await(2L, TimeUnit.SECONDS);
            if (!received) {
                throw new TimeoutException("timeout while waiting for pong message");
            }
        }
    }

    public static interface EndpointListener {
        public void onOpen(Session var1, EndpointConfig var2);

        public void onClose(Session var1, CloseReason var2);

        public void onError(Session var1, Throwable var2);
    }
}

