/*
 * Decompiled with CFR 0.152.
 */
package fi.csc.chipster.rest.hibernate;

import fi.csc.chipster.rest.Config;
import java.util.List;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.hibernate.Transaction;
import org.hibernate.boot.registry.StandardServiceRegistryBuilder;
import org.hibernate.cfg.Configuration;
import org.hibernate.service.ServiceRegistry;

public class HibernateUtil {
    private static Logger logger = LogManager.getLogger();
    private SessionFactory sessionFactory;
    private Config config;
    private String role;

    public HibernateUtil(Config config, String role) {
        this.config = config;
        this.role = role;
    }

    public void buildSessionFactory(List<Class<?>> hibernateClasses) {
        try {
            Configuration hibernateConf = new Configuration();
            hibernateConf.setProperty("hibernate.connection.driver_class", this.config.getString(this.role + "-db-driver"));
            hibernateConf.setProperty("hibernate.connection.url", this.config.getString(this.role + "-db-url"));
            hibernateConf.setProperty("hibernate.connection.username", this.config.getString(this.role + "-db-user"));
            hibernateConf.setProperty("hibernate.connection.password", this.config.getString(this.role + "-db-pass"));
            hibernateConf.setProperty("hibernate.dialect", this.config.getString(this.role + "-db-dialect"));
            hibernateConf.setProperty("hibernate.show_sql", this.config.getString(this.role + "-db-show-sql"));
            hibernateConf.setProperty("hibernate.current_session_context_class", "thread");
            hibernateConf.setProperty("hibernate.c3p0.min_size", this.config.getString(this.role + "-db-c3p0-min-size"));
            hibernateConf.setProperty("hibernate.hbm2ddl.auto", this.config.getString(this.role + "-db-bm2ddl-auto"));
            for (Class<?> c : hibernateClasses) {
                hibernateConf.addAnnotatedClass(c);
            }
            this.sessionFactory = hibernateConf.buildSessionFactory((ServiceRegistry)new StandardServiceRegistryBuilder().applySettings((Map)hibernateConf.getProperties()).build());
        }
        catch (Throwable ex) {
            logger.error("sessionFactory creation failed.", ex);
            throw new ExceptionInInitializerError(ex);
        }
    }

    public SessionFactory getSessionFactory() {
        return this.sessionFactory;
    }

    public Session beginTransaction() {
        Session session = this.getSessionFactory().getCurrentSession();
        session.beginTransaction();
        return session;
    }

    public void commit() {
        this.getSessionFactory().getCurrentSession().getTransaction().commit();
    }

    public void rollback() {
        this.getSessionFactory().getCurrentSession().getTransaction().rollback();
    }

    public Session session() {
        return this.getSessionFactory().getCurrentSession();
    }

    public void rollbackIfActive() {
        if (this.session().getTransaction().getStatus().canRollback()) {
            this.session().getTransaction().rollback();
        }
    }

    public <T> T runInTransaction(HibernateRunnable<T> runnable) {
        T returnObj = null;
        Session session = this.getSessionFactory().openSession();
        Transaction transaction = session.beginTransaction();
        try {
            returnObj = runnable.run(session);
            transaction.commit();
        }
        catch (Exception e) {
            transaction.rollback();
            logger.error("transaction failed", (Throwable)e);
        }
        session.close();
        return returnObj;
    }

    public static interface HibernateRunnable<T> {
        public T run(Session var1);
    }
}

