/*
 * Decompiled with CFR 0.152.
 */
package fi.csc.chipster.rest.exception;

import fi.csc.chipster.rest.exception.ConflictException;
import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.ws.rs.BadRequestException;
import javax.ws.rs.ForbiddenException;
import javax.ws.rs.NotAuthorizedException;
import javax.ws.rs.NotFoundException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ExceptionServletFilter
implements Filter {
    private static final Logger logger = LogManager.getLogger();

    public void init(FilterConfig filterConfig) throws ServletException {
    }

    public void doFilter(ServletRequest req, ServletResponse resp, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest request = (HttpServletRequest)req;
        HttpServletResponse response = (HttpServletResponse)resp;
        try {
            chain.doFilter((ServletRequest)request, (ServletResponse)response);
        }
        catch (ForbiddenException e) {
            response.sendError(403, e.getMessage());
            return;
        }
        catch (NotFoundException e) {
            response.sendError(404, e.getMessage());
            return;
        }
        catch (BadRequestException e) {
            response.sendError(400, e.getMessage());
            return;
        }
        catch (NotAuthorizedException e) {
            response.sendError(401, e.getMessage());
            return;
        }
        catch (ConflictException e) {
            response.sendError(409, e.getMessage());
            return;
        }
        catch (Exception e) {
            response.sendError(500);
            logger.error("authentication error", (Throwable)e);
            return;
        }
    }

    public void destroy() {
    }
}

