/*
 * Decompiled with CFR 0.152.
 */
package fi.csc.chipster.rest;

import fi.csc.chipster.rest.StatusSource;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.jetty.server.ConnectorStatistics;
import org.eclipse.jetty.server.handler.StatisticsHandler;

public class JettyStatisticsSource
implements StatusSource {
    private ConnectorStatistics connectorStats;
    private StatisticsHandler requestStats;

    public JettyStatisticsSource(ConnectorStatistics connectorStats, StatisticsHandler requestStats) {
        this.connectorStats = connectorStats;
        this.requestStats = requestStats;
    }

    @Override
    public Map<String, Object> getStatus() {
        HashMap<String, Object> status = new HashMap<String, Object>();
        status.put("requestAverageDuration", this.requestStats.getRequestTimeMean());
        status.put("requestMaximumDuration", this.requestStats.getRequestTimeMax());
        status.put("requestCount", this.requestStats.getRequests());
        status.put("requestsPerSecond", this.perSecond(this.requestStats.getRequests(), this.requestStats));
        status.put("responseCodes200", this.requestStats.getResponses2xx());
        status.put("responseCodes400", this.requestStats.getResponses4xx());
        status.put("responseCodes500", this.requestStats.getResponses5xx());
        status.put("responseCodesOther", this.requestStats.getResponses1xx() + this.requestStats.getResponses3xx());
        status.put("connectionsOpen", this.connectorStats.getConnectionsOpen());
        status.put("jettyBytesIn", this.connectorStats.getBytesIn());
        status.put("jettybytesOut", this.connectorStats.getBytesOut());
        status.put("jettyConnectionsCount", this.connectorStats.getConnections());
        status.put("jettyMessagesInPerSecond", this.connectorStats.getMessagesInPerSecond());
        status.put("jettyMessagesOutPerSecond", this.connectorStats.getMessagesOutPerSecond());
        status.put("jettyMessagesInCount", this.connectorStats.getMessagesIn());
        status.put("jettyMessagesOutCount", this.connectorStats.getMessagesOut());
        status.put("jettyRquestsActive", this.requestStats.getRequestsActive());
        status.put("jettyResponseBytesTotal", this.requestStats.getResponsesBytesTotal());
        status.put("jettyRequestsActive", this.requestStats.getRequestsActive());
        status.put("jettyAsyncDispatches", this.requestStats.getAsyncDispatches());
        status.put("jettyRequestsAsync", this.requestStats.getAsyncRequests());
        status.put("jettyRequestsAsyncWaiting", this.requestStats.getAsyncRequestsWaiting());
        status.put("jettyDispatched", this.requestStats.getDispatched());
        status.put("jettyDispatchedActive", this.requestStats.getDispatchedActive());
        this.requestStats.statsReset();
        return status;
    }

    private double perSecond(int requests, StatisticsHandler requestStats2) {
        return (double)requests / (1000.0 * (double)requestStats2.getStatsOnMs());
    }
}

