/*
 * Decompiled with CFR 0.152.
 */
package fi.csc.chipster.rest;

import fi.csc.chipster.rest.StatusSource;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.ws.rs.ext.Provider;
import org.eclipse.jetty.util.ConcurrentHashSet;
import org.glassfish.grizzly.Connection;
import org.glassfish.grizzly.http.server.HttpServer;
import org.glassfish.grizzly.http.server.HttpServerFilter;
import org.glassfish.grizzly.http.server.HttpServerProbe;
import org.glassfish.grizzly.http.server.Request;
import org.glassfish.grizzly.http.server.Response;
import org.glassfish.jersey.server.monitoring.MonitoringStatistics;
import org.glassfish.jersey.server.monitoring.MonitoringStatisticsListener;
import org.glassfish.jersey.server.monitoring.TimeWindowStatistics;

@Provider
public class JerseyStatisticsSource
implements MonitoringStatisticsListener,
StatusSource {
    private HashMap<String, Object> latestStatistics = new HashMap();
    private ConcurrentHashSet<Request> openRequests = new ConcurrentHashSet();

    public void onStatistics(MonitoringStatistics statistics) {
        this.latestStatistics.put("exceptionMappingsSuccessful", statistics.getExceptionMapperStatistics().getSuccessfulMappings());
        this.latestStatistics.put("exceptionMappingsTotal", statistics.getExceptionMapperStatistics().getTotalMappings());
        this.latestStatistics.put("exceptionMappingsUnsuccessful", statistics.getExceptionMapperStatistics().getUnsuccessfulMappings());
        this.latestStatistics.put("requestAverageDuration", ((TimeWindowStatistics)statistics.getRequestStatistics().getTimeWindowStatistics().get(15000L)).getAverageDuration());
        this.latestStatistics.put("requestMaximumDuration", ((TimeWindowStatistics)statistics.getRequestStatistics().getTimeWindowStatistics().get(15000L)).getMaximumDuration());
        this.latestStatistics.put("requestMinimumDuration", ((TimeWindowStatistics)statistics.getRequestStatistics().getTimeWindowStatistics().get(15000L)).getMinimumDuration());
        this.latestStatistics.put("requestCount", ((TimeWindowStatistics)statistics.getRequestStatistics().getTimeWindowStatistics().get(15000L)).getRequestCount());
        this.latestStatistics.put("requestsPerSecond", ((TimeWindowStatistics)statistics.getRequestStatistics().getTimeWindowStatistics().get(15000L)).getRequestsPerSecond());
        long responseCodes200 = 0L;
        long responseCodes400 = 0L;
        long responseCodes500 = 0L;
        long responseCodesOther = 0L;
        Iterator iterator = statistics.getResponseStatistics().getResponseCodes().keySet().iterator();
        while (iterator.hasNext()) {
            int code = (Integer)iterator.next();
            long count = (Long)statistics.getResponseStatistics().getResponseCodes().get(code);
            if (code / 100 == 2) {
                responseCodes200 += count;
                continue;
            }
            if (code / 100 == 4) {
                responseCodes400 += count;
                continue;
            }
            if (code / 100 == 5) {
                responseCodes500 += count;
                continue;
            }
            responseCodesOther += count;
        }
        this.latestStatistics.put("responseCodes200", responseCodes200);
        this.latestStatistics.put("responseCodes400", responseCodes400);
        this.latestStatistics.put("responseCodes500", responseCodes500);
        this.latestStatistics.put("responseCodesOther", responseCodesOther);
        this.latestStatistics.put("connectionsOpen", this.openRequests.size());
    }

    @Override
    public Map<String, Object> getStatus() {
        return this.latestStatistics;
    }

    public void collectConnectionStatistics(HttpServer httpServer) {
        httpServer.getServerConfiguration().getMonitoringConfig().getWebServerConfig().addProbes((Object[])new HttpServerProbe[]{new HttpServerProbe.Adapter(){

            public void onRequestReceiveEvent(HttpServerFilter filter, Connection connection, Request request) {
                JerseyStatisticsSource.this.openRequests.add((Object)request);
            }

            public void onRequestCompleteEvent(HttpServerFilter filter, Connection connection, Response response) {
                JerseyStatisticsSource.this.openRequests.remove((Object)response.getRequest());
            }
        }});
    }
}

