/*
 * Decompiled with CFR 0.152.
 */
package fi.csc.chipster.rest;

import fi.csc.chipster.auth.model.Token;
import fi.csc.chipster.rest.JerseyStatisticsSource;
import fi.csc.chipster.rest.StatusSource;
import fi.csc.chipster.rest.hibernate.HibernateUtil;
import fi.csc.chipster.rest.hibernate.Transaction;
import java.io.File;
import java.lang.management.ManagementFactory;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import javax.annotation.security.RolesAllowed;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Selection;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.SecurityContext;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Path(value="admin")
public class AdminResource {
    public static final String PATH_STATUS = "status";
    private static Logger logger = LogManager.getLogger();
    private HibernateUtil hibernate;
    private List<Class<?>> dbTables;
    private List<StatusSource> statusSources;
    private HashMap<String, File> fileSystems = new HashMap();

    public AdminResource(HibernateUtil hibernate, List<Class<?>> dbTables, StatusSource ... stats) {
        this.hibernate = hibernate;
        this.dbTables = dbTables;
        if (stats != null) {
            this.statusSources = Arrays.asList(stats);
        }
        this.fileSystems.put("root", new File("."));
    }

    public AdminResource(HibernateUtil hibernate, Class<Token> dbTable, JerseyStatisticsSource statisticsListener) {
        this(hibernate, Arrays.asList(dbTable), statisticsListener);
    }

    public AdminResource(StatusSource ... stats) {
        this(null, new ArrayList(), stats);
    }

    @GET
    @Path(value="alive")
    @Produces(value={"application/json"})
    @Transaction
    public Response getAlive(@Context SecurityContext sc) {
        return Response.ok().build();
    }

    @GET
    @Path(value="status")
    @RolesAllowed(value={"monitoring"})
    @Produces(value={"application/json"})
    @Transaction
    public HashMap<String, Object> getStatus(@Context SecurityContext sc) {
        HashMap<String, Object> status = new HashMap<String, Object>();
        for (Class<?> table : this.dbTables) {
            long rowCount = AdminResource.getRowCount(table, this.hibernate);
            status.put(table.getSimpleName().toLowerCase() + "Count", rowCount);
        }
        if (this.statusSources != null) {
            for (StatusSource src : this.statusSources) {
                status.putAll(src.getStatus());
            }
        }
        status.putAll(this.getSystemStats());
        return status;
    }

    public static long getRowCount(Class<?> table, HibernateUtil hibernate) {
        CriteriaBuilder qb = hibernate.session().getCriteriaBuilder();
        CriteriaQuery cq = qb.createQuery(Long.class);
        cq.select((Selection)qb.count((Expression)cq.from(table)));
        return (Long)hibernate.session().createQuery(cq).getSingleResult();
    }

    public HashMap<String, Object> getSystemStats() {
        HashMap<String, Object> status = new HashMap<String, Object>();
        status.put("load", ManagementFactory.getOperatingSystemMXBean().getSystemLoadAverage());
        status.put("cores", Runtime.getRuntime().availableProcessors());
        for (String name : this.fileSystems.keySet()) {
            AdminResource.collectDiskStats(status, this.fileSystems.get(name), name);
        }
        return status;
    }

    private static void collectDiskStats(HashMap<String, Object> status, File file, String name) {
        status.put("diskTotal,fs=" + name, file.getTotalSpace());
        status.put("diskFree,fs=" + name, file.getFreeSpace());
    }

    public void addFileSystem(String name, File dir) {
        this.fileSystems.put(name, dir);
    }
}

