/*
 * Decompiled with CFR 0.152.
 */
package fi.csc.chipster.proxy;

import fi.csc.chipster.proxy.model.Connection;
import fi.csc.chipster.proxy.model.Route;
import fi.csc.chipster.proxy.model.RouteStats;
import java.time.LocalDateTime;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicLong;

public class ConnectionManager {
    private ConcurrentHashMap<Route, RouteConnections> routes = new ConcurrentHashMap();
    private ConnectionListener listener;

    public void addConnection(Connection connection) {
        this.get(connection.getRoute()).addConnection(connection);
    }

    public void removeConnection(Connection connection) {
        this.get(connection.getRoute()).removeConnection(connection);
        if (this.listener != null) {
            this.listener.connectionRemoved(connection);
        }
    }

    public void setListener(ConnectionListener listener) {
        this.listener = listener;
    }

    public List<Connection> getConnections() {
        ArrayList<Connection> all = new ArrayList<Connection>();
        for (Route route : this.routes.keySet()) {
            all.addAll(this.routes.get(route).getOpenConnections());
        }
        return all;
    }

    public List<Connection> getConnections(Route route) {
        return new ArrayList<Connection>(this.get(route).getOpenConnections());
    }

    private RouteConnections get(Route route) {
        if (!this.routes.containsKey(route)) {
            this.routes.put(route, new RouteConnections(route));
        }
        return this.routes.get(route);
    }

    public boolean hasOpenConnections(Route route) {
        return !this.getConnections(route).isEmpty();
    }

    public RouteStats getRouteStats(Route route) {
        return this.get(route).getRouteStats();
    }

    public static interface ConnectionListener {
        public void connectionRemoved(Connection var1);
    }

    public static class RouteConnections {
        private AtomicLong requestCount = new AtomicLong();
        private ConcurrentLinkedQueue<Connection> connections = new ConcurrentLinkedQueue();
        private Route route;

        public RouteConnections(Route route) {
            this.route = route;
        }

        public void addConnection(Connection connection) {
            connection.setOpenTime(LocalDateTime.now());
            this.connections.add(connection);
            this.requestCount.getAndIncrement();
        }

        public void removeConnection(Connection connection) {
            connection.setCloseTime(LocalDateTime.now());
            this.connections.removeAll(this.getOldConnections());
        }

        private ArrayList<Connection> getOpenConnections() {
            ArrayList<Connection> filtered = new ArrayList<Connection>();
            for (Connection con : this.connections) {
                if (con.getCloseTime() != null) continue;
                filtered.add(con);
            }
            return filtered;
        }

        private ArrayList<Connection> getLatestConnections() {
            ArrayList<Connection> filtered = new ArrayList<Connection>();
            for (Connection con : this.connections) {
                if (con.getCloseTime() == null || !con.getCloseTime().isAfter(LocalDateTime.now().minus(1L, ChronoUnit.SECONDS))) continue;
                filtered.add(con);
            }
            return filtered;
        }

        private ArrayList<Connection> getOldConnections() {
            ArrayList<Connection> filtered = new ArrayList<Connection>();
            for (Connection con : this.connections) {
                if (con.getCloseTime() == null || !con.getCloseTime().isBefore(LocalDateTime.now().minus(1L, ChronoUnit.SECONDS))) continue;
                filtered.add(con);
            }
            return filtered;
        }

        public RouteStats getRouteStats() {
            RouteStats stats = new RouteStats();
            stats.setRoute(this.route);
            stats.setRequestCount(this.requestCount.get());
            stats.setOpenConnectionCount(this.getOpenConnections().size());
            stats.setRequestsPerSecond(this.getLatestConnections().size());
            return stats;
        }
    }
}

