/*
 * Decompiled with CFR 0.152.
 */
package fi.csc.chipster.proxy;

import fi.csc.chipster.proxy.ProxyServer;
import fi.csc.chipster.proxy.model.Connection;
import fi.csc.chipster.proxy.model.Route;
import fi.csc.chipster.proxy.model.RouteStats;
import fi.csc.chipster.rest.AdminResource;
import fi.csc.chipster.rest.StatusSource;
import java.net.URISyntaxException;
import java.util.List;
import javax.annotation.security.RolesAllowed;
import javax.ws.rs.BadRequestException;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.SecurityContext;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Path(value="admin")
public class ChipsterProxyAdminResource
extends AdminResource {
    private static Logger logger = LogManager.getLogger();
    private ProxyServer proxy;

    public ChipsterProxyAdminResource(ProxyServer proxy) {
        super(new StatusSource[0]);
        this.proxy = proxy;
    }

    @GET
    @Produces(value={"application/json"})
    @RolesAllowed(value={"admin"})
    @Path(value="connections")
    public Response getConnections(@Context SecurityContext sc) {
        List<Connection> connections = this.proxy.getConnections();
        return Response.ok(connections).build();
    }

    @GET
    @Produces(value={"application/json"})
    @RolesAllowed(value={"admin"})
    @Path(value="routes")
    public Response getRoutes(@Context SecurityContext sc) {
        List<RouteStats> routes = this.proxy.getRouteStats();
        return Response.ok(routes).build();
    }

    @POST
    @Consumes(value={"application/json"})
    @RolesAllowed(value={"admin"})
    @Path(value="routes")
    public Response addRoute(Route route, @Context SecurityContext sc) {
        try {
            this.proxy.addRoute(route.getProxyPath(), route.getProxyTo());
        }
        catch (URISyntaxException e) {
            throw new BadRequestException("invalid URI: " + e.getMessage());
        }
        return Response.ok().build();
    }

    @DELETE
    @RolesAllowed(value={"admin"})
    @Path(value="routes/{proxyPath}")
    public Response removeRoute(@PathParam(value="proxyPath") String proxyPath, @Context SecurityContext sc) {
        this.proxy.removeRoute(proxyPath);
        return Response.ok().build();
    }
}

