/*
 * Decompiled with CFR 0.152.
 */
package fi.csc.chipster.auth.resource;

import fi.csc.chipster.auth.resource.AuthPrincipal;
import java.security.Principal;
import javax.ws.rs.core.SecurityContext;

public class AuthSecurityContext
implements SecurityContext {
    private SecurityContext originalContext;
    private AuthPrincipal principal;

    public AuthSecurityContext(AuthPrincipal principal, SecurityContext originalContext) {
        this.principal = principal;
        this.originalContext = originalContext;
    }

    public Principal getUserPrincipal() {
        return this.principal;
    }

    public boolean isUserInRole(String role) {
        return this.principal.getRoles().contains(role);
    }

    public boolean isSecure() {
        return this.originalContext.isSecure();
    }

    public String getAuthenticationScheme() {
        return this.originalContext.getAuthenticationScheme();
    }

    public void setOriginalSecurityContext(SecurityContext securityContext) {
        this.originalContext = securityContext;
    }
}

