/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.samtools.reference;

import fi.csc.microarray.client.visualisation.methods.gbrowser.runtimeIndex.ByteDataSource;
import fi.csc.microarray.client.visualisation.methods.gbrowser.runtimeIndex.LineDataSource;
import htsjdk.samtools.SAMException;
import htsjdk.samtools.reference.ChipsterFastaSequenceIndex;
import htsjdk.samtools.reference.FastaSequenceIndex;
import htsjdk.samtools.reference.FastaSequenceIndexEntry;
import htsjdk.samtools.reference.PicardIndexedFastaSequenceFile;
import htsjdk.samtools.reference.ReferenceSequence;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.LinkedList;
import java.util.List;

public class ChipsterIndexedFastaSequenceFile
extends PicardIndexedFastaSequenceFile {
    private final ByteDataSource channel;
    private final FastaSequenceIndex index;
    protected static final int BUFFER_SIZE = 1024;

    public ChipsterIndexedFastaSequenceFile(ByteDataSource file, FastaSequenceIndex index) {
        this.index = index;
        this.channel = file;
    }

    public ChipsterIndexedFastaSequenceFile(ByteDataSource data, LineDataSource index) throws FileNotFoundException {
        this(data, (FastaSequenceIndex)new ChipsterFastaSequenceIndex(index));
    }

    public List<String> getContigs() {
        LinkedList<String> contigs = new LinkedList<String>();
        for (FastaSequenceIndexEntry entry : this.index) {
            contigs.add(entry.getContig());
        }
        return contigs;
    }

    @Override
    public ReferenceSequence getSubsequenceAt(String contig, long start, long stop) {
        if (start > stop + 1L) {
            throw new SAMException(String.format("Malformed query; start point %d lies after end point %d", start, stop));
        }
        FastaSequenceIndexEntry indexEntry = this.index.getIndexEntry(contig);
        if (stop > indexEntry.getSize()) {
            throw new SAMException("Query asks for data past end of contig");
        }
        int length = (int)(stop - start + 1L);
        byte[] target = new byte[length];
        ByteBuffer targetBuffer = ByteBuffer.wrap(target);
        int basesPerLine = indexEntry.getBasesPerLine();
        int bytesPerLine = indexEntry.getBytesPerLine();
        int terminatorLength = bytesPerLine - basesPerLine;
        long startOffset = (start - 1L) / (long)basesPerLine * (long)bytesPerLine + (start - 1L) % (long)basesPerLine;
        long minBufferSize = Math.min(1024L, (long)(length / basesPerLine + 2) * (long)bytesPerLine);
        if (minBufferSize > Integer.MAX_VALUE) {
            throw new SAMException("Buffer is too large: " + minBufferSize);
        }
        ByteBuffer channelBuffer = ByteBuffer.allocate((int)minBufferSize);
        while (targetBuffer.position() < length) {
            startOffset += (long)Math.max((int)(startOffset % (long)bytesPerLine - (long)basesPerLine + 1L), 0);
            try {
                byte[] bytes = this.channel.read(indexEntry.getLocation() + startOffset, channelBuffer.remaining());
                channelBuffer.put(bytes);
                startOffset += (long)bytes.length;
            }
            catch (IOException ex) {
                throw new SAMException("Unable to load " + contig + "(" + start + ", " + stop + ") from " + this.getAbsolutePath(), (Throwable)ex);
            }
            channelBuffer.flip();
            int positionInContig = (int)start - 1 + targetBuffer.position();
            int nextBaseSpan = Math.min(basesPerLine - positionInContig % basesPerLine, length - targetBuffer.position());
            int bytesToTransfer = Math.min(nextBaseSpan, channelBuffer.capacity());
            channelBuffer.limit(channelBuffer.position() + bytesToTransfer);
            while (channelBuffer.hasRemaining()) {
                targetBuffer.put(channelBuffer);
                bytesToTransfer = Math.min(basesPerLine, length - targetBuffer.position());
                channelBuffer.limit(Math.min(channelBuffer.position() + bytesToTransfer + terminatorLength, channelBuffer.capacity()));
                channelBuffer.position(Math.min(channelBuffer.position() + terminatorLength, channelBuffer.capacity()));
            }
            channelBuffer.flip();
        }
        return new ReferenceSequence(contig, indexEntry.getSequenceIndex(), target);
    }
}

