/*
 * Decompiled with CFR 0.152.
 */
package fi.csc.microarray.util.rest;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.UUID;
import org.eclipse.jetty.util.IO;
import org.junit.Assert;

public class FileServerTest {
    private String repositoryUrl;
    private String testfile;
    boolean put = true;
    boolean get = true;

    public FileServerTest(String repositoryUrl, String testfile, int threadCount, int repeatCount, boolean put, boolean get) {
        System.out.println("Rest test with repository: " + repositoryUrl + ", threads: " + threadCount + ", repeats: " + repeatCount);
        this.repositoryUrl = repositoryUrl;
        this.testfile = testfile;
        if (!put && !get) {
            this.put = true;
            this.get = true;
        } else {
            this.put = put;
            this.get = get;
        }
        for (int i = 0; i < threadCount; ++i) {
            new Thread(new PutGetTest(repeatCount, "Thread " + i)).start();
        }
    }

    private boolean isSuccessfulCode(int responseCode) {
        return responseCode >= 200 && responseCode < 300;
    }

    class PutGetTest
    implements Runnable {
        private int repeatCount;
        private String name;

        public PutGetTest(int repeatCount, String name) {
            this.repeatCount = repeatCount;
            this.name = name;
        }

        @Override
        public void run() {
            String filename = "";
            boolean putOnce = false;
            if (FileServerTest.this.get && !FileServerTest.this.put) {
                filename = "testfile-" + UUID.randomUUID().toString();
                putOnce = true;
            }
            for (int i = 0; i < this.repeatCount; ++i) {
                try {
                    OutputStream os;
                    HttpURLConnection connection;
                    URL url;
                    if (putOnce) {
                        filename = "testfile-" + UUID.randomUUID().toString();
                        url = new URL(FileServerTest.this.repositoryUrl + "/" + filename);
                        connection = (HttpURLConnection)url.openConnection();
                        connection.setRequestMethod("PUT");
                        connection.setDoOutput(true);
                        connection.setChunkedStreamingMode(2048);
                        os = connection.getOutputStream();
                        IO.copy((InputStream)new FileInputStream(new File(FileServerTest.this.testfile)), (OutputStream)os);
                        os.close();
                        Assert.assertTrue((boolean)FileServerTest.this.isSuccessfulCode(connection.getResponseCode()));
                        putOnce = false;
                    }
                    if (FileServerTest.this.put) {
                        filename = "testfile-" + UUID.randomUUID().toString();
                        url = new URL(FileServerTest.this.repositoryUrl + "/" + filename);
                        connection = (HttpURLConnection)url.openConnection();
                        connection.setRequestMethod("PUT");
                        connection.setDoOutput(true);
                        connection.setChunkedStreamingMode(2048);
                        os = connection.getOutputStream();
                        IO.copy((InputStream)new FileInputStream(new File(FileServerTest.this.testfile)), (OutputStream)os);
                        os.close();
                        Assert.assertTrue((boolean)FileServerTest.this.isSuccessfulCode(connection.getResponseCode()));
                    }
                    if (!FileServerTest.this.get) continue;
                    url = new URL(FileServerTest.this.repositoryUrl + "/" + filename);
                    connection = (HttpURLConnection)url.openConnection();
                    InputStream is = connection.getInputStream();
                    FileOutputStream fos = new FileOutputStream(new File(filename));
                    IO.copy((InputStream)is, (OutputStream)fos);
                    is.close();
                    ((OutputStream)fos).close();
                    Assert.assertTrue((boolean)FileServerTest.this.isSuccessfulCode(connection.getResponseCode()));
                    continue;
                }
                catch (Exception e) {
                    e.printStackTrace();
                    throw new RuntimeException(e);
                }
            }
            System.out.println(this.name + " finished successfully");
        }
    }
}

