/*
 * Decompiled with CFR 0.152.
 */
package fi.csc.microarray.util;

import java.util.LinkedList;

public class Version {
    private Integer[] parts;

    private Version(Integer[] parts) {
        this.parts = parts;
    }

    public static Version parse(String version) {
        String[] strings = version.split("\\.", -1);
        LinkedList<Integer> list = new LinkedList<Integer>();
        for (String s : strings) {
            list.add(Integer.parseInt(s));
        }
        return new Version(list.toArray(new Integer[0]));
    }

    public int compareTo(Version v) {
        int minLength = this.parts.length < v.getParts().length ? this.parts.length : v.getParts().length;
        for (int i = 0; i < minLength; ++i) {
            if (this.parts[i] == v.getParts()[i]) continue;
            return this.parts[i].compareTo(v.getParts()[i]);
        }
        return Integer.compare(this.parts.length, v.getParts().length);
    }

    Integer[] getParts() {
        return this.parts;
    }

    public String toString() {
        String s = "";
        for (Integer i : this.parts) {
            s = s + i + ".";
        }
        if (s.endsWith(".")) {
            s = s.substring(0, s.length() - 1);
        }
        return s;
    }
}

