/*
 * Decompiled with CFR 0.152.
 */
package fi.csc.microarray.util;

import fi.csc.microarray.client.Session;
import java.lang.reflect.InvocationTargetException;
import javax.swing.SwingUtilities;

public class ThreadUtils {
    public static Thread getBackgroundThread(Runnable runnable) {
        Thread thread = new Thread(runnable);
        thread.setDaemon(true);
        return thread;
    }

    public static Thread getLowPriorityBackgroundThread(Runnable runnable) {
        Thread thread = ThreadUtils.getBackgroundThread(runnable);
        thread.setPriority(2);
        return thread;
    }

    public static void runInEDT(Runnable runnable) {
        if (SwingUtilities.isEventDispatchThread()) {
            runnable.run();
        } else {
            try {
                SwingUtilities.invokeAndWait(runnable);
            }
            catch (InterruptedException | InvocationTargetException e) {
                Session.getSession().getApplication().reportException(e);
            }
        }
    }
}

