/*
 * Decompiled with CFR 0.152.
 */
package fi.csc.microarray.util;

import fi.csc.microarray.constants.VisualConstants;
import java.awt.BorderLayout;
import java.awt.Color;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.LineBorder;

public class SplashScreen {
    private JFrame frame = new JFrame();
    private String lines = "";
    private int TEXT_HEIGHT = 70;
    private JLabel textLabel;
    private JPanel textPanel;

    public SplashScreen(Icon icon) {
        this.frame.setLayout(null);
        this.frame.setUndecorated(true);
        this.frame.setSize(icon.getIconWidth(), icon.getIconHeight() + this.TEXT_HEIGHT);
        this.frame.setLocationRelativeTo(null);
        this.frame.setDefaultCloseOperation(0);
        this.frame.getRootPane().setBorder(new LineBorder(VisualConstants.SPLASH_BORDER_COLOR, 1));
        JLabel imageLabel = new JLabel(icon);
        imageLabel.setSize(icon.getIconWidth(), icon.getIconHeight());
        this.frame.add(imageLabel);
        imageLabel.setLocation(0, 0);
        this.textLabel = new JLabel();
        this.textLabel.setBorder(BorderFactory.createEmptyBorder(5, 10, 5, 10));
        this.textLabel.setFont(VisualConstants.SPLASH_SCREEN_FONT);
        this.textPanel = new JPanel(new BorderLayout());
        this.textPanel.setLocation(0, icon.getIconHeight());
        this.textPanel.setSize(icon.getIconWidth(), this.TEXT_HEIGHT);
        this.textPanel.setBackground(Color.WHITE);
        this.textPanel.setOpaque(true);
        this.textPanel.setBorder(BorderFactory.createMatteBorder(1, 0, 0, 0, VisualConstants.SPLASH_BORDER_COLOR));
        this.textPanel.add(this.textLabel);
        this.frame.add(this.textPanel);
        this.frame.setVisible(true);
    }

    public void close() {
        this.frame.setVisible(false);
        this.frame.dispose();
    }

    public void write(String string) {
        this.lines = this.lines + string;
        this.updateText();
    }

    public void writeLine(String newLine) {
        this.lines = this.lines + newLine + "<br>";
        this.updateText();
    }

    private void updateText() {
        String s = "<html>";
        s = s + this.lines;
        this.textLabel.setText(s + "</html>");
    }
}

