/*
 * Decompiled with CFR 0.152.
 */
package fi.csc.microarray.util;

import fi.csc.microarray.util.Files;
import java.io.File;
import java.io.IOException;
import java.util.Calendar;
import java.util.List;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class FilesTest {
    private File testRoot;
    private File dir_1;
    private File dir_2;

    @Before
    public void setUp() throws IOException {
        this.testRoot = File.createTempFile("deltree-test-", "");
        this.testRoot.delete();
        Assert.assertTrue((boolean)this.testRoot.mkdir());
        System.out.println("created test root dir: " + this.testRoot.getAbsolutePath());
        this.dir_1 = this.createDirWithFiles(this.testRoot, "dir_1", 2);
        this.dir_2 = this.createDirWithFiles(this.testRoot, "dir_2", 3);
        Files.createSymbolicLink(new File(this.dir_1, "file1"), new File(this.dir_1, "fileLink"));
        Files.createSymbolicLink(this.dir_2, new File(this.dir_1, "dirLink"));
    }

    @After
    public void tearDown() {
        this.testRoot.delete();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testListFilesRecursivelySortByDateOldestFirst() throws IOException, InterruptedException {
        File dir = new File("testdir");
        try {
            dir.mkdir();
            File f1 = new File(dir, "f1");
            f1.createNewFile();
            File f2 = new File(dir, "f2");
            f2.createNewFile();
            File f3 = new File(dir, "f3");
            f3.createNewFile();
            Calendar c = Calendar.getInstance();
            c.add(5, 1);
            f2.setLastModified(c.getTime().getTime());
            c.add(5, -2);
            f3.setLastModified(c.getTime().getTime());
            List<File> list = Files.listFilesRecursivelySortByDateOldestFirst(dir);
            Assert.assertEquals((Object)list.get(0), (Object)f3);
            Assert.assertEquals((Object)list.get(1), (Object)f1);
            Assert.assertEquals((Object)list.get(2), (Object)f2);
            Assert.assertEquals((long)list.size(), (long)3L);
        }
        finally {
            Files.delTree(dir);
        }
    }

    @Test
    public void testDelTree() throws IOException {
        File dir = new File(this.testRoot, "dir");
        dir.mkdir();
        Assert.assertTrue((boolean)Files.delTree(dir));
        Assert.assertFalse((boolean)dir.exists());
        File file = new File(this.testRoot, "file");
        file.createNewFile();
        Assert.assertTrue((boolean)Files.delTree(file));
        Assert.assertFalse((boolean)file.exists());
        Assert.assertTrue((boolean)Files.delTree(this.dir_1));
        Assert.assertFalse((boolean)this.dir_1.exists());
        Assert.assertTrue((boolean)Files.delTree(this.dir_2));
        Assert.assertFalse((boolean)this.dir_2.exists());
    }

    private File createDirWithFiles(File parentDir, String dirName, int depth) throws IOException {
        File dir = new File(parentDir, dirName);
        dir.mkdir();
        File file_1 = new File(dir, "file_1");
        file_1.createNewFile();
        File file_2 = new File(dir, "file_2");
        file_2.createNewFile();
        if (depth > 0) {
            this.createDirWithFiles(dir, "dir", --depth);
        }
        return dir;
    }

    public static void main(String[] args) throws IOException, InterruptedException {
        new FilesTest().testListFilesRecursivelySortByDateOldestFirst();
    }
}

