/*
 * Decompiled with CFR 0.152.
 */
package fi.csc.microarray.util;

import fi.csc.microarray.exception.MicroarrayException;
import java.io.IOException;
import javax.net.ssl.SSLHandshakeException;

public class Exceptions {
    public static String getStackTrace(Throwable throwable) {
        String trace = throwable.getClass().getSimpleName();
        if (throwable.getMessage() != null) {
            trace = trace + ": " + throwable.getMessage();
        }
        trace = trace + "\n";
        trace = trace + Exceptions.getStackTrace(throwable.getStackTrace());
        if (throwable.getCause() != null) {
            trace = trace + "Caused by: ";
            trace = trace + Exceptions.getStackTrace(throwable.getCause());
        }
        return trace;
    }

    public static String getStackTrace(StackTraceElement[] stackTrace) {
        String trace = "";
        for (StackTraceElement element : stackTrace) {
            trace = trace + element.toString() + "\n";
        }
        return trace;
    }

    public static boolean isCausedBy(Throwable exception, Object type) {
        if (type.getClass().isInstance(exception)) {
            return true;
        }
        Throwable e = exception;
        while (e.getCause() != null) {
            e = e.getCause();
            if (!type.getClass().isInstance(e)) continue;
            return true;
        }
        return false;
    }

    public static void main(String[] args) throws InstantiationException, IllegalAccessException {
        System.out.println(Exceptions.isCausedBy(new MicroarrayException(new Exception()), new SSLHandshakeException("")));
        System.out.println(Exceptions.isCausedBy(new MicroarrayException(new SSLHandshakeException("")), new SSLHandshakeException("")));
        System.out.println(Exceptions.isCausedBy(new MicroarrayException(""), new SSLHandshakeException("")));
        System.out.println(Exceptions.isCausedBy(new SSLHandshakeException(""), new IOException("")));
    }
}

