/*
 * Decompiled with CFR 0.152.
 */
package fi.csc.microarray.messaging.message;

import com.google.gson.Gson;
import com.google.gson.JsonObject;
import fi.csc.microarray.messaging.message.ChipsterMessage;
import java.util.HashMap;
import javax.jms.JMSException;
import javax.jms.MapMessage;

public class JsonMessage
extends ChipsterMessage {
    private static final String KEY_JSON = "json";
    public static final String KEY_STATUS_REPORT = "status-report";
    private String value;

    public JsonMessage() {
    }

    public JsonMessage(String value) {
        this.value = value;
    }

    public String getJson() {
        return this.value;
    }

    @Override
    public void unmarshal(MapMessage from) throws JMSException {
        super.unmarshal(from);
        this.value = from.getString(KEY_JSON);
    }

    @Override
    public void marshal(MapMessage mapMessage) throws JMSException {
        super.marshal(mapMessage);
        mapMessage.setString(KEY_JSON, this.value);
    }

    public void setCommnad(String command) {
        HashMap<String, String> jsonMap = new HashMap<String, String>();
        jsonMap.put("command", command);
        this.value = new Gson().toJson(jsonMap);
    }

    public String getValue(String key) {
        JsonObject jobj = (JsonObject)new Gson().fromJson(this.value, JsonObject.class);
        return jobj.get(key).toString();
    }
}

