/*
 * Decompiled with CFR 0.152.
 */
package fi.csc.microarray.messaging.message;

import fi.csc.microarray.messaging.message.ParameterMessage;
import fi.csc.microarray.util.Strings;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import javax.jms.JMSException;
import javax.jms.MapMessage;
import org.apache.log4j.Logger;

public class FeedbackMessage
extends ParameterMessage {
    private static final Logger logger = Logger.getLogger(FeedbackMessage.class);
    private static final String KEY_DETAILS = "details";
    private static final String KEY_EMAIL = "email";
    private static final String KEY_SESSION = "session-url";
    private static final String KEY_LOGS = "logs";
    private String details;
    private String email;
    private String url;
    private List<String> logs = new LinkedList<String>();

    public FeedbackMessage() {
    }

    public FeedbackMessage(String details, String email, String url) {
        this.details = details;
        this.email = email;
        this.url = url;
    }

    @Override
    public void unmarshal(MapMessage from) throws JMSException {
        super.unmarshal(from);
        this.details = from.getString(KEY_DETAILS);
        this.email = from.getString(KEY_EMAIL);
        this.url = from.getString(KEY_SESSION);
        this.logs = Arrays.asList(!from.getString(KEY_LOGS).equals("") ? from.getString(KEY_LOGS).split(";") : new String[]{});
        logger.debug((Object)("Unmarshalled details : " + this.details));
        logger.debug((Object)("Unmarshalled email : " + this.email));
        logger.debug((Object)("Unmarshalled session-url : " + this.url));
        logger.debug((Object)("Unmarshalled logs : " + this.logs));
    }

    @Override
    public void marshal(MapMessage to) throws JMSException {
        super.marshal(to);
        String marshalledLog = Strings.delimit(this.logs, ";");
        logger.debug((Object)("Marshalling: details : " + this.details));
        logger.debug((Object)("Marshalling: email : " + this.email));
        logger.debug((Object)("Marshalling: session-url : " + this.url));
        logger.debug((Object)("Marshalling: logs : " + marshalledLog));
        to.setString(KEY_DETAILS, this.details);
        to.setString(KEY_EMAIL, this.email);
        to.setString(KEY_SESSION, this.url);
        to.setString(KEY_LOGS, marshalledLog);
    }

    public void addLog(String name, String url) {
        this.logs.add(name + "," + url);
    }

    public String getDetails() {
        return this.details;
    }

    public String getEmail() {
        return this.email;
    }

    public String getSessionURL() {
        return this.url;
    }

    public List<String[]> getLogs() {
        LinkedList<String[]> logsArrayed = new LinkedList<String[]>();
        for (String log : this.logs) {
            logsArrayed.add(log.split(","));
        }
        return logsArrayed;
    }
}

