/*
 * Decompiled with CFR 0.152.
 */
package fi.csc.microarray.messaging;

import fi.csc.microarray.DemoAuthenticationRequestListener;
import fi.csc.microarray.config.DirectoryLayout;
import fi.csc.microarray.messaging.JMSMessagingEndpoint;
import fi.csc.microarray.messaging.MessagingEndpoint;
import fi.csc.microarray.messaging.NodeBase;
import fi.csc.microarray.messaging.auth.SimpleAuthenticationRequestListener;
import fi.csc.microarray.util.Exceptions;
import java.util.Arrays;
import org.apache.log4j.Logger;
import org.junit.After;
import org.junit.Before;

public abstract class MessagingTestBase {
    private static Logger logger;
    protected MessagingEndpoint endpoint;
    protected SimpleAuthenticationRequestListener authenticationListener;
    private String configURL;
    private String username;
    private String password;

    public MessagingTestBase() {
    }

    public MessagingTestBase(String username, String password) {
        this.username = username;
        this.password = password;
    }

    public MessagingTestBase(String username, String password, String configURL) {
        this.configURL = configURL;
        this.username = username;
        this.password = password;
    }

    @Before
    public void setUp() throws Exception {
        System.out.println("setting up authentication listener");
        this.authenticationListener = this.username == null || this.password == null ? new DemoAuthenticationRequestListener() : new SimpleAuthenticationRequestListener(this.username, this.password);
        System.out.println("initialising client");
        DirectoryLayout.uninitialise();
        if (this.configURL == null) {
            DirectoryLayout.initialiseServerLayout(Arrays.asList("client"));
        } else {
            try {
                DirectoryLayout.initialiseClientLayout(this.configURL);
            }
            catch (IllegalStateException illegalStateException) {
                // empty catch block
            }
        }
        System.out.println("setting up messaging");
        logger = Logger.getLogger(MessagingTestBase.class);
        logger.debug((Object)"loaded config");
        this.endpoint = new JMSMessagingEndpoint(new NodeBase(){

            @Override
            public String getName() {
                return "test";
            }
        });
        System.out.println("endpoint created");
        this.endpoint.setAuthenticationListener(this.authenticationListener);
    }

    @After
    public void tearDown() {
        if (this.endpoint != null) {
            System.out.println("closing messaging endpoint");
            try {
                this.endpoint.close();
            }
            catch (Exception e) {
                System.out.println("got exception when closing messaging endpoint");
                System.out.println(Exceptions.getStackTrace(e));
            }
            this.endpoint = null;
        }
    }
}

