/*
 * Decompiled with CFR 0.152.
 */
package fi.csc.microarray.messaging;

import fi.csc.microarray.messaging.MessagingListener;
import fi.csc.microarray.messaging.message.ChipsterMessage;
import fi.csc.microarray.util.Exceptions;
import javax.jms.JMSException;
import javax.jms.MapMessage;
import javax.jms.Message;
import javax.jms.MessageListener;
import org.apache.log4j.Logger;

public class MessageListenerWrapper
implements MessageListener {
    private static final Logger logger = Logger.getLogger(MessageListenerWrapper.class);
    private MessagingListener actualListener;

    public MessageListenerWrapper(MessagingListener listener) {
        this.actualListener = listener;
    }

    public void onMessage(Message msg) {
        block6: {
            String msgClass = "";
            MapMessage mapMessage = null;
            try {
                msgClass = msg.getStringProperty("class");
                logger.debug((Object)("message received, class is " + msgClass));
                mapMessage = (MapMessage)msg;
                ChipsterMessage chipsterMessage = (ChipsterMessage)Class.forName(msgClass).newInstance();
                chipsterMessage.unmarshal(mapMessage);
                this.actualListener.onChipsterMessage(chipsterMessage);
            }
            catch (Exception e) {
                logger.error((Object)"Exception when handling a message.", (Throwable)e);
                logger.error((Object)("message class was: " + msgClass));
                if (mapMessage == null) break block6;
                try {
                    String name;
                    logger.error((Object)"message first property:");
                    if (mapMessage.getPropertyNames().hasMoreElements()) {
                        name = (String)mapMessage.getPropertyNames().nextElement();
                        logger.error((Object)(name + " : " + mapMessage.getStringProperty(name)));
                    }
                    logger.error((Object)"message first map object:");
                    if (mapMessage.getMapNames().hasMoreElements()) {
                        name = (String)mapMessage.getMapNames().nextElement();
                        logger.error((Object)(name + " : " + mapMessage.getString(name)));
                    }
                    logger.error((Object)("message JMSType: " + mapMessage.getJMSType()));
                    logger.error((Object)("message JMSMessageID: " + mapMessage.getJMSMessageID()));
                    logger.error((Object)("message JMSDestination: " + mapMessage.getJMSDestination()));
                }
                catch (JMSException e1) {
                    logger.error((Object)Exceptions.getStackTrace(e1));
                }
            }
        }
    }
}

