/*
 * Decompiled with CFR 0.152.
 */
package fi.csc.microarray.gbrowser.intervals;

import fi.csc.microarray.client.visualisation.methods.gbrowser.message.Chromosome;
import fi.csc.microarray.client.visualisation.methods.gbrowser.message.DataType;
import fi.csc.microarray.client.visualisation.methods.gbrowser.message.Feature;
import fi.csc.microarray.client.visualisation.methods.gbrowser.message.Region;
import fi.csc.microarray.client.visualisation.methods.gbrowser.message.Strand;
import fi.csc.microarray.client.visualisation.methods.gbrowser.util.RegionOperations;
import java.io.ByteArrayOutputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import org.junit.Assert;
import org.junit.Test;

public class RegionOperationsTest {
    @Test
    public void testSort() throws FileNotFoundException, IOException {
        RegionOperations tool = new RegionOperations();
        LinkedList<Feature> rows = new LinkedList<Feature>();
        rows.add(new Feature(new Region(210L, 600L, new Chromosome("1")), RegionOperations.getEmptyExtraFieldMap()));
        rows.add(new Feature(new Region(300L, 350L, new Chromosome("2")), RegionOperations.getEmptyExtraFieldMap()));
        rows.add(new Feature(new Region(100L, 200L, new Chromosome("2")), RegionOperations.getEmptyExtraFieldMap()));
        rows.add(new Feature(new Region(100L, 200L, new Chromosome("1")), RegionOperations.getEmptyExtraFieldMap()));
        LinkedList<Feature> sortedRows = new LinkedList<Feature>();
        sortedRows.add(new Feature(new Region(100L, 200L, new Chromosome("1")), RegionOperations.getEmptyExtraFieldMap()));
        sortedRows.add(new Feature(new Region(210L, 600L, new Chromosome("1")), RegionOperations.getEmptyExtraFieldMap()));
        sortedRows.add(new Feature(new Region(100L, 200L, new Chromosome("2")), RegionOperations.getEmptyExtraFieldMap()));
        sortedRows.add(new Feature(new Region(300L, 350L, new Chromosome("2")), RegionOperations.getEmptyExtraFieldMap()));
        tool.sort(rows);
        Assert.assertEquals(rows, sortedRows);
    }

    @Test
    public void test() throws FileNotFoundException, IOException {
        RegionOperations tool = new RegionOperations();
        String fileContents = "chr1\t100\t200\tcloneA\t960\t+\t1000\t5000\t0\t2\t567,488\t0,3512\nchr1\t210\t300\tcloneA\t960\t+\t1000\t5000\t0\t2\t567,488\t0,3512\nchr1\t400\t500\tcloneA\t960\t+\t1000\t5000\t0\t2\t567,488\t0,3512\nchr2\t100\t200\tcloneA\t960\t+\t1000\t5000\t0\t2\t567,488\t0,3512\n";
        String fileContentsWithHeader = "track name=pairedReads description=\"Clone Paired Reads\" useScore=1\n" + fileContents;
        LinkedList<Feature> rows1 = new LinkedList<Feature>();
        for (String line : fileContentsWithHeader.split("\n")) {
            Feature region = tool.parseString(line);
            if (region == null) continue;
            rows1.add(region);
        }
        Assert.assertEquals((long)rows1.size(), (long)4L);
        Assert.assertEquals((Object)((Feature)rows1.get((int)0)).values.get((Object)DataType.STRAND), (Object)"+");
        Assert.assertEquals((Object)((Feature)rows1.get((int)0)).values.get((Object)DataType.ID), (Object)"cloneA");
        Assert.assertEquals((Object)((Feature)rows1.get((int)0)).region.start.chr, (Object)new Chromosome("chr1.fa"));
        Assert.assertEquals((Object)((Feature)rows1.get((int)0)).region.start.chr, (Object)new Chromosome("chr1"));
        Assert.assertEquals((Object)((Feature)rows1.get((int)0)).region.start.chr, (Object)new Chromosome("1"));
        LinkedList<Feature> rowsNoHeader = new LinkedList<Feature>();
        for (String line : fileContents.split("\n")) {
            Feature region = tool.parseString(line);
            if (region == null) continue;
            rowsNoHeader.add(region);
        }
        Assert.assertEquals(rowsNoHeader, rows1);
        String normalisedFileContents = fileContents.replace("chr", "");
        ByteArrayOutputStream stringOut = new ByteArrayOutputStream();
        tool.print(rows1, stringOut);
        Assert.assertEquals((Object)((Object)stringOut).toString(), (Object)normalisedFileContents);
        LinkedList<Feature> rows2 = new LinkedList<Feature>();
        rows2.add(new Feature(new Region(100L, 150L, new Chromosome("1")), RegionOperations.getEmptyExtraFieldMap()));
        rows2.add(new Feature(new Region(250L, 600L, new Chromosome("1")), RegionOperations.getEmptyExtraFieldMap()));
        rows2.add(new Feature(new Region(300L, 350L, new Chromosome("2")), RegionOperations.getEmptyExtraFieldMap()));
        LinkedList<Feature> expectedIntersection = new LinkedList<Feature>();
        expectedIntersection.add(new Feature(new Region(100L, 150L, new Chromosome("1")), RegionOperations.getEmptyExtraFieldMap()));
        expectedIntersection.add(new Feature(new Region(250L, 300L, new Chromosome("1")), RegionOperations.getEmptyExtraFieldMap()));
        expectedIntersection.add(new Feature(new Region(400L, 500L, new Chromosome("1")), RegionOperations.getEmptyExtraFieldMap()));
        Assert.assertEquals(tool.intersect(rows1, rows2, 1L, RegionOperations.INTERSECT_PAIR_POLICY, true), expectedIntersection);
        expectedIntersection.remove();
        Assert.assertNotSame(tool.merge(rows1, rows2, 1L, true), expectedIntersection);
        LinkedList<Feature> expectedIntersection2 = new LinkedList<Feature>();
        LinkedHashMap<DataType, Object> values = new LinkedHashMap<DataType, Object>();
        values.put(DataType.ID, "cloneA");
        values.put(DataType.VALUE, 960L);
        values.put(DataType.STRAND, (Object)Strand.FORWARD);
        values.put(DataType.THICK_START, "1000");
        values.put(DataType.THICK_END, "5000");
        values.put(DataType.ITEM_RGB, "0");
        values.put(DataType.BLOCK_COUNT, "2");
        values.put(DataType.BLOCK_SIZES, "567,488");
        values.put(DataType.BLOCK_STARTS, "0,3512");
        expectedIntersection2.add(new Feature(new Region(100L, 200L, new Chromosome("1")), values));
        expectedIntersection2.add(new Feature(new Region(100L, 150L, new Chromosome("1")), RegionOperations.getEmptyExtraFieldMap()));
        expectedIntersection2.add(new Feature(new Region(210L, 300L, new Chromosome("1")), values));
        expectedIntersection2.add(new Feature(new Region(250L, 600L, new Chromosome("1")), RegionOperations.getEmptyExtraFieldMap()));
        expectedIntersection2.add(new Feature(new Region(400L, 500L, new Chromosome("1")), values));
        expectedIntersection2.add(new Feature(new Region(250L, 600L, new Chromosome("1")), RegionOperations.getEmptyExtraFieldMap()));
        Assert.assertEquals(tool.intersect(rows1, rows2, 1L, RegionOperations.ORIGINALS_PAIR_POLICY, false), expectedIntersection2);
        expectedIntersection2.remove();
        Assert.assertNotSame(tool.merge(rows1, rows2, 1L, true), expectedIntersection2);
        LinkedList<Feature> expectedSubtraction = new LinkedList<Feature>();
        expectedSubtraction.add(new Feature(new Region(100L, 200L, new Chromosome("2")), RegionOperations.getEmptyExtraFieldMap()));
        Assert.assertEquals(tool.subtract(rows1, rows2, 1L), expectedSubtraction);
        expectedSubtraction.remove();
        Assert.assertNotSame(tool.merge(rows1, rows2, 1L, true), expectedSubtraction);
        LinkedList<Feature> expectedMerge = new LinkedList<Feature>();
        expectedMerge.add(new Feature(new Region(100L, 200L, new Chromosome("1")), RegionOperations.getEmptyExtraFieldMap()));
        expectedMerge.add(new Feature(new Region(210L, 600L, new Chromosome("1")), RegionOperations.getEmptyExtraFieldMap()));
        expectedMerge.add(new Feature(new Region(100L, 200L, new Chromosome("2")), RegionOperations.getEmptyExtraFieldMap()));
        expectedMerge.add(new Feature(new Region(300L, 350L, new Chromosome("2")), RegionOperations.getEmptyExtraFieldMap()));
        Assert.assertEquals(tool.merge(rows1, rows2, 1L, true), expectedMerge);
        expectedMerge.remove();
        Assert.assertNotSame(tool.merge(rows1, rows2, 1L, true), expectedMerge);
        LinkedList<Feature> expectedSubtractionWithLongOverlap = new LinkedList<Feature>();
        expectedSubtractionWithLongOverlap.add(new Feature(new Region(100L, 200L, new Chromosome("1")), RegionOperations.getEmptyExtraFieldMap()));
        expectedSubtractionWithLongOverlap.add(new Feature(new Region(210L, 300L, new Chromosome("1")), RegionOperations.getEmptyExtraFieldMap()));
        expectedSubtractionWithLongOverlap.add(new Feature(new Region(100L, 200L, new Chromosome("2")), RegionOperations.getEmptyExtraFieldMap()));
        Assert.assertEquals(tool.subtract(rows1, rows2, 51L), expectedSubtractionWithLongOverlap);
        expectedSubtractionWithLongOverlap.remove();
        Assert.assertNotSame(tool.merge(rows1, rows2, 51L, true), expectedSubtractionWithLongOverlap);
    }

    public static void main(String[] args) throws Exception {
        new RegionOperationsTest().test();
        new RegionOperationsTest().testSort();
        System.out.println("OK");
    }
}

