/*
 * Decompiled with CFR 0.152.
 */
package fi.csc.microarray.filebroker;

import fi.csc.microarray.util.Files;
import java.io.File;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import org.apache.commons.io.FileUtils;
import org.apache.log4j.Logger;

public class DiskCleanUp {
    private static Logger logger = Logger.getLogger(DiskCleanUp.class);
    private File root;
    private int cleanUpTriggerLimitPercentage;
    private int cleanUpTargetPercentage;
    private int cleanUpMinimumFileAge;
    private long minimumSpaceForAcceptUpload;
    private final ExecutorService executor = Executors.newSingleThreadExecutor();
    private Future<?> lastCleanUp;
    private Object lastCleanUpLock = new Object();

    public DiskCleanUp(File root, int cleanUpTriggerLimitPercentage, int cleanUpTargetPercentage, int cleanUpMinimumFileAge, long minimumSpaceForAcceptUpload) {
        this.root = root;
        this.cleanUpTriggerLimitPercentage = cleanUpTriggerLimitPercentage;
        this.cleanUpTargetPercentage = cleanUpTargetPercentage;
        this.cleanUpMinimumFileAge = cleanUpMinimumFileAge;
        this.minimumSpaceForAcceptUpload = minimumSpaceForAcceptUpload;
        logger.info((Object)("total space: " + FileUtils.byteCountToDisplaySize((long)root.getTotalSpace())));
        logger.info((Object)("usable space: " + FileUtils.byteCountToDisplaySize((long)root.getUsableSpace())));
        logger.info((Object)("minimum space for accepted upload: " + FileUtils.byteCountToDisplaySize((long)minimumSpaceForAcceptUpload)));
        logger.info((Object)("cache clean up will start when usable space is less than: " + FileUtils.byteCountToDisplaySize((long)this.getCleanUpSoftLimit())));
        logger.info((Object)("cache clean target usable space is:  " + FileUtils.byteCountToDisplaySize((long)this.getCleanUpTargetUsableSpace())));
        logger.info((Object)("will not clean up files newer than: " + cleanUpMinimumFileAge / 3600 + "h"));
    }

    public long getCleanUpSoftLimit() {
        long usableSpaceSoftLimit = (long)((double)this.root.getTotalSpace() * (double)(100 - this.cleanUpTriggerLimitPercentage) / 100.0);
        return usableSpaceSoftLimit;
    }

    public long getCleanUpTargetUsableSpace() {
        return (long)((double)this.root.getTotalSpace() * (double)(100 - this.cleanUpTargetPercentage) / 100.0);
    }

    public void scheduleCleanUp(long requestedSize) {
        try {
            this.runIfNotAlreadyRunning(new CleanUpRunnable(requestedSize), false);
        }
        catch (InterruptedException | ExecutionException e) {
            logger.warn((Object)"exception while cleaning cache", (Throwable)e);
        }
    }

    public void cleanUpAndWait(long requestedSize) {
        try {
            this.runIfNotAlreadyRunning(new CleanUpRunnable(requestedSize), true);
        }
        catch (InterruptedException | ExecutionException e) {
            logger.warn((Object)"exception while cleaning cache", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runIfNotAlreadyRunning(Runnable runnable, boolean wait) throws ExecutionException, InterruptedException {
        Future<?> cleanUp = null;
        Object object = this.lastCleanUpLock;
        synchronized (object) {
            if (this.lastCleanUp == null || this.lastCleanUp.isDone()) {
                this.lastCleanUp = this.executor.submit(runnable);
            } else {
                logger.info((Object)"cache cleanup already running, skipping this one");
            }
            cleanUp = this.lastCleanUp;
        }
        if (wait) {
            cleanUp.get();
        }
    }

    public boolean spaceRequest(long requestedSize, boolean allowWait, String info) {
        boolean spaceAvailable;
        if (this.root.getUsableSpace() - requestedSize > this.getCleanUpSoftLimit()) {
            logger.debug((Object)"enough space available, no need to do anything");
            spaceAvailable = true;
        } else if (this.isEnoughSpace(requestedSize)) {
            if (info == null) {
                logger.info((Object)("space request: " + FileUtils.byteCountToDisplaySize((long)requestedSize) + ", usable: " + FileUtils.byteCountToDisplaySize((long)this.root.getUsableSpace()) + ", usable space soft limit: " + FileUtils.byteCountToDisplaySize((long)this.getCleanUpSoftLimit()) + " will be reached --> scheduling clean up"));
            } else {
                logger.info((Object)info);
            }
            this.scheduleCleanUp(requestedSize);
            spaceAvailable = true;
        } else if (this.root.getTotalSpace() - this.minimumSpaceForAcceptUpload > requestedSize) {
            logger.info((Object)("space request: " + FileUtils.byteCountToDisplaySize((long)requestedSize) + " usable: " + FileUtils.byteCountToDisplaySize((long)this.root.getUsableSpace()) + " minimum usable after upload: " + FileUtils.byteCountToDisplaySize((long)this.root.getUsableSpace()) + " clean up target: " + FileUtils.byteCountToDisplaySize((long)this.getCleanUpTargetUsableSpace()) + ", not enough space yet --> wait for clean up"));
            if (allowWait) {
                this.cleanUpAndWait(requestedSize);
            } else {
                this.scheduleCleanUp(requestedSize);
                logger.info((Object)"waiting isn't allowed");
            }
            if (this.isEnoughSpace(requestedSize)) {
                logger.info((Object)("Enough space after cleaning. Space request: " + FileUtils.byteCountToDisplaySize((long)requestedSize) + " usable: " + FileUtils.byteCountToDisplaySize((long)this.root.getUsableSpace()) + " minimum usable after upload: " + FileUtils.byteCountToDisplaySize((long)this.root.getUsableSpace())));
                spaceAvailable = true;
            } else {
                logger.info((Object)("Not enough space after cleaning. Space request: " + FileUtils.byteCountToDisplaySize((long)requestedSize) + " usable: " + FileUtils.byteCountToDisplaySize((long)this.root.getUsableSpace()) + " minimum usable after upload: " + FileUtils.byteCountToDisplaySize((long)this.root.getUsableSpace())));
                spaceAvailable = false;
            }
        } else {
            logger.info((Object)("space request: " + FileUtils.byteCountToDisplaySize((long)requestedSize) + ", usable: " + FileUtils.byteCountToDisplaySize((long)this.root.getUsableSpace()) + ", maximum space: " + FileUtils.byteCountToDisplaySize((long)this.root.getTotalSpace()) + ", minimum usable: " + FileUtils.byteCountToDisplaySize((long)this.minimumSpaceForAcceptUpload) + " --> not possible to make enough space"));
            spaceAvailable = false;
        }
        return spaceAvailable;
    }

    private boolean isEnoughSpace(long requestedSize) {
        return this.root.getUsableSpace() - requestedSize > this.minimumSpaceForAcceptUpload;
    }

    public class CleanUpRunnable
    implements Runnable {
        private long requestedSize;

        public CleanUpRunnable(long requestedSize) {
            this.requestedSize = requestedSize;
        }

        @Override
        public void run() {
            long cleanUpBeginTime = System.currentTimeMillis();
            long cleanUpTargetLimit = DiskCleanUp.this.getCleanUpTargetUsableSpace();
            logger.info((Object)("cache cleanup, target usable space: " + FileUtils.byteCountToDisplaySize((long)(this.requestedSize + cleanUpTargetLimit)) + " (" + FileUtils.byteCountToDisplaySize((long)this.requestedSize) + " + " + FileUtils.byteCountToDisplaySize((long)cleanUpTargetLimit)));
            Files.makeSpaceInDirectory(DiskCleanUp.this.root, this.requestedSize + cleanUpTargetLimit, DiskCleanUp.this.cleanUpMinimumFileAge, TimeUnit.SECONDS);
            logger.info((Object)("cache cleanup took " + (System.currentTimeMillis() - cleanUpBeginTime) + " ms, usable space now " + FileUtils.byteCountToDisplaySize((long)DiskCleanUp.this.root.getUsableSpace())));
        }
    }
}

