/*
 * Decompiled with CFR 0.152.
 */
package fi.csc.microarray.filebroker;

import fi.csc.microarray.filebroker.ChecksumException;
import fi.csc.microarray.filebroker.ChecksumInputStream;
import fi.csc.microarray.util.IOUtils;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URLConnection;
import java.util.Random;
import javax.xml.bind.DatatypeConverter;
import org.junit.Assert;
import org.junit.Test;

public class ChecksumInputStreamTest {
    String[][] examples = new String[][]{{"9E204EB216C2ECBAE690BFFB004E81B2CAA7DB42D6E5773D6C026ABAB65025900614B5A65C56BC0BE08D0D21ABA34D7381A0", "32c027190a78f0fb2ae6819b77cc2864"}, {"31DB475415008A0D5DF7335E81594F7015E2D546AEEFAC67308C04C068D01325371712A717D83252151780C6692688BA8B4A", "00fdcd1c90cf409169750ea88ad22899"}, {"C15E04809BF8DBC09395EB7C42CF80B0C99F8B50CFD4426D35FE32398CEF94B009F7C52DC7F4BF9B51EAE7ECB05957115BF1", "04cc1d49414deeb72cbe182cc412de25"}};

    @Test
    public void test() throws IOException, ChecksumException {
        for (String[] example : this.examples) {
            byte[] data = DatatypeConverter.parseHexBinary((String)example[0]);
            String md5 = this.testCalculation(data);
            Assert.assertEquals((Object)example[1], (Object)md5);
            this.testVerification(data, example[1]);
            Assert.assertEquals((Object)example[1], (Object)md5);
            try {
                this.testVerification(data, "wrong-md5");
                Assert.fail();
            }
            catch (ChecksumException checksumException) {
                // empty catch block
            }
        }
    }

    private String testCalculation(byte[] data) throws IOException {
        ChecksumInputStream stream = this.preprocess(data, null);
        String md5 = stream.getChecksum();
        this.postprocess(stream);
        return md5;
    }

    private String testVerification(byte[] data, String exampleMd5) throws IOException, ChecksumException {
        ChecksumInputStream stream = this.preprocess(data, new TestURLConnection(exampleMd5));
        String md5 = stream.verifyChecksums();
        this.postprocess(stream);
        return md5;
    }

    private void postprocess(ChecksumInputStream stream) throws IOException {
        try {
            stream.read();
            Assert.fail();
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        try {
            stream.read(new byte[10], 0, 10);
            Assert.fail();
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        try {
            stream.getChecksum();
            Assert.fail();
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    private ChecksumInputStream preprocess(byte[] data, URLConnection connection) throws IOException {
        ByteArrayInputStream baseStream = new ByteArrayInputStream(data);
        ChecksumInputStream stream = new ChecksumInputStream(baseStream, true, connection);
        Assert.assertEquals((long)baseStream.available(), (long)stream.available());
        byte[] streamBytes = new byte[data.length];
        for (int i = 0; i < data.length; ++i) {
            streamBytes[i] = (byte)stream.read();
        }
        Assert.assertEquals((Object)DatatypeConverter.printHexBinary((byte[])data), (Object)DatatypeConverter.printHexBinary((byte[])streamBytes));
        Assert.assertEquals((long)baseStream.available(), (long)stream.available());
        stream.close();
        return stream;
    }

    public static void main(String[] args) throws IOException, InterruptedException {
        Random rand = new Random();
        byte[] data = new byte[0x6400000];
        rand.nextBytes(data);
        ByteArrayInputStream baseStream = null;
        ChecksumInputStream inStream = null;
        ByteArrayOutputStream outStream = null;
        baseStream = new ByteArrayInputStream(data);
        outStream = new ByteArrayOutputStream(data.length);
        ChecksumInputStreamTest.measure("Base stream", data.length, baseStream, outStream);
        baseStream = null;
        inStream = null;
        outStream = null;
        System.gc();
        Thread.sleep(1000L);
        baseStream = new ByteArrayInputStream(data);
        inStream = new ChecksumInputStream((InputStream)baseStream, false);
        outStream = new ByteArrayOutputStream(data.length);
        ChecksumInputStreamTest.measure("Checksum disabled", data.length, inStream, outStream);
        baseStream = null;
        inStream = null;
        outStream = null;
        System.gc();
        Thread.sleep(1000L);
        baseStream = new ByteArrayInputStream(data);
        inStream = new ChecksumInputStream((InputStream)baseStream, true);
        outStream = new ByteArrayOutputStream(data.length);
        ChecksumInputStreamTest.measure("Checksum enabled", data.length, inStream, outStream);
    }

    private static void measure(String message, long bytes, InputStream in, OutputStream out) throws IOException {
        long t = System.currentTimeMillis();
        IOUtils.copy(in, out);
        long dt = System.currentTimeMillis() - t;
        in.close();
        out.close();
        System.out.println(message + ": \t" + dt + " ms, \t" + (float)(bytes / 1024L / 1024L) / ((float)dt / 1000.0f) + " MB/s");
    }

    public static class TestURLConnection
    extends URLConnection {
        private String md5;

        public TestURLConnection(String md5) {
            super(null);
            this.md5 = md5;
        }

        @Override
        public void connect() throws IOException {
        }

        @Override
        public String getHeaderField(String name) {
            Assert.assertEquals((Object)"Etag", (Object)name);
            return this.md5;
        }
    }
}

