/*
 * Decompiled with CFR 0.152.
 */
package fi.csc.microarray.databeans.handlers;

import de.schlichtherle.truezip.zip.ZipEntry;
import de.schlichtherle.truezip.zip.ZipFile;
import fi.csc.microarray.databeans.DataManager;
import fi.csc.microarray.databeans.handlers.ContentHandler;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;

public class ZipContentHandler
implements ContentHandler {
    private static final Logger logger = Logger.getLogger(ZipContentHandler.class);
    private Map<File, ZipFile> zipFileInstances = new HashMap<File, ZipFile>();

    @Override
    public Long getContentLength(DataManager.ContentLocation location) throws IOException {
        this.checkCompatibility(location);
        ZipFile zipFile = this.createZipFile(location);
        ZipEntry zipEntry = zipFile.getEntry(location.getUrl().getRef());
        return zipEntry.getSize();
    }

    @Override
    public InputStream getInputStream(DataManager.ContentLocation location) throws IOException {
        this.checkCompatibility(location);
        ZipFile zipFile = this.createZipFile(location);
        ZipEntry zipEntry = zipFile.getEntry(location.getUrl().getRef());
        return zipFile.getInputStream(zipEntry);
    }

    private ZipFile createZipFile(DataManager.ContentLocation location) throws IOException {
        File file = this.getZipFile(location);
        if (!this.zipFileInstances.containsKey(file)) {
            this.zipFileInstances.put(file, new ZipFile(file));
        }
        return this.zipFileInstances.get(file);
    }

    public void closeZipFiles() {
        for (ZipFile zipFile : this.zipFileInstances.values()) {
            try {
                zipFile.close();
            }
            catch (Exception e) {
                logger.warn((Object)"could not close zip file");
            }
        }
        this.zipFileInstances.clear();
    }

    @Override
    public void checkCompatibility(DataManager.ContentLocation location) throws IllegalArgumentException {
        URL url = location.getUrl();
        if (url == null) {
            throw new IllegalArgumentException("DataBean URL is null.");
        }
        if (!"file".equals(url.getProtocol())) {
            throw new IllegalArgumentException("Protocol of " + url.toString() + " is not \"file\".");
        }
        if (!this.getZipFile(location).getName().endsWith(".zip")) {
            throw new IllegalArgumentException("Not a session file.");
        }
        if (url.getRef() == null || url.getRef().length() == 0) {
            throw new IllegalArgumentException("Reference is null or empty.");
        }
    }

    private File getZipFile(DataManager.ContentLocation location) {
        File zipFile;
        try {
            URI beanURI = location.getUrl().toURI();
            URI zipURI = new URI(beanURI.getScheme(), beanURI.getSchemeSpecificPart(), null);
            zipFile = new File(zipURI);
        }
        catch (URISyntaxException use) {
            throw new IllegalArgumentException(location.getUrl() + " does not point to a file.");
        }
        return zipFile;
    }

    @Override
    public void markDeletable(DataManager.ContentLocation location) {
    }

    @Override
    public OutputStream getOutputStream(DataManager.ContentLocation location) throws IOException {
        throw new UnsupportedOperationException("zip content handler does not support output");
    }

    @Override
    public boolean isAccessible(DataManager.ContentLocation location) {
        this.checkCompatibility(location);
        try {
            ZipFile zipFile = this.createZipFile(location);
            return zipFile.getEntry(location.getUrl().getRef()) != null;
        }
        catch (IOException e) {
            return false;
        }
    }
}

