/*
 * Decompiled with CFR 0.152.
 */
package fi.csc.microarray.databeans.fs;

import fi.csc.microarray.ClientContextUtil;
import fi.csc.microarray.client.Session;
import fi.csc.microarray.databeans.ContentChangedEvent;
import fi.csc.microarray.databeans.DataBean;
import fi.csc.microarray.databeans.DataChangeEvent;
import fi.csc.microarray.databeans.DataChangeListener;
import fi.csc.microarray.databeans.DataItemCreatedEvent;
import fi.csc.microarray.databeans.DataItemRemovedEvent;
import fi.csc.microarray.databeans.DataManager;
import fi.csc.microarray.databeans.LinksChangedEvent;
import fi.csc.microarray.module.ModuleManager;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class FSDataEventTest
implements DataChangeListener {
    DataChangeEvent lastEvent = null;
    boolean gotTwice = false;

    @Before
    public void init() throws Exception {
        ClientContextUtil.setupClientContext();
    }

    @Test
    public void testEvents() throws Exception {
        DataManager manager = new DataManager();
        ModuleManager moduleManager = new ModuleManager("fi.csc.microarray.module.chipster.MicroarrayModule");
        moduleManager.plugAll(manager, null);
        moduleManager.plugAll(manager, Session.getSession());
        manager.addDataChangeListener(this);
        manager.setEventsEnabled(true);
        DataBean bean1 = manager.createLocalTempDataBean("My bean.txt");
        ClientContextUtil.setupDatabean(bean1);
        this.assertNoEvent();
        DataBean bean2 = manager.createLocalTempDataBean("My other bean.txt");
        ClientContextUtil.setupDatabean(bean2);
        this.assertNoEvent();
        bean1.addLink(DataBean.Link.DERIVATION, bean2);
        this.assertNoEvent();
        manager.connectChild(bean1, manager.getRootFolder());
        this.assertDataCreatedEvent();
        manager.connectChild(bean2, manager.getRootFolder());
        this.assertDataCreatedEvent();
        bean1.addLink(DataBean.Link.ANNOTATION, bean2);
        this.assertLinksChangedEvent();
        bean1.setName("My nice bean.txt");
        this.assertContentChangedEvent();
        manager.disconnectChild(bean2, manager.getRootFolder());
        this.assertDataRemovedEvent();
    }

    private void assertDataRemovedEvent() {
        Assert.assertFalse((boolean)this.gotTwice);
        Assert.assertNotNull((Object)this.lastEvent);
        Assert.assertTrue((String)("wrong event type: " + this.lastEvent.getClass().getSimpleName()), (boolean)(this.lastEvent instanceof DataItemRemovedEvent));
        this.lastEvent = null;
    }

    private void assertContentChangedEvent() {
        Assert.assertFalse((boolean)this.gotTwice);
        Assert.assertNotNull((Object)this.lastEvent);
        Assert.assertTrue((String)("wrong event type: " + this.lastEvent.getClass().getSimpleName()), (boolean)(this.lastEvent instanceof ContentChangedEvent));
        this.lastEvent = null;
    }

    private void assertLinksChangedEvent() {
        Assert.assertFalse((boolean)this.gotTwice);
        Assert.assertNotNull((Object)this.lastEvent);
        Assert.assertTrue((String)("wrong event type: " + this.lastEvent.getClass().getSimpleName()), (boolean)(this.lastEvent instanceof LinksChangedEvent));
        this.lastEvent = null;
    }

    private void assertDataCreatedEvent() {
        Assert.assertFalse((boolean)this.gotTwice);
        Assert.assertNotNull((Object)this.lastEvent);
        Assert.assertTrue((String)("wrong event type: " + this.lastEvent.getClass().getSimpleName()), (boolean)(this.lastEvent instanceof DataItemCreatedEvent));
        this.lastEvent = null;
    }

    private void assertNoEvent() {
        Assert.assertNull((Object)this.lastEvent);
    }

    @Override
    public void dataChanged(DataChangeEvent event) {
        if (this.lastEvent != null) {
            this.gotTwice = true;
        } else {
            this.lastEvent = event;
        }
    }
}

