/*
 * Decompiled with CFR 0.152.
 */
package fi.csc.microarray.databeans.features.table;

import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class EditableTable {
    private static final Logger logger = Logger.getLogger(EditableTable.class);
    private static final String SEPARATOR = "\t";
    private HashMap<String, List<String>> columns = new HashMap();
    private LinkedList<String> columnNames = new LinkedList();

    public void addColumns(Map<String, List<String>> newColumns) {
        this.columnNames.addAll(newColumns.keySet());
        this.columns.putAll(newColumns);
    }

    public void addColumn(String columnName, int afterColumn, List<String> values) {
        if (this.columns.containsKey(columnName)) {
            throw new IllegalArgumentException("column " + columnName + " exists already");
        }
        this.columnNames.add(afterColumn, columnName);
        this.columns.put(columnName, values);
    }

    public void removeColumn(String columnName) {
        this.columnNames.remove(columnName);
        this.columns.remove(columnName);
    }

    public void addColumn(String columnName, List<String> values) {
        if (this.columns.containsKey(columnName)) {
            throw new IllegalArgumentException("column " + columnName + " exists already");
        }
        this.columnNames.add(columnName);
        this.columns.put(columnName, values);
    }

    public int getColumnCount() {
        return this.columns.size();
    }

    public void setValue(String columnName, int rowIndex, String value) {
        this.columns.get(columnName).set(rowIndex, value);
    }

    public int getRowCount() {
        int count = -1;
        for (List<String> column : this.columns.values()) {
            if (count == -1) {
                count = column.size();
            }
            if (count == column.size()) continue;
            throw new RuntimeException("column counts " + count + " and " + column.size() + " do not match");
        }
        return count;
    }

    public void writeTo(OutputStream out) {
        logger.debug((Object)("writing data out, has " + this.columns.keySet().size() + " columns"));
        PrintWriter writer = new PrintWriter(new OutputStreamWriter(out));
        Iterator columnIter = this.columnNames.iterator();
        while (columnIter.hasNext()) {
            String name = (String)columnIter.next();
            writer.print(name);
            if (!columnIter.hasNext()) continue;
            writer.print(SEPARATOR);
        }
        writer.print("\n");
        for (int i = 0; i < this.getRowCount(); ++i) {
            Iterator columnIter2 = this.columnNames.iterator();
            while (columnIter2.hasNext()) {
                List<String> column = this.columns.get(columnIter2.next());
                writer.print(column.get(i));
                if (!columnIter2.hasNext()) continue;
                writer.print(SEPARATOR);
            }
            writer.print("\n");
        }
        writer.flush();
        logger.debug((Object)("" + this.getRowCount() + " rows written"));
    }

    public Iterable<String> getColumnNames() {
        return this.columnNames;
    }

    public String getValue(String columnName, int rowIndex) {
        return this.columns.get(columnName).get(rowIndex);
    }

    public String getColumnName(int columnIndex) {
        return this.columnNames.get(columnIndex);
    }

    public boolean containsColumn(String columnName) {
        return this.columnNames.contains(columnName);
    }
}

